#version 410 core

uniform vec2 uResolution;
uniform sampler2D uChannelA;
uniform sampler2D uChannelB;
uniform sampler2D uChannelC;
uniform sampler2D uChannelD;

//out vec2 UV;

out vec4 color;

void main () {

    ivec2 s = ivec2(uResolution.x, uResolution.y);
    int i = (gl_VertexID) + s.x*gl_InstanceID;

    vec2 so = vec2(  1.0/uResolution.x, 1.0/uResolution.y );

    vec2 uv;
    uv.x = mod( i, s.x )/s.x;
    uv.y = floor( i/s.x )/s.y;
    uv += so/2.0; // center vertex to pixel

    vec3 pos = texture(uChannelA, uv.xy).xyz;
    float ttl = texture(uChannelA, uv.xy).w;

    pos.xy = pos.xy*2.0 - 1.0;

    color = texture(uChannelB, uv.xy);
    gl_PointSize = (1.0 - (pos.z/2.0 + .5)) * 10.0;
    //color += (color.b/2.0 + .5)*.5;
    color.a = .5;
    if( (color.r+color.g+color.b)/3 >= 1.0)
        color.a = 0.0;

    gl_Position = vec4(pos,ttl);
}
