#version 410 core

uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;
uniform mat4 uModelMatrix;

uniform vec3 uDiffuseColor;
uniform vec3 uLightPosition;

uniform sampler2D uTexture;
uniform sampler2D uDisplaceMap;
uniform float uDisplaceAmount;

layout (location = 0) in vec3 vertexPosition;
layout (location = 1) in vec3 normalVector;
layout (location = 2) in vec3 textureCoordinates;

out vec4 vDiffuseColor;
out vec3 vNormal;
out vec3 vTexCoord;

out vec3 vPositionES;
out vec3 vNormalES;
out vec3 vLightPositionES;

void main() {
    
    mat4 modelViewMatrix = uProjectionMatrix * uViewMatrix * uModelMatrix;
    
    gl_Position = modelViewMatrix * vec4(vertexPosition, 1);
    
    vDiffuseColor = vec4(0,1,1,1); // uDiffuseColor
    vNormal = normalize( (modelViewMatrix * vec4(normalVector, 0)).xyz );
    vTexCoord = textureCoordinates;
    
    /*
    vec3 pos = vertexPosition;
    
    
    // Output block

    
    vLightPositionES = vec3( uViewMatrix * vec4(uLightPosition, 1) );
    
    vPositionES = vec3( uViewMatrix * uModelMatrix * vec4(pos, 1) );
    vNormalES = vec3( uViewMatrix * uModelMatrix * vec4(normal, 0) );
    // SRT
    // T*R*S*v
    gl_Position = modelViewMatrix * vec4(pos,1);
     */
}
