#version 330

layout( location = 0 ) in vec3 InVertex;

uniform mat4 uViewMatrix;
uniform mat4 uProjectionMatrix;
uniform mat4 uModelMatrix;

uniform sampler2D uNoiseTexSampler;

uniform vec4 uNoiseBias;
uniform float uNoiseMagnitude;

uniform float uCenterGravity;
uniform float uCenterPulse;

uniform vec2 uNoiseScroll;

void main()
{
  vec3 pos = InVertex;
  vec4 heightValues = texture( uNoiseTexSampler, ( InVertex.xz + uNoiseScroll ) / 512.0 ).xyzw;
  vec4 biasedHeights = uNoiseBias * heightValues;
  pos.y += ( biasedHeights.x + biasedHeights.y + biasedHeights.z + biasedHeights.w ) * uNoiseMagnitude;
  pos.xz = pos.xz * uCenterGravity;
  gl_Position = uProjectionMatrix * uViewMatrix * uModelMatrix * vec4( pos, 1.0 );
}