uniform vec2 Resolution;

uniform sampler2D Tex;
uniform sampler2D BlurTex;
uniform sampler2D BokehTex;

uniform float Intensity;
uniform float BgIntensity;
uniform float WetExp;
uniform float BokehMix;

void main()
{
	vec2 texCoord = gl_FragCoord.xy / Resolution;
	gl_FragData[0] = texture2D(Tex, texCoord) * BgIntensity + pow(texture2D(BlurTex, texCoord) * mix(vec4(1), texture2D(BokehTex, texCoord), BokehMix), WetExp) * Intensity;
}