uniform sampler2D NoiseTex2;

uniform vec3 BarsColor;

uniform float FogStart;
uniform float FogEnd;
uniform float FogExp;

uniform float BarWidth;
uniform float BarWidth2;

uniform float Flicker;
uniform float FlickerTime;

float flashyFade(float f)
{
	if (f > 1.0)
	{
		return 1.0;
	}
	else if (f > .8)
	{
		return (f - .8) / .2;
	}
	else if (f > .7)
	{
		return ((int)((f - .7) * 60.0) & 1) ? 1.0 : 0.0;
	}
	else
	{
		return 0.0;
	}
}

void main()
{
	vec3 color = BarsColor *
		step(0.0, mod((TexCoord.x + TexCoord.y) * 800.0, 10.0) - BarWidth) *
		step(0.0, mod((-TexCoord.x + TexCoord.y) * 800.0, 10.0) - BarWidth2);
	color -= (sin(texture2D(NoiseTex2, floor(vec2(TexCoord.x + TexCoord.y, -TexCoord.x + TexCoord.y) * 80.0) / 256.0).x * 2.0 * 3.141592 + FlickerTime) * .5 + .5) * pow(texture2D(NoiseTex2, floor(vec2(TexCoord.x + TexCoord.y, -TexCoord.x + TexCoord.y) * 80.0 + 40.0) / 256.0).x, 13.0) * Flicker;
	color = mix(color, vec3(0), pow(clamp((ViewDistance - FogStart) / (FogEnd - FogStart), 0.0, 1.0), FogExp));
	gl_FragData[0] = vec4(color, 1);
}
