function Machinegun(ammo) {
    this.reloadSpeed = 0.1;
    this.reloadDelay = 1;
    this.level = 3;
    this.ammo = ammo;
    this.radius = 10;

    this.proceed = function(pos) {
        if (this.reloadDelay < 0) {
            this.reloadDelay = 1;
            return this.fire(pos);
        }
        this.reloadDelay -= this.reloadSpeed;
    }

    this.fire = function(pos) {
        var volley = [];
        switch (this.level) {
            case 0:
                volley.push(new ammo(v(pos.x, pos.y), v(0, -1)));
                break;
            case 1:
                volley.push(new ammo(v(pos.x - 20, pos.y), v(0, -1)));
                volley.push(new ammo(v(pos.x + 20, pos.y), v(0, -1)));
                break;
            case 2:
                volley.push(new ammo(v(pos.x - 20, pos.y), v(1, -1)));
                volley.push(new ammo(v(pos.x, pos.y), v(0, 1)));
                volley.push(new ammo(v(pos.x + 20, pos.y), v(-1, -1)));
                break;
            case 3:
                volley.push(new ammo(v(pos.x - 20, pos.y), v(-1, -1)));
                volley.push(new ammo(v(pos.x - 5, pos.y), v(0, -1)));
                volley.push(new ammo(v(pos.x + 5, pos.y), v(0, -1)));
                volley.push(new ammo(v(pos.x + 20, pos.y), v(1, -1)));
                break;                
        }
        return volley;
    };
}


function Homing(pos, target) {
    this.position = pos;
    this.target = target;
    this.speed = 1;
    this.length = 10;
    this.direction = norm(v(target.position.x - pos.x, target.position.y - pos.y));
    this.damage = 5;
    
    this.proceed = function() {
        this.position = add(this.position, this.direction);
        this.direction = norm(v(target.position.x - pos.x, target.position.y - pos.y), this.speed);
    };

    this.getBounds = function() {
        var pos = this.position;
        var dir = this.direction;
        return rect(pos.x, pos.y,
                pos.x + this.length * dir.x, pos.y + this.length * dir.y);
    };
}

function Bullet(pos, dir) {
    this.position = pos;
    this.direction = dir;
    this.radius = 2;
    this.owner = 'player';
    this.damage = 10;
    
    this.proceed = function() {
        this.position = add(this.position, this.direction);
    };

    this.getBounds = function() {
        return rect(this.position.x - this.radius, this.position.y - this.radius,
                this.position.x + this.radius, this.position.y + this.radius);
    }
}
