function newCanvas(parent, width, height, index) {
    var canvas = document.createElement('canvas');
    canvas.width = width;
    canvas.height = height;
    canvas.style.position = "absolute";
    canvas.style["z-index"] = index;
    parent.appendChild(canvas);
    return canvas;
}

function v(x, y) {
    return {x: x, y: y};
}

function add(a, b) {
    return {x: a.x + b.x, y: a.y + b.y};
}

function dist(a, b) {
    return Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

function len(a) {
    return Math.sqrt(a.x * a.x + a.y * a.y);
}

function scale(a, scale){
    return v(a.x * scale, a.y * scale);
}

function norm(a, scale) {
    if (arguments.length === 1) {
        scale = 1;
    }
    var l = len(a);
    if (l == 0) {
        return 0;
    }
    return {x: scale * a.x / l, y: scale * a.y / l};
}

function onScreen(v) {
    return v.x >= 0 && v.x <= width && v.y >= 0 && v.y <= height;
}

function rect(x, y, x1, y1) {
    return {
        a: v(Math.min(x, x1), Math.min(y, y1)),
        b: v(Math.max(x, x1), Math.max(y, y1)),
        width: Math.abs(x1 - x),
        height: Math.abs(y1 - y)
    }
}

function inRange(a, b, c) {
    return a >= b && a <= c;
}

function sign(a){
    return a > 0 ? 1 : (a < 0 ? - 1 : 0);
}
function intersect(a, b) {
    return (inRange(a.a.x, b.a.x, b.b.x) || 
            inRange(b.a.x, a.a.x, a.b.x)) &&
           (inRange(a.a.y, b.a.y, b.b.y) || 
            inRange(b.a.y, a.a.y, a.b.y));
}

function moveAll(points, shift){
    for (var i = 0; i < points.length; i++){
	points[i].x += shift.x;
	points[i].y += shift.y;
    }
}

function rotate(a, b, angle) {
    return {
	x: (a.x - b.x) * Math.cos(angle) - (a.y - b.y) * Math.sin(angle) + b.x,
	y: (a.x - b.x) * Math.sin(angle) + (a.y - b.y) * Math.cos(angle) + b.y
    };
};
    
function poly(center, n) {
  var alpha = 0;
  var delta = Math.PI * 2 / n;
  var points = new Array();

  for (var i = 0; i < n; i++) {
      points.push(v(Math.cos(alpha), Math.sin(alpha)));
      alpha += delta;
  }
  points.push(v(Math.cos(0), Math.sin(0)));
  
  return points;
};

var shapes = {
    triangle : poly(v(0, 0), 3),
    hexagon : poly(v(0, 0), 6)
};
//