function Obstacle(position, shape, color) {
    this.position = position;
    this.alpha = 2 * Math.PI * Math.random();
    this.direction = v(Math.cos(this.alpha), Math.sin(this.alpha));
    this.owner = 'nobody';
    this.speed = 5;
    this.shape = shape;
    this.damage = 10;
    this.radius = 3;
    
    this.proceed = function(){
	this.alpha += 0.1;
	if (this.alpha >= 2 * Math.PI){
	    this.alpha -= 2 * Math.PI;
	};
	this.position = add(this.position, scale(this.direction, this.speed));
    }
    
    this.getBounds = function(){
        var p = this.position;
	var r = this.radius;
	return rect(p.x - r, p.y - r, p.x + r, p.y + r); 
    }
}

function Particles() {
    this.canvas = newCanvas(document.getElementById("content"), width, height, 500);
    this.context = this.canvas.getContext('2d');

    this.particles = [];
    
    this.proceed = function() {
        var parts = this.particles;
        var len = parts.length;
        while (len--) {
            var p = parts[len]
            p.proceed(parts);
            if (!onScreen(p.position)) {
                parts.splice(len, 1);
            }
        }
    }

    this.addParticle = function(particle) {
        particle.index = this.particles.length;
        this.particles.push(particle);
    }

    this.removeParticle = function(bullet) {
        var index = this.particles.indexOf(bullet);
        if (index !== -1) {
            this.particles.splice(index, 1);
        }
    }

    this.intersect = function(rect, owner) {
        var p = this.particles;
        for (var i = 0; i < p.length; i++) {
            if (p[i].owner !== owner && intersect(p[i].getBounds(), rect)) {
                return p[i];
            }
        }
        return null;
    }

    this.repaint = function() {
        this.canvas.width = this.canvas.width;
        var parts = this.particles;
        for (var i = 0; i < parts.length; i++) {
            parts[i].repaint(this.context);
        }
    }
}
