function Star(position, direction) {
    this.position = position;
    this.direction = direction;

    this.proceed = function() {
        this.position = add(this.position, this.direction);
    };
}

function genStars(n) {
    var particles = [];
    var x = Math.PI / 2;//Math.random() * Math.PI / 2 + Math.PI / 2;

    for (var i = 0; i < n; i++) {
        var speed = Math.random();
        var p = new Star(v(Math.random() * width, Math.random() * height), v(0.0, speed));
        p.color = 'rgba(255, 255, 255, ' + speed + ')';
        particles.push(p);
    }
    return particles;
}

function Background() {
    this.canvas = newCanvas(document.getElementById("content"), width, height, 0);
    this.canvas.id = "background";
    this.context = this.canvas.getContext('2d');
    this.stars = genStars(starCount);

    this.repaint = function() {
        var context = this.context;
        var stars = this.stars;

        context.beginPath();
        context.rect(0, 0, width, height);
        context.fillStyle = 'rgba(0, 0, 0, 0.2);';
        context.fill();

        //Stars

        for (var i = 0; i < stars.length; i++) {
            var p = stars[i];
            p.proceed();
            p.repaint(context);
            if (p.position.y > height) {
                p.position = v(Math.random() * width, -6);
            }
        }
    }
}
