from PIL import Image

def encodeImage(src):
    image = Image.open(src);
    width, height = image.size;
    run = []
    runcolor = False;
    runlength = 0;
    for y in range (0, height):
        for x in range(0, width):
            r, g, b, a = image.getpixel((x, y))
            p = ((r + g + b) / 3) > 127;
            if p == runcolor:
                runlength += 1
            else:
                run.append(runlength)
                runlength = 1
                runcolor = not runcolor
    if runlength > 0: run.append(runlength);
    return run;


data = []
for i in range(1, 149):
	data.append(encodeImage("TestDownscale_%06i.png" % i))

print(data)
