/************** SETTINGS **************/
var FPS = 30; 		// Frames per second6
var TM  = 60 / FPS; // Time modifier

var song;     		// Song audio object
var flock;			// Frame lock for frame dropping
var fnum = 0;		// Frame number;
var mc;				// Main container
var ctx;			// Canvas context
var nptrn;
var sptrn;
var noiseLevel = 1;

var songpointer = 0;

var images = [];
var imagesAdded = 0;
var imagesLoaded = 0;

var ready = false;

var curScene = null;
var curScene2 = null;

function d(msg) {$("#dbg").text(msg)}

function loadImage(src, dest) {
	dest.push(images[imagesAdded] = new Image());
	images[imagesAdded].src = src;
	images[imagesAdded].onload = function() {
		imagesLoaded++;
		if(ready && imagesLoaded == imagesAdded) setTimeout(startProgram, 2000);
	}
	imagesAdded++;
}


function fireEvents(evts, songtime) {
	for(i in evts) {
		// Scene changes
		var e = evts[i];
		if(e[1] == -1) {
			d("Pattern change: " + e[0]);
			curPattern = e[0];
			switch(e[0]) {
				case 1:
					curScene = sc_macro3;
					break;
				case 2:
					curScene = sc_compy;
					break;
				case 3: 
					curScene = sc_snow;
					break;
				case 4: 
					curScene2 = sc_pylons;
					break;
				case 5:
					curScene = sc_barbed;
					break;
				case 6:
					curScene = sc_house;
					curScene2 = null;
					break;
				case 7:
					curScene = sc_house3;
					break;
				case 8:
					curScene = sc_pylons;
					curScene2 = sc_pylons2;
					break;
				case 9:
					curScene = sc_pylons;
					curScene2 = sc_pylons2;
					break;
				case 10:
					curScene = sc_vid2;
					curScene2 = null;
					break;
				case 12:
					curScene = sc_vid3;
					break;
				case 14:
					curScene = sc_macro3;
					break;
				case 15:
					curScene = sc_macro2;
					break;
				case 16:
					curScene = sc_house4;
					curScene2 = sc_pylons;
					break;
				case 17:
					curScene = sc_house6;
					break;
				case 18:
					curScene = sc_house4;
					curScene2 = sc_fadeout;
					break;

				default:
			}
			
		}
		
		if(songtime > 77 && curPattern == 6 && e[1] == 8 && e[0] == "E-4") {
			curScene = sc_house2;
		}
		
		if(songtime > 85 && curPattern == 7 && e[1] == 8 && e[0] == "E-4") {
			curScene = sc_korsten;
		}
		
		if(songtime > 195 && curPattern == 16 && e[1] == 8 && e[0] == "E-4") {
			curScene = sc_house5;
		}
		
		if(songtime > 205 && curPattern == 17 && e[1] == 8 && e[0] == "E-4") {
			curScene = sc_house7;
		}
		
		// Fire scene events
		if(curScene) curScene.ev(evts[i]);
		if(curScene2) curScene2.ev(evts[i]);
	}
}

function findSongEvents(songtime) {
	if(songpointer < songEvents.length){
		while(songEvents[songpointer][0] < songtime) {
			fireEvents(songEvents[songpointer][1], songtime);
			songpointer++;
		}
	}
}

function log10(val) {
  return Math.log(val) / Math.log(10);
}

function linToLog(v) {
    return 1 - log10((1 - v) * 9.0 + 1.0);
}

function linToLog2(v) {
    return log10(v * 9.0 + 1.0);
}

function loadSound(file) {
	var sound = document.createElement('audio');
	
	if(sound) {
		sound.setAttribute('src', file);
		sound.load();
	}

	return sound;
}

jQuery.fn.center = function () {
    this.css("position","absolute");
    this.css("top", (($(window).height() - this.outerHeight()) / 2) + 
                                                $(window).scrollTop() + "px");
    this.css("left", (($(window).width() - this.outerWidth()) / 2) + 
                                                $(window).scrollLeft() + "px");
    return this;
}

jQuery.fn.centerH = function () {
    this.css("left", (($(window).width() - this.outerWidth()) / 2) + 
                                                $(window).scrollLeft() + "px");
    return this;
}

function drawFrame(){
	// Init frame logic
	fnum++;
	if(fnum % 2) return;
	
	
	// Do sound logic
	findSongEvents(song.currentTime + 0.1);
	
	// Draw scene
	if(curScene) curScene.proc();
	if(curScene2) curScene2.proc();
	
	// if(!(fnum%20)) curScene.ev();
	
	if(songpointer >= songEvents.length && noiseLevel > 0){
		noiseLevel -= 0.01;
	}
	
	// Draw noise
	if(noiseLevel > 0) {
		ctx.save();
		ctx.globalAlpha = 0.1 * noiseLevel;
		ctx.fillStyle = nptrn;
		ctx.translate(-Math.random() * 333, -Math.random() * 333)
		ctx.fillRect(0,0,2320,1480);
		ctx.restore();
	}

	// Release frame lock
	flock = false;
}

function main() {

	// Load and init song
	song = loadSound("data/song.ogg");
	mc = $("#mainContainer");
	ctx = mc[0].getContext('2d'); 
	
	// Load the noise
	var noise = new Image();
	noise.src = "gfx/noise.png"
	noise.onload = function() {
		nptrn = ctx.createPattern(noise, "repeat");
	}
	
	// Load the sodipattern
	var sodi = new Image();
	sodi.src = "gfx/sodi.png"
	sodi.onload = function() {
		sptrn = ctx.createPattern(sodi, "repeat");
	}
	
	// Init the logic driver
	// TODO
	
	var s = [];
	loadImage("photos/pylons_01.png", s);
	loadImage("photos/pylons_02.png", s);
	loadImage("photos/pylons_03.png", s);
	loadImage("photos/pylons_04.png", s);
	sc_pylons  = new PylonsFade(s);
	sc_pylons2 = new Pylons(s);
	
	var s = [];
	loadImage("photos/S001_01.jpg", s);
	loadImage("photos/S001_02.jpg", s);
	loadImage("photos/S001_03.jpg", s);
	loadImage("photos/S001_04.jpg", s);
	sc_macro1 = new Vibrate(s, 1);
	
	var s = [];
	loadImage("photos/S002_01.jpg", s);
	loadImage("photos/S002_02.jpg", s);
	loadImage("photos/S002_03.jpg", s);
	loadImage("photos/S002_04.jpg", s);
	sc_macro2 = new Vibrate(s, 1);
	
	var s = [];
	loadImage("photos/S003_01.jpg", s);
	loadImage("photos/S003_02.jpg", s);
	loadImage("photos/S003_03.jpg", s);
	loadImage("photos/S003_04.jpg", s);
	sc_eyes = new Vibrate(s, 5);
	
	var s = [];
	loadImage("photos/S004_01.jpg", s);
	loadImage("photos/S004_02.jpg", s);
	loadImage("photos/S004_03.jpg", s);
	loadImage("photos/S004_04.jpg", s);
	sc_houses = new Vibrate(s, 1);
	
	var s = [];
	loadImage("photos/S006_01.jpg", s);
	loadImage("photos/S006_02.jpg", s);
	loadImage("photos/S006_03.jpg", s);
	loadImage("photos/S006_04.jpg", s);
	sc_macro3 = new Vibrate(s, 1);
	
	var s = [];
	loadImage("photos/S005_01.jpg", s);
	loadImage("photos/S005_02.jpg", s);
	loadImage("photos/S005_03.jpg", s);
	loadImage("photos/S005_04.jpg", s);
	sc_snow = new Snow(s);
	
	var s = [];
	loadImage("photos/S007_01.jpg", s);
	loadImage("photos/S007_02.jpg", s);
	loadImage("photos/S007_03.jpg", s);
	loadImage("photos/S007_04.jpg", s);
	loadImage("photos/S007_05.jpg", s);
	loadImage("photos/S007_06.jpg", s);
	loadImage("photos/S007_07.jpg", s);
	loadImage("photos/S007_08.jpg", s);
	loadImage("photos/S007_09.jpg", s);
	loadImage("photos/S007_10.jpg", s);
	loadImage("photos/S007_11.jpg", s);
	loadImage("photos/S007_12.jpg", s);
	loadImage("photos/S007_12.jpg", s);
	loadImage("photos/S007_12.jpg", s);
	sc_compy = new Vibrate(s, 2);
	
	var s = [];
	loadImage("photos/house.gif", s);
	loadImage("photos/sky.jpg", s);
	sc_house = new House(s[0], s[1]);
	
	var s = [];
	loadImage("photos/house2.gif", s);
	loadImage("photos/sky.jpg", s);
	sc_house2 = new House(s[0], s[1]);
	
	
	var s = [];
	var s2 = [];
	loadImage("photos/house2.gif", s);
	for(var i = 0; i <= 29; i++) {
		loadImage(sprintf("photos/sky2_%06d.jpeg", i), s2);
	}
	sc_house4 = new House2(s[0], s2);
	
	var s = [];
	var s2 = [];
	loadImage("photos/house2.gif", s);
	for(var i = 0; i <= 29; i++) {
		loadImage(sprintf("photos/sky3_%06d.jpeg", i), s2);
	}
	sc_house5 = new House2(s[0], s2);
	
	var s = [];
	var s2 = [];
	loadImage("photos/house2.gif", s);
	for(var i = 0; i <= 29; i++) {
		loadImage(sprintf("photos/sky4_%06d.jpeg", i), s2);
	}
	sc_house6 = new House2(s[0], s2);
	
	var s = [];
	var s2 = [];
	loadImage("photos/house2.gif", s);
	for(var i = 0; i <= 29; i++) {
		loadImage(sprintf("photos/sky5_%06d.jpeg", i), s2);
	}
	sc_house7 = new House2(s[0], s2);
	
	var s = [];
	loadImage("photos/house3.gif", s);
	loadImage("photos/sky2.jpg", s);
	sc_house3 = new House(s[0], s[1]);
	
	var s = [];
	loadImage("photos/barbed_00.jpg", s);
	loadImage("photos/barbed_01.jpg", s);
	loadImage("photos/barbed_02.jpg", s);
	loadImage("photos/barbed_03.jpg", s);
	loadImage("photos/barbed_04.jpg", s);
	loadImage("photos/barbed_05.jpg", s);
	loadImage("photos/barbed_06.jpg", s);
	loadImage("photos/barbed_07.jpg", s);
	loadImage("photos/barbed_08.jpg", s);
	loadImage("photos/barbed_09.jpg", s);
	loadImage("photos/barbed_10.jpg", s);
	loadImage("photos/barbed_11.jpg", s);
	sc_barbed = new BarbedWire(s);
	
	var s = [];
	loadImage("photos/korsten_1.jpg", s);
	loadImage("photos/korsten_2.jpg", s);
	loadImage("photos/korsten_3.jpg", s);
	loadImage("photos/korsten_2.jpg", s);
	sc_korsten = new Vibrate(s, 3);
	
	
	var s = [];
	loadImage("photos/powerfence.jpg", s);
	sc_powerfence = new PowerFence(s[0]);
	
	sc_vid1 = new Grid(vid);
	sc_vid2 = new Grid(vid2);
	sc_vid3 = new Grid(vid3);
	sc_fadeout = new Fadeout();
	
	// All done
	ready = true;
}

function startProgram() {
	
	curScene = sc_macro1;
	
	// Start the song
	song.play();
	
	// setTimeout(function() {song.currentTime = 100}, 2000);
	
	// Initialize the main timer
	 // shim layer with setTimeout fallback
    window.requestAnimFrame = (function(){
      return  window.requestAnimationFrame       || 
              window.webkitRequestAnimationFrame || 
              window.mozRequestAnimationFrame    || 
              window.oRequestAnimationFrame      || 
              window.msRequestAnimationFrame     || 
              function( callback ){
				if(noiseLevel > 0) {
					window.setTimeout(callback, 1000 / 60);
				}
              };
    })();
  
    // usage: 
    // instead of setInterval(render, 16) ....
    (function animloop(){
		requestAnimFrame(animloop);
		drawFrame();
    })();
    // place the rAF *before* the render() to assure as close to 
    // 60fps with the setTimeout fallback.

}

$(window).load(main);