// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : VPOS;
    float2 Texture    : TEXCOORD0;
    float4 color : COLOR0;
    float texNum : TEXCOORD1;
};


// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};


// Global variables
sampler2D Tex0;
sampler2D Tex1;
sampler2D Tex2;
sampler2D Tex3;
sampler2D Tex4;
sampler2D Tex5;
sampler2D Tex6;


// Name: Simple Pixel Shader
// Type: Pixel shader
// Desc: Fetch texture and blend with constant color
//
PS_OUTPUT ps_main( in PS_INPUT In )
{
    PS_OUTPUT Out;                             //create an output pixel

	//if(In.texNum > 1) In.color.a = 1;
	
	if(In.texNum < 1)
    	Out.Color = tex2D(Tex0, In.Texture)*In.color;
    else if(In.texNum < 2)
    	Out.Color = tex2D(Tex1, In.Texture)*In.color; 
    else if(In.texNum < 3)
    	Out.Color = tex2D(Tex2, In.Texture)*In.color; 
    else if(In.texNum < 4)
    	Out.Color = tex2D(Tex3, In.Texture)*In.color; 
    else if(In.texNum < 5)
    	Out.Color = tex2D(Tex4, In.Texture)*In.color; 
    else if(In.texNum < 6)
    	Out.Color = tex2D(Tex5, In.Texture)*In.color;
    else
    	Out.Color = tex2D(Tex6, In.Texture)*In.color;
    	
    //Out.Color += float4(In.Texture, 0, 1);
    //Out.Color = float4(0.9f, 0.8f, 0.4, 1);   //do a simple effect
	
    return Out;                                //return output pixel
}