USEBASS2	equ	0	;if 1, use alternate second bass part from PDF

; Set all 8 values to zero
; if you want all sounds at full volume.  10 is probably 
; about the highest amount of attenuation you'll want.
;
; 000=square  001=bass  010=pitfall  011=noise
; 100=buzz    101=lead  110=saw      111=engine
soundVolArray
	byte 10,10,6,7,7,10,4,10

; Default Sound Type Setup:
; 000 0 Square  = 4
; 001 1 Bass    = 6
; 010 2 Pitfall = 7
; 011 3 Noise   = 8
;
; 100 4 Buzz    = 15
; 101 5 Lead    = 12
; 110 6 Saw     = 1
; 111 7 Engine  = 3
;
soundTypeArray
    byte 4,6,7,8
    byte 15,12,1,3

P equ %00100000     ;turns BASSx into pitfall noises

hatPattern
    byte %10001000
    byte %10001000
    byte %10001000
    byte %10001000


HATVOLUME equ 4
HATPITCH  equ 0
HATSOUND  equ 8
HATCHAN   equ 0

song1
    byte 0, 0
    byte 0, 0

    byte 0, 0
    byte 0, 0

INTROTEXT   equ *-song1
    byte 0, 0
    byte 0, 0
    byte 0, 0
    byte 0, 13

    ;TODO: move plasma to after rasterbars, put a little flavour text between
ROTOZOOMSTART equ *-song1
    byte 7, 0       ;expand on these!
    byte 0,6
    byte 7, 0
    byte 0,6

HISTORYSTART equ *-song1
    byte 8, 22
    byte 8, 23
    byte 8, 22

RASTERBARSTART equ *-song1
    byte 24, 25
    byte 24, 26

PLASMATEXT  equ *-song1
    byte 8, 22
    byte 8, 23

PLASMASTART equ *-song1
    byte 24, 25
    byte 24
BEAUTY  equ *-song1
    byte 26
PLASMAV2    equ *-song1
    byte 24, 25
    byte 24, 26

MIDDLETEXT  equ *-song1
    byte 0, 0

CURTAINSSTART equ *-song1
    byte 24, 27
    byte 24
OPTIONAL    equ *-song1
    byte 26, 24
CURTAINCONTINUE equ *-song1
    byte 27
    byte 24, 26

    ;spot reserved for possible palette demonstration
PALETTE     equ  *-song1
HATSTART equ * - song1
    byte 0
FLASHSTART  equ *-song1
    byte 0, 0, 0

    ;too soon to go into the solo stuff here
ENDTEXTSTART    equ *-song1

    byte 0, 0
    byte 0, 0
    byte 0, 0
    byte 0
ENDFLASH    equ *-song1
    byte 13

EXIT    equ *-song1
    ;exit = heavy drum on 0, separate bass on 1
    byte 16, 16
    byte 16, 21
    byte 16, 16
    byte 16, 21

INTROLENGTH equ * - song1       ;we don't want to repeat the intro
    byte 16, 16
    byte 16, 21
    byte 16, 16
    byte 16, 21

	; End of song marker
	byte 255

song2
    byte 9, 9
    byte 9, 9

    byte 10,10
    byte 10,10

    byte 4, 2
    byte 1, 3
    byte 1, 2
    byte 1, 4

    byte 4, 2
    byte 1, 3
    byte 1, 2
    byte 1, 4

    byte 4, 2
    byte 1, 3
    byte 1, 4

    ;rasterbars + plasma
    byte 4, 2
    byte 1, 3
    byte 1, 2
    byte 1, 4
    byte 4, 2
    byte 1, 3
    byte 1, 2
    byte 1, 4

    byte 4, 4

    byte 4, 2
    byte 1, 3
    byte 1, 2
    byte 1, 4

    byte 0, 0
    byte 0, 0

    byte 6,6
    byte 4, 4
    byte 6,6
    byte 4, 4

    ;exit = heavy drum on 0, separate bass on 1
    byte 17, 18
    byte 17, 19
    byte 17, 18
    byte 17, 20

    byte 17, 18
    byte 17, 19
    byte 17, 18
    byte 17, 20

	; End of song marker
	byte 255

	; Higher volume patterns
patternArrayH 						; starts at 0

	; Muted pattern
	word mute,mute,mute,mute			;0

    word Bass2_3,Bass4_5,Bass2_3,Bass4_5
    word Bass4_5_Kick,Bass6_7,Bass4_5_Kick,Bass6_7
    word Bass0,Bass4_5,Bass0,Bass4_5
    word Bass25,Bass4_5_Kick,Bass25,Bass4_5_Kick

    word mute,mute,mute,mute                ;    FREE
    word Melody0,Melody1,Melody0,Melody1
    word Melody4,Melody5,Melody6,mute
    word Melody8,Melody9,Melody10,mute
    word Bass2ND,Bass2ND,Bass2ND,Bass2ND
    word Bass2_3,Bass2ND,Bass2_3,Bass2ND
    word mute,mute,mute,mute                ;    FREE
    word mute,mute,mute,mute                ;    FREE
    word mute,mute,mute,PitfallJump
    word mute,mute,mute,mute                ;    FREE
    word mute,mute,mute,mute                ;    FREE
    word DrumsOnly0,DrumsOnly1,DrumsOnly2,DrumsOnly3

    word Bass2_3ND,Bass4_5ND,Bass2_3ND,Bass4_5ND
    word Bass4_5ND,Bass6_7ND,Bass4_5ND,Bass6_7ND
    word Bass0ND,Bass4_5ND,Bass0ND,Bass4_5ND
    word Bass25ND,Bass4_5ND,Bass25ND,Bass4_5ND  ;20

    word DrumsOnly0,DrumsOnly3,DrumsOnly2,DrumsOnly3

    word Melody10,Melody10,Melody10,mute
    word Melody11,Melody12,Melody10,mute

    word Melody13,Melody9,Melody14,Melody9
    word Melody14,Melody14,Melody14,mute        ;25
    word Melody15,Melody16,Melody14,mute

    word Melody14,Melody14,Melody14,Melody13

KICKSTART	equ	%10011110
SNARESTART	equ	%10000100

PitfallJump
    byte 255, 255
    byte %11000110, %11000110
    byte %11000100, %11000011
    byte %11000010, %11000100
    byte %11111111

Melody0
    byte BASS8+P,BASS8+P
    byte BASS8+P,BASS8+P
    byte BASS10+P,BASS10+P
    byte BASS10+P,BASS8+P
    byte %11001001

Melody1
    byte BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P
    byte %11001100

Melody4
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte %11001010

Melody5
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte %11001100

Melody6
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte %11111000

Bass0ND
    byte BASS2, BASS2
    byte BASS2, 255
    byte BASS2, 255
    byte BASS2, BASS2
    byte %11001011

Bass0
    byte KICKSTART, BASS2
    byte BASS2, 255
    byte BASS2, 255
    byte BASS2, BASS2
    byte %11001011

Bass25ND
    byte BASS2, BASS2
    byte BASS2, 255
    byte BASS5, 255
    byte BASS5, 255
    byte %11001010

Bass25
    byte KICKSTART, BASS2
    byte BASS2, 255
    byte BASS5, 255
    byte BASS5, 255
    byte %11001010

Bass2ND
    byte BASS2, BASS2
    byte BASS2, BASS2
    byte BASS2, BASS2
    byte BASS2, BASS2
    byte %11100000

Bass2_3ND
    byte BASS2, BASS2
    byte BASS2, 255
    byte BASS3, BASS3
    byte BASS3, 255
    byte %11001100

Bass2_3
    byte KICKSTART, BASS2
    byte BASS2, 255
    byte BASS3, BASS3
    byte BASS3, 255
    byte %11001100

Bass4_5ND
    byte BASS4, BASS4
    byte BASS4, 255
    byte BASS5, BASS5
    byte BASS5, 255
    byte %11001100

Bass4_5
    byte SNARESTART, BASS4
    byte BASS4, 255
    byte BASS5, BASS5
    byte BASS5, 255
    byte %11001100

Bass4_5_Kick
    byte KICKSTART, BASS4
    byte BASS4, 255
    byte BASS5, BASS5
    byte BASS5, 255
    byte %11001100

Bass6_7ND
    byte BASS6, BASS6
    byte BASS6, 255
    byte BASS7, BASS7
    byte BASS7, 255
    byte %11001100

Bass6_7
    byte SNARESTART, BASS6
    byte BASS6, 255
    byte BASS7, BASS7
    byte BASS7, 255
    byte %11001100

DrumsOnly0
DrumsOnly2
    byte %10011110, %01111110, %01111110, %01111110 ;Kick
    byte %01111110, %01111110, %01111110, %01111110 ;Kick (continued)
    byte %10000000

DrumsOnly1
    byte %10010110, %01110110 ;Tom
    byte %10000100, %01100100, %01100101, %01100101 ;Snare
    byte %01100101, %01100101
    byte %10100000

DrumsOnly3
    byte %10010110, %01110110,%01110110,%01110110 ;Tom
    byte %10010110, %01110110,%01110110,%01110110 ;Tom
    byte %11001000

Melody8
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P,BASS11+P,BASS11+P
    byte %11001010

Melody9
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte %10001100


Melody10
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte %10001000

Melody11
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte %11000000

Melody12
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte BASS10+P,BASS10+P,BASS10+P,BASS10+P
    byte %10101010

Melody13
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte BASS11+P,BASS11+P,BASS11+P,BASS11+P
    byte %11001100

Melody14
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte BASS13+P,BASS13+P,BASS12+P,BASS12+P
    byte %11001010

Melody15
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte BASS12+P,BASS12+P,BASS12+P,BASS12+P
    byte %1100000

Melody16
    byte BASS12+P,BASS12+P,BASS13+P,BASS13+P
    byte BASS12+P,BASS12+P,BASS13+P,BASS13+P
    byte %10101010

mute
	byte 255,255,255,255
	byte 255,255,255,255

	byte 255

;Setup #1 (red)
BASS0   equ [%00111111]     ;B+0
BASS1   equ [%00111101]     ;C+1
BASS2   equ [%00111010]     ;D1
BASS3   equ [%00110111]     ;E1
BASS4   equ [%00110011]     ;G1
BASS5   equ [%00110001]     ;A1
BASS6   equ [%00101111]     ;B1
BASS7   equ [%00101110]     ;C+2
BASS8   equ [%00101011]     ;E2
BASS9   equ [%00101001]     ;G2
BASS10  equ [%00101000]     ;A+2
BASS11  equ [%00100111]     ;B2
BASS12  equ [%00100101]     ;E+3
BASS13  equ [%00100100]     ;G+3
BASS14  equ [%00100011]     ;B+3
BASS15  equ [%00100010]     ;E+4
BASS16  equ [%00100001]     ;B+4
BASS17  equ [%00100000]     ;B5

MEL0    equ [%10111110]     ;E+3
MEL1    equ [%10111100]     ;F+3
MEL2    equ [%10111001]     ;G+3
MEL3    equ [%10110110]     ;A+3
MEL4    equ [%10110101]     ;A#+3
MEL5    equ [%10101100]     ;G4
MEL6    equ [%10101010]     ;A#4
MEL7    equ [%00011110]     ;B+4
MEL8    equ [%00011100]     ;C+5
MEL9    equ [%00011001]     ;D+5
MEL10   equ [%00010110]     ;E+5
MEL11   equ [%00010101]     ;F5
MEL12   equ [%00001100]     ;E6
MEL13   equ [%00001010]     ;F6

SAW0    equ [%11011110]     ;C+2
SAW1    equ [%11011011]     ;D2
SAW2    equ [%11011001]     ;D#+2
SAW3    equ [%11010101]     ;F#+2
SAW4    equ [%11001100]     ;D#3
SAW5    equ [%11001010]     ;F#3
