RasterbarKernel
    lda #LINES-1
    sta line
    lda #0
    ;clc

RasterbarBaseKernel
    sta WSYNC

    sta COLUBK

    ;a few places below are marked where the kernel loader could
    ;insert extra instructions, generating more effects
    lda frame
    asl ;can be inserted here
    adc line
    ;asl ;can be inserted here
    tax
    lda SinTab,X
    ;lsr ;can be instered here
    asr #$FE    ;clc
    adc line
    tax
    ldy SinTab,X

    lda line
    and #$07
    tax
    tya
    adc DithPat,X   ;DithPat is even, eats carry
    lsr
    lsr
    lsr
    asr #$FE    ;clc
    tax
    lda rampalette,X
    ;store color after WSYNC = prettier

    dec line
    bne RasterbarBaseKernel
    jmp KernelRet

RasterbarLogic
    lda measure
    and #1
    beq NoPaletteShift
    inc palofs
NoPaletteShift

    lda palofs
    lsr
    lsr
    tay
    ldx #15
LoadPalette
    tya
    and #31
    tay
    lda Palette,Y
    sta rampalette,X
    iny
    dex
    bpl LoadPalette

    brk ;jmp LogicRet

DithPat
    .byte 0
    .byte 8
    .byte 4
    .byte 10
    .byte 2
    .byte 12
    .byte 6
    .byte 14

Palette
    ;beige/green
    .byte $2E
    .byte $2C
    .byte $2A
    .byte $28
    .byte $26
    .byte $24
    .byte $22
    .byte $20

    ;green
    .byte $50
    .byte $52
    .byte $54
    .byte $56
    .byte $58
    .byte $5A
    .byte $5C
    .byte $5E

    ;dark blue
    .byte $7E
    .byte $7C
    .byte $7A
    .byte $78
    .byte $76
    .byte $74
    .byte $72
    .byte $70

    ;green
    .byte $50
    .byte $52
    .byte $54
    .byte $56
    .byte $58
    .byte $5A
    .byte $5C
    .byte $5E
