CURTAINPAD  equ LINES-4*NXS-3

PF2Tab
    .byte %00000000^255 ;   0
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000001^255
    .byte %00000011^255
    .byte %00000111^255
    .byte %00001111^255 ;   15
PF0Tab
    .byte %00011111^255 ;0
    .byte %00111111^255
    .byte %01111111^255
    .byte %11111111^255 ;3  19
#if 1
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255 ;19
    .byte %11111111^255
#endif

PF1Tab
    .byte %00000000^255 ;0
    .byte %00000000^255
    .byte %00000000^255
    .byte %00000000^255
    .byte %10000000^255
    .byte %11000000^255
    .byte %11100000^255
    .byte %11110000^255
    .byte %11111000^255
    .byte %11111100^255
    .byte %11111110^255
    .byte %11111111^255 ;11
#if 1
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255
    .byte %11111111^255 ;20
#endif

CurtainsLogic
    ldx #NXS-1
XsLoop
    txa
    clc
    adc frame
    asl
    tay
    txa
    clc
    adc SinTab,Y
    ror
    tay
    lda SinTab,Y
    lsr
    lsr
    sta xs,X
    dex
    bpl XsLoop

    lda xs+NXS-1
    sta lastx
    sta xmin
    sta xmax
    clc
    adc #86
    ldx #4              ;BL
    jsr PositionObject

    lda xmin
    ldx #0              ;P0
    jsr PositionObject

    lda xmin
    clc
    adc #80
    ldx #1              ;P1
    jsr PositionObject

    lda xmax
    clc
    adc #5
    ldx #2              ;M0
    jsr PositionObject

    lda xmax
    clc
    adc #85
    ldx #3              ;M1
    jsr PositionObject

    sta WSYNC
    sta HMOVE

    lda #$20
    sta NUSIZ0
    sta NUSIZ1
    lda #$30
    sta CTRLPF
    lda #$2E
    sta COLUPF  ;ball
    lda #$48
    sta COLUP0  ;playfield/P0
    sta COLUP1

    lda #0
    sta pfs+0
    sta pfs+1
    sta pfs+2
    sta hmmnext
    sta hmpnext
    brk ;jmp LogicRet

CurtainsKernel
    ldx #CURTAINPAD/2
CurtainsKernelPadTop
    sta WSYNC
    dex
    bne CurtainsKernelPadTop

    sta WSYNC
    lda #2
    sta ENAM0
    sta ENAM1
    ;sta ENABL
    lda #$0F
    sta GRP0
    sta GRP1

    sta HMCLR
    lda #NXS-1
    sta cline
CurtainsKernelLoop
    lda hmmnext
    sta HMM0
    sta HMM1
    lda hmpnext
    sta HMP0
    sta HMP1

    sta WSYNC
    sta HMOVE

    ;lda pfs+0
    ;sta PF0
    lda pfs+1
    sta PF1

    lda lastx
    clc
    adc #$80
    sta COLUBK

    lda pfs+2
    sta PF2

    ldx cline

    lda xs-1,X
    sta lastx
    tay

    ;update xmin, xmax
    lda xmin
    sec
    sta HMCLR
    sbc lastx
    bcs DoXmin

    SLEEP 7
    lda #0
    jmp DoneXmin

DoXmin
    asl
    asl
    asl
    asl
    sty xmin
DoneXmin
    sta hmpnext

    lda xmax
    sec
    sbc lastx

    nop 0
    sta HMOVE

    bcc DoXmax

    SLEEP 7
    lda #0
    jmp DoneXmax

DoXmax
    asl
    asl
    asl
    asl
    sty xmax
DoneXmax
    sta hmmnext

    lda xmin
    lsr
    lsr
    cmp #20
    bcs ClampXmin   ;>= 20
    sta xminl
    lda #0
    jmp FinishXminR
ClampXmin
    ldx #20
    stx xminl
    sbc #20
FinishXminR
    sta xminr

    lda xmax
    lsr
    lsr
    cmp #20
    bcs ClampXmax   ;>= 20
    sta xmaxl
    lda #0
    jmp FinishXmaxR
ClampXmax
    ldx #20
    stx xmaxl
    sbc #20
FinishXmaxR
    sta xmaxr

    ldx xminl
    ldy xmaxl
    ;lda PF0Tab,X
    ;eor PF0Tab,Y
    ;sta pfs+0
    lda PF1Tab,X

    nop
    sta HMOVE

    eor PF1Tab,Y
    sta pfs+1
    lda PF2Tab,X
    eor PF2Tab,Y
    sta pfs+2

    sta WSYNC
    sta HMOVE

    dec cline
    bmi CurtainsKernelDone
    jmp CurtainsKernelLoop

CurtainsKernelDone
    ldx #(CURTAINPAD+1)/2
Burn
    sta WSYNC
    lda #0
    sta ENAM0
    sta ENAM1
    ;sta ENABL
    sta COLUBK
    sta COLUPF
    sta COLUP0
    sta COLUP1
    sta PF1
    sta PF2
    sta GRP0
    sta GRP1
    dex
    bpl Burn
    jmp KernelRet
