	org 0xc000
	
CALC_DELETE		equ 0x02
CALC_MULTIPLY	equ 0x04
CALC_ADDITION	equ 0x0f
CALC_SIN		equ 0x1f
CALC_INT		equ 0x27
CALC_DUPLICATE	equ 0x31
CALC_CONST		equ 0x34
CALC_STK_ZERO	equ 0xa0
CALC_ST_MEM_0	equ 0xc0
CALC_END_CALC	equ	0x38

PIXEL_ADDR	equ 0x22AA	; ROM routine to convert Y/X pixel coords in BC to screen addr in HL and bit number in A
CLS		equ 0x0DAF

sine	equ 0x8000

	call CLS
	out (254),a

; Generate a sine table
	rst 0x28
	db CALC_STK_ZERO
	db CALC_END_CALC

	ld hl,sine
sinelp
	push hl

	rst 0x28
; the accurate version
;	db CALC_CONST, 0xeb, 0x49, 0x0f, 0xda, 0xd8 ;const pi/128
; the less accurate version
;	db CALC_CONST, 0x6b, 0x49, 0x10 ;const pi/128
; the inaccurate but good enough version
	db CALC_CONST, 0x2b, 0x49 ;const pi/128
	db CALC_ADDITION
	db CALC_DUPLICATE
	db CALC_SIN
	; db CALC_CONST, 0x37, 0x70		; const 113
	; db CALC_CONST, 0x36, 0x6f		; const 60
	db CALC_CONST, 0x36, 0x4f		; const 40ish
	db CALC_MULTIPLY
	db CALC_INT
	db CALC_ST_MEM_0
	db CALC_DELETE
	db CALC_END_CALC
	ld a,(iy+0x5a)			; third byte of calculator memory 0
	pop hl
	ld (hl),a
	inc l
	jr nz,sinelp

	; fill attribute memory with random crap from the ROM, masked to give a greeny bluey palette
	ld h,0x58 ; relies on l=0 here
	ld b,e ; relies on e=0x15 here (or rather, relies on e being >=3 (to ensure the screen is covered) and small enough that it doesn't yield an address outside of ROM or clobber stuff above 0x8000)
fill_attr
	ld a,(bc)
	and 0x45
	or 0x04
	ld (hl),a
	cpi
	jp pe,fill_attr

frame_lp
;	halt
	ld ix,0x03f1	; 12ish bubbles - bubble indexes count up to 0xnn00
bubble_lp
	; for each bubble:
	ld bc,sprite ; will be rewritten to CALL sprite after the first frame,
		; so that subsequent plots are preceded by unplotting the old position
	inc a ; advance frame count
	call sprite
	dec a ; revert frame count so that the next iteration of the loop unplots the previous frame
	inc ixl ; advance bubble-position pointer
	jr nz,bubble_lp
	inc a ; actually advance frame number for the benefit of the next frame 
	ld hl,bubble_lp
	ld (hl),0xCD	; poke instruction at bubble_lp to become a CALL
	jr frame_lp

	; plot (or unplot, because we use XOR) a bubble sprite. Enter with a = frame number,
	; ix = pointer to some bit of rom to use as starting position data
sprite
	push af
	add a,(ix+0) ; frame number + bubble's initial Y position
	ld b,a ; put y position into B (which also serves as the amplitude of the sinewave)
	res 7,b ; clip to 0..127
	add a,(ix+1) ; add another per-bubble constant to vary the offset into the sine table
	; X position is the sum of two sine lookups, which are out of phase by an appropriate
	; amount to produce the required amplitude
	ld l,a
	ld h,high sine
	ld c,(hl) ; get the first of the two sines
	add a,h ; add a,128 ; for an amplitude of B, offset the second sine lookup by 128+B
	add a,b
	ld l,a
	ld a,(hl) ; get the second of the two sines
	add a,h ; add a,128 - so that the sinewave origin is at 128, the centre of screen
	add a,c ; add to the first sine
	ld c,a ; put final X position into C

	ld hl,0x3ff8	; copyright symbol in ROM. Sort of looks like a bubble if you squint.
sprite_row_lp
	push bc
	ex de,hl ; preserve sprite address in DE
	call PIXEL_ADDR
	ex de,hl ; sprite address in hl, screen address in de

	ld b,(hl)	; get line of sprite
	ld c,0

	; rotate bitmap in BC right by the number of pixels indicated in A
	inc a ; run loop 1-8 times rather than 0-7 (avoids fiddly loop pre-testing)
rota
	srl b
	rr c
	dec a
	jr nz,rota

	; XOR the bitmap line onto the screen
	ld a,(de)
	xor b
	ld (de),a
	inc e
	ld a,(de)
	xor c
	ld (de),a
	pop bc
	inc b ; move to next screen line
	inc l ; move to next line of source sprite
	jr nz,sprite_row_lp ; repeat until low byte of sprite address wraps around to 0
	pop af
	ret
