/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImage3d;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.gl.CLGLTexture;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.gl.CLGL;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import java.nio.Buffer;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLGLTexture3d<B extends Buffer>
extends CLImage3d<B>
implements CLGLObject,
CLGLTexture {
    public final int GLID;
    public final int target;
    public final int mipMapLevel;

    private CLGLTexture3d(CLContext context, B directBuffer, CLImageFormat format, CLImage.CLImageInfoAccessor accessor, int target, int mipLevel, int width, int height, int depth, long id, int glid, int flags) {
        super(context, directBuffer, format, accessor, width, height, depth, id, flags);
        this.GLID = glid;
        this.target = target;
        this.mipMapLevel = mipLevel;
    }

    static <B extends Buffer> CLGLTexture3d<B> createFromGLTexture3d(CLContext context, B directBuffer, int flags, int target, int mipLevel, int texture) {
        CLGLBuffer.checkBuffer(directBuffer, flags);
        CL cl = CLGLTexture3d.getCL(context);
        int[] result = new int[1];
        CLGL clgli = (CLGL)cl;
        long id = clgli.clCreateFromGLTexture3D(context.ID, flags, target, mipLevel, texture, result, 0);
        CLImage.CLImageInfoAccessor accessor = new CLImage.CLImageInfoAccessor(cl, id);
        CLImageFormat format = CLGLTexture3d.createUninitializedImageFormat();
        accessor.getInfo(4368, CLImageFormatImpl.size(), format.getFormatImpl().getBuffer(), null);
        int width = (int)accessor.getLong(4372);
        int height = (int)accessor.getLong(4373);
        int depth = (int)accessor.getLong(4374);
        return new CLGLTexture3d<B>(context, directBuffer, format, accessor, target, mipLevel, width, height, depth, id, texture, flags);
    }

    @Override
    public int getGLObjectID() {
        return this.GLID;
    }

    @Override
    public int getTextureTarget() {
        return this.target;
    }

    @Override
    public int getMipMapLevel() {
        return this.mipMapLevel;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_TEXTURE3D;
    }

    @Override
    public CLGLContext getContext() {
        return (CLGLContext)super.getContext();
    }

    @Override
    public GLContext getGLContext() {
        return this.getContext().getGLContext();
    }
}

