/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLProperty;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.JOCLJNILibLoader;
import com.jogamp.opencl.impl.CLTLAccessorFactory;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.CLBufferBinding;
import com.jogamp.opencl.llb.CLCommandQueueBinding;
import com.jogamp.opencl.llb.CLContextBinding;
import com.jogamp.opencl.llb.CLDeviceBinding;
import com.jogamp.opencl.llb.CLEventBinding;
import com.jogamp.opencl.llb.CLImageBinding;
import com.jogamp.opencl.llb.CLKernelBinding;
import com.jogamp.opencl.llb.CLMemObjBinding;
import com.jogamp.opencl.llb.CLPlatformBinding;
import com.jogamp.opencl.llb.CLProgramBinding;
import com.jogamp.opencl.llb.CLSamplerBinding;
import com.jogamp.opencl.llb.impl.CLImpl;
import com.jogamp.opencl.llb.impl.CLProcAddressTable;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import com.jogamp.opencl.util.Filter;
import com.jogamp.opencl.util.JOCLVersion;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLPlatform {
    public final long ID;
    public final CLVersion version;
    protected static CL cl;
    private static CLAccessorFactory defaultFactory;
    private final CLAccessorFactory factory;
    private Set<String> extensions;
    protected final CLPlatformInfoAccessor info;

    private CLPlatform(long id) {
        this(id, null);
    }

    protected CLPlatform(long id, CLAccessorFactory factory) {
        CLPlatform.initialize();
        this.ID = id;
        this.factory = factory == null ? defaultFactory : factory;
        this.info = this.factory.createPlatformInfoAccessor(cl, id);
        this.version = new CLVersion(this.getInfoString(2305));
    }

    public static void initialize() throws JogampRuntimeException {
        CLPlatform.initialize(null);
    }

    static synchronized void initialize(CLAccessorFactory factory) throws JogampRuntimeException {
        if (cl != null) {
            return;
        }
        if (defaultFactory == null) {
            defaultFactory = factory == null ? new CLTLAccessorFactory() : factory;
        }
        try {
            final CLProcAddressTable table = new CLProcAddressTable(new FunctionAddressResolver(){

                public long resolve(String name, DynamicLookupHelper lookup) {
                    long address;
                    if (name.endsWith("Impl")) {
                        name = name.substring(0, name.length() - "Impl".length());
                    }
                    if ((name.endsWith("KHR") || name.endsWith("EXT")) && (address = ((CLImpl)cl).clGetExtensionFunctionAddress(name)) != 0L) {
                        return address;
                    }
                    return lookup.dynamicLookupFunction(name);
                }
            });
            cl = new CLImpl(table);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    NativeLibrary libOpenCL = JOCLJNILibLoader.loadOpenCL();
                    if (libOpenCL == null) {
                        throw new JogampRuntimeException("OpenCL library not found.");
                    }
                    table.initEntry("clGetExtensionFunctionAddressImpl", libOpenCL);
                    table.reset(libOpenCL);
                    return null;
                }
            });
        }
        catch (UnsatisfiedLinkError ex) {
            System.err.println(JOCLVersion.getAllVersions());
            throw ex;
        }
        catch (Exception ex) {
            System.err.println(JOCLVersion.getAllVersions());
            throw new JogampRuntimeException("JOCL initialization error.", ex);
        }
    }

    public static CLPlatform getDefault() {
        CLPlatform.initialize();
        return CLPlatform.latest(CLPlatform.listCLPlatforms());
    }

    public static CLPlatform getDefault(Filter<CLPlatform> ... filter) {
        CLPlatform[] platforms = CLPlatform.listCLPlatforms(filter);
        if (platforms.length > 0) {
            return CLPlatform.latest(platforms);
        }
        return null;
    }

    private static CLPlatform latest(CLPlatform[] platforms) {
        CLPlatform best = platforms[0];
        for (CLPlatform platform : platforms) {
            if (platform.version.compareTo(best.version) <= 0) continue;
            best = platform;
        }
        return best;
    }

    public static CLPlatform[] listCLPlatforms() {
        return CLPlatform.listCLPlatforms(null);
    }

    public static CLPlatform[] listCLPlatforms(Filter<CLPlatform> ... filter) {
        CLPlatform.initialize();
        IntBuffer ib = Buffers.newDirectIntBuffer(1);
        int ret = cl.clGetPlatformIDs(0, null, ib);
        CLException.checkForError(ret, "can not enumerate platforms");
        PointerBuffer platformId = PointerBuffer.allocateDirect(ib.get(0));
        ret = cl.clGetPlatformIDs(platformId.capacity(), platformId, null);
        CLException.checkForError(ret, "can not enumerate platforms");
        ArrayList platforms = new ArrayList();
        for (int i = 0; i < platformId.capacity(); ++i) {
            CLPlatform platform = new CLPlatform(platformId.get(i));
            CLPlatform.addIfAccepted(platform, platforms, filter);
        }
        return platforms.toArray(new CLPlatform[platforms.size()]);
    }

    public static CL getLowLevelCLInterface() {
        CLPlatform.initialize();
        return cl;
    }

    public static void unloadCompiler() {
        CLPlatform.initialize();
        int ret = cl.clUnloadCompiler();
        CLException.checkForError(ret, "error while sending unload compiler hint");
    }

    public CLDevice[] listCLDevices() {
        return this.listCLDevices(CLDevice.Type.ALL);
    }

    public CLDevice[] listCLDevices(CLDevice.Type ... types) {
        CLPlatform.initialize();
        ArrayList<CLDevice> list = new ArrayList<CLDevice>();
        for (int t = 0; t < types.length; ++t) {
            CLDevice.Type type = types[t];
            long[] deviceIDs = this.info.getDeviceIDs(type.TYPE);
            for (int n = 0; n < deviceIDs.length; ++n) {
                list.add(this.createDevice(deviceIDs[n]));
            }
        }
        return list.toArray(new CLDevice[list.size()]);
    }

    public CLDevice[] listCLDevices(Filter<CLDevice> ... filters) {
        CLPlatform.initialize();
        ArrayList list = new ArrayList();
        long[] deviceIDs = this.info.getDeviceIDs(-1L);
        for (int n = 0; n < deviceIDs.length; ++n) {
            CLDevice device = this.createDevice(deviceIDs[n]);
            CLPlatform.addIfAccepted(device, list, filters);
        }
        return list.toArray(new CLDevice[list.size()]);
    }

    protected CLDevice createDevice(long id) {
        return new CLDevice(this, id);
    }

    private static <I> void addIfAccepted(I item, List<I> list, Filter<I>[] filters) {
        if (filters == null) {
            list.add(item);
        } else {
            boolean accepted = true;
            for (Filter<I> filter : filters) {
                if (filter.accept(item)) continue;
                accepted = false;
                break;
            }
            if (accepted) {
                list.add(item);
            }
        }
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] devices) {
        return CLPlatform.findMaxFlopsDevice(devices, null);
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] devices, CLDevice.Type type) {
        CLPlatform.initialize();
        CLDevice maxFLOPSDevice = null;
        int maxflops = -1;
        for (int i = 0; i < devices.length; ++i) {
            int maxClockFrequency;
            int maxComputeUnits;
            int flops;
            CLDevice device = devices[i];
            if (type != null && !type.equals((Object)device.getType()) || (flops = (maxComputeUnits = device.getMaxComputeUnits()) * (maxClockFrequency = device.getMaxClockFrequency())) <= maxflops) continue;
            maxflops = flops;
            maxFLOPSDevice = device;
        }
        return maxFLOPSDevice;
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type ... types) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(types));
    }

    public CLDevice getMaxFlopsDevice(Filter<CLDevice> ... filter) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(filter));
    }

    @CLProperty(value="CL_PLATFORM_NAME")
    public String getName() {
        return this.getInfoString(2306);
    }

    @CLProperty(value="CL_PLATFORM_VERSION")
    public CLVersion getVersion() {
        return this.version;
    }

    public String getSpecVersion() {
        return this.version.getSpecVersion();
    }

    public boolean isAtLeast(CLVersion other) {
        return this.version.isAtLeast(other);
    }

    public boolean isAtLeast(int major, int minor) {
        return this.version.isAtLeast(major, minor);
    }

    @CLProperty(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return this.getInfoString(2304);
    }

    @CLProperty(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return this.getInfoString(2307);
    }

    @CLProperty(value="CL_PLATFORM_ICD_SUFFIX_KHR")
    public String getICDSuffix() {
        return this.getInfoString(2336);
    }

    public boolean isExtensionAvailable(String extension) {
        return this.getExtensions().contains(extension);
    }

    @CLProperty(value="CL_PLATFORM_EXTENSIONS")
    public synchronized Set<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
            String ext = this.getInfoString(2308);
            Scanner scanner = new Scanner(ext);
            while (scanner.hasNext()) {
                this.extensions.add(scanner.next());
            }
            this.extensions = Collections.unmodifiableSet(this.extensions);
        }
        return this.extensions;
    }

    public Map<String, String> getProperties() {
        return CLUtil.obtainPlatformProperties(this);
    }

    public final String getInfoString(int key) {
        return this.info.getString(key);
    }

    final CLAccessorFactory getAccessorFactory() {
        return this.factory;
    }

    public final CLPlatformInfoAccessor getCLAccessor() {
        return this.info;
    }

    protected CLBufferBinding getBufferBinding() {
        return cl;
    }

    protected CLCommandQueueBinding getCommandQueueBinding() {
        return cl;
    }

    protected CLContextBinding getContextBinding() {
        return cl;
    }

    protected CLDeviceBinding getDeviceBinding() {
        return cl;
    }

    protected CLEventBinding getEventBinding() {
        return cl;
    }

    protected CLImageBinding getImageBinding() {
        return cl;
    }

    protected CLKernelBinding getKernelBinding() {
        return cl;
    }

    protected CLMemObjBinding getMemObjectBinding() {
        return cl;
    }

    protected CLPlatformBinding getPlatformBinding() {
        return cl;
    }

    protected CLProgramBinding getProgramBinding() {
        return cl;
    }

    protected CLSamplerBinding getSamplerBinding() {
        return cl;
    }

    protected CL getCLBinding() {
        return cl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name: " + this.getName() + ", vendor: " + this.getVendor() + ", profile: " + this.getProfile() + ", version: " + this.getVersion() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLPlatform other = (CLPlatform)obj;
        return this.ID == other.ID;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (int)(this.ID ^ this.ID >>> 32);
        return hash;
    }
}

