/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.llb.CLImageBinding;
import java.nio.Buffer;
import java.nio.IntBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLImage3d<B extends Buffer>
extends CLImage<B> {
    public final int depth;

    private CLImage3d(CLContext context, B directBuffer, CLImageFormat format, int width, int height, int depth, long id, int flags) {
        super(context, directBuffer, format, width, height, id, flags);
        this.depth = depth;
    }

    protected CLImage3d(CLContext context, B directBuffer, CLImageFormat format, CLImage.CLImageInfoAccessor accessor, int width, int height, int depth, long id, int flags) {
        super(context, directBuffer, format, accessor, width, height, id, flags);
        this.depth = depth;
    }

    static <B extends Buffer> CLImage3d<B> createImage(CLContext context, B directBuffer, int width, int height, int depth, int rowPitch, int slicePitch, CLImageFormat format, int flags) {
        CLImageBinding cl = context.getPlatform().getImageBinding();
        IntBuffer err = Buffers.newDirectIntBuffer(1);
        Buffer host_ptr = null;
        if (CLImage3d.isHostPointerFlag(flags)) {
            host_ptr = directBuffer;
        }
        long id = cl.clCreateImage3D(context.ID, flags, format.getFormatImpl(), width, height, depth, rowPitch, slicePitch, host_ptr, err);
        CLException.checkForError(err.get(), "can not create 2d image");
        return new CLImage3d<B>(context, directBuffer, format, width, height, depth, id, flags);
    }

    @Override
    public <T extends Buffer> CLImage3d<T> cloneWith(T directBuffer) {
        return new CLImage3d<T>(this.context, directBuffer, this.format, this.width, this.height, this.depth, this.ID, this.FLAGS);
    }

    public int getSlicePitch() {
        return (int)this.imageInfo.getLong(4371);
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public String toString() {
        return "CLImage3d [id: " + this.ID + " width: " + this.width + " height: " + this.height + " depth: " + this.depth + "]";
    }
}

