/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLEventListener;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CLEventBinding;
import com.jogamp.opencl.llb.impl.CLEventCallback;
import java.nio.Buffer;

public class CLEvent
extends CLObjectResource {
    private final CLEventInfoAccessor eventInfo;
    private final CLEventProfilingInfoAccessor eventProfilingInfo;
    private final CLEventBinding binding;

    CLEvent(CLContext context, long id) {
        super(context, id);
        this.binding = context.getPlatform().getEventBinding();
        this.eventInfo = new CLEventInfoAccessor();
        this.eventProfilingInfo = new CLEventProfilingInfoAccessor();
    }

    public void registerCallback(CLEventListener callback) {
        this.registerCallback(callback, ExecutionStatus.COMPLETE);
    }

    private void registerCallback(final CLEventListener callback, ExecutionStatus trigger) {
        this.binding.clSetEventCallback(this.ID, trigger.STATUS, new CLEventCallback(){

            public void eventStateChanged(long event, int status) {
                callback.eventStateChanged(CLEvent.this, status);
            }
        });
    }

    public void release() {
        super.release();
        int ret = this.binding.clReleaseEvent(this.ID);
        CLException.checkForError(ret, "can not release event");
    }

    public ExecutionStatus getStatus() {
        return ExecutionStatus.valueOf(this.getStatusCode());
    }

    public boolean isComplete() {
        return ExecutionStatus.COMPLETE.equals((Object)this.getStatus());
    }

    public int getStatusCode() {
        return (int)this.eventInfo.getLong(4563);
    }

    public CommandType getType() {
        int status = (int)this.eventInfo.getLong(4561);
        return CommandType.valueOf(status);
    }

    public long getProfilingInfo(ProfilingCommand command) {
        return this.eventProfilingInfo.getLong(command.COMMAND);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " name: " + (Object)((Object)this.getType()) + " status: " + (Object)((Object)this.getStatus()) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLEvent other = (CLEvent)obj;
        if (!(this.context == other.context || this.context != null && this.context.equals(other.context))) {
            return false;
        }
        return this.ID == other.ID;
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + (this.context != null ? this.context.hashCode() : 0);
        hash = 13 * hash + (int)(this.ID ^ this.ID >>> 32);
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandType {
        NDRANGE_KERNEL(4592),
        TASK(4593),
        NATIVE_KERNEL(4594),
        READ_BUFFER(4595),
        WRITE_BUFFER(4596),
        COPY_BUFFER(4597),
        READ_IMAGE(4598),
        WRITE_IMAGE(4599),
        COPY_IMAGE(4600),
        COPY_BUFFER_TO_IMAGE(4602),
        COPY_IMAGE_TO_BUFFER(4601),
        MAP_BUFFER(4603),
        MAP_IMAGE(4604),
        UNMAP_MEM_OBJECT(4605),
        MARKER(4606),
        READ_BUFFER_RECT(4609),
        WRITE_BUFFER_RECT(4610),
        COPY_BUFFER_RECT(4611),
        USER(4612),
        ACQUIRE_GL_OBJECTS(4607),
        RELEASE_GL_OBJECTS(4608),
        GL_FENCE_SYNC_OBJECT_KHR(8205);

        public final int TYPE;

        private CommandType(int type) {
            this.TYPE = type;
        }

        public static CommandType valueOf(int commandType) {
            CommandType[] values;
            for (CommandType value : values = CommandType.values()) {
                if (value.TYPE != commandType) continue;
                return value;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionStatus {
        QUEUED(3),
        SUBMITTED(2),
        RUNNING(1),
        COMPLETE(0),
        ERROR(-1);

        public final int STATUS;

        private ExecutionStatus(int status) {
            this.STATUS = status;
        }

        public static ExecutionStatus valueOf(int status) {
            switch (status) {
                case 3: {
                    return QUEUED;
                }
                case 2: {
                    return SUBMITTED;
                }
                case 1: {
                    return RUNNING;
                }
                case 0: {
                    return COMPLETE;
                }
            }
            if (status < 0) {
                return ERROR;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfilingCommand {
        QUEUED(4736),
        SUBMIT(4737),
        START(4738),
        END(4739);

        public final int COMMAND;

        private ProfilingCommand(int command) {
            this.COMMAND = command;
        }

        public static ProfilingCommand valueOf(int status) {
            switch (status) {
                case 4736: {
                    return QUEUED;
                }
                case 4737: {
                    return SUBMIT;
                }
                case 4738: {
                    return START;
                }
                case 4739: {
                    return END;
                }
            }
            return null;
        }
    }

    private class CLEventProfilingInfoAccessor
    extends CLTLInfoAccessor {
        private CLEventProfilingInfoAccessor() {
        }

        protected int getInfo(int name, long valueSize, Buffer value, PointerBuffer valueSizeRet) {
            return CLEvent.this.binding.clGetEventProfilingInfo(CLEvent.this.ID, name, valueSize, value, valueSizeRet);
        }
    }

    private class CLEventInfoAccessor
    extends CLTLInfoAccessor {
        private CLEventInfoAccessor() {
        }

        protected int getInfo(int name, long valueSize, Buffer value, PointerBuffer valueSizeRet) {
            return CLEvent.this.binding.clGetEventInfo(CLEvent.this.ID, name, valueSize, value, valueSizeRet);
        }
    }
}

