/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLExtensionNames;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLProfile;
import jogamp.opengl.ExtensionAvailabilityCache;
import jogamp.opengl.GLBufferSizeTracker;
import jogamp.opengl.GLBufferStateTracker;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDebugMessageHandler;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLStateTracker;
import jogamp.opengl.GLVersionNumber;
import jogamp.opengl.GLWorkerThread;

public abstract class GLContextImpl
extends GLContext {
    protected RecursiveLock lock = LockFactory.createRecursiveLock();
    private String contextFQN;
    private int additionalCtxCreationFlags;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private GLBufferSizeTracker bufferSizeTracker;
    private GLBufferStateTracker bufferStateTracker = new GLBufferStateTracker();
    private GLStateTracker glStateTracker = new GLStateTracker();
    private GLDebugMessageHandler glDebugHandler = null;
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap<String, ExtensionAvailabilityCache> mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLProcAddress = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLXProcAddress = new HashMap();
    boolean lockFailFast = true;
    Object lockFailFastSync = new Object();

    public static void shutdownImpl() {
        mappedExtensionAvailabilityCache.clear();
        mappedGLProcAddress.clear();
        mappedGLXProcAddress.clear();
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
        GLContextShareSet.synchronizeBufferObjectSharing(gLContext, this);
        this.drawable = gLDrawableImpl;
        this.drawableRead = gLDrawableImpl;
        this.glDebugHandler = new GLDebugMessageHandler(this);
    }

    @Override
    protected void resetStates() {
        if (this.bufferSizeTracker != null) {
            this.bufferSizeTracker.clearCachedBufferSizes();
        }
        if (this.bufferStateTracker != null) {
            this.bufferStateTracker.clearBufferObjectState();
        }
        if (this.glStateTracker != null) {
            this.glStateTracker.clearStates(false);
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        this.additionalCtxCreationFlags = 0;
        super.resetStates();
    }

    @Override
    public final void setGLReadDrawable(GLDrawable gLDrawable) {
        if (null != gLDrawable && this.drawable != gLDrawable && !this.isGLReadDrawableAvailable()) {
            throw new GLException("GL Read Drawable not available");
        }
        boolean bl = this.lock.isOwner();
        if (bl) {
            this.release();
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
    }

    @Override
    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return (GLDrawableImpl)this.getGLDrawable();
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().getSimpleName() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().getSimpleName() + ", " + gL.toString() : "<null>";
            Exception exception = new Exception("Info: setGL (OpenGL " + this.getGLVersion() + "): " + Thread.currentThread().getName() + ", " + string + " -> " + string2);
            exception.printStackTrace();
        }
        this.gl = gL;
        return gL;
    }

    protected void drawableUpdatedNotify() throws GLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSynchronized() {
        Object object = this.lockFailFastSync;
        synchronized (object) {
            return !this.lockFailFast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSynchronized(boolean bl) {
        Object object = this.lockFailFastSync;
        synchronized (object) {
            this.lockFailFast = !bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockConsiderFailFast() {
        Object object = this.lockFailFastSync;
        synchronized (object) {
            if (this.lockFailFast && this.lock.isLockedByOtherThread()) {
                throw new GLException("Error: Attempt to make context current on thread " + Thread.currentThread() + " which is already current on thread " + this.lock.getOwner());
            }
        }
        this.lock.lock();
    }

    public abstract Object getPlatformGLExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws GLException {
        if (!this.lock.isOwner()) {
            throw new GLException("Context not current on current thread");
        }
        GLContextImpl.setCurrent(null);
        try {
            this.releaseImpl();
        }
        finally {
            if (this.drawable.isSurfaceLocked()) {
                this.drawable.unlockSurface();
            }
            this.lock.unlock();
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        block11: {
            if (this.lock.isOwner()) {
                if (null != this.glDebugHandler) {
                    this.glDebugHandler.enable(false);
                }
                this.release();
            }
            this.lockConsiderFailFast();
            try {
                if (this.contextHandle == 0L) break block11;
                int n = this.drawable.lockSurface();
                if (1 == n) {
                    throw new GLException("Surface not ready to lock: " + this.drawable);
                }
                try {
                    if (DEBUG) {
                        System.err.println("GLContextImpl.destroy: " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this));
                    }
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    this.glDebugHandler = null;
                    if (GLContextShareSet.contextDestroyed(this) && !GLContextShareSet.hasCreatedSharedLeft(this)) {
                        GLContextShareSet.unregisterSharing(this);
                    }
                }
                finally {
                    this.drawable.unlockSurface();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.resetStates();
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void copy(GLContext gLContext, int n) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n2 = this.drawable.lockSurface();
        if (1 == n2) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    @Override
    public int makeCurrent() throws GLException {
        GLContext gLContext = GLContextImpl.getCurrent();
        if (gLContext != null) {
            if (gLContext == this) {
                this.drawableUpdatedNotify();
                return 1;
            }
            gLContext.release();
        }
        if (GLWorkerThread.isStarted() && !GLWorkerThread.isWorkerThread()) {
            GLWorkerThread.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        if (!this.isCreated()) {
            if (null == this.getGLDrawable().getChosenGLCapabilities()) {
                throw new GLException("drawable has no chosen GLCapabilities: " + this.getGLDrawable());
            }
            if (DEBUG_GL) {
                this.additionalCtxCreationFlags |= 0x40;
            }
        }
        this.lockConsiderFailFast();
        int n = 0;
        try {
            n = this.makeCurrentLocking();
        }
        catch (GLException gLException) {
            this.lock.unlock();
            throw gLException;
        }
        if (n == 0) {
            this.lock.unlock();
        } else {
            GLContextImpl.setCurrent(this);
            if (n == 2) {
                this.getGLDrawable().getGLProfile().verifyEquality(this.gl.getGLProfile());
                this.glDebugHandler.init(this.isGL2GL3() && this.isGLDebugEnabled());
                if (DEBUG_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Debug", null, this.gl, null));
                    if (this.glDebugHandler.isEnabled()) {
                        this.glDebugHandler.addListener(new GLDebugMessageHandler.StdErrGLDebugListener(true));
                    }
                }
                if (TRACE_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Trace", null, this.gl, new Object[]{System.err}));
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int makeCurrentLocking() throws GLException {
        boolean bl = false;
        int n = this.drawable.lockSurface();
        try {
            if (1 >= n) {
                int n2 = 0;
                return n2;
            }
            if (2 == n) {
                this.drawable.updateHandle();
            }
            if (0L == this.drawable.getHandle()) {
                throw new GLException("drawable has invalid handle: " + this.drawable);
            }
            if (!this.isCreated()) {
                boolean bl2;
                GLContextImpl gLContextImpl = (GLContextImpl)GLContextShareSet.getShareContext(this);
                if (null != gLContextImpl) {
                    gLContextImpl.getDrawableImpl().lockSurface();
                }
                try {
                    bl2 = this.createImpl(gLContextImpl);
                }
                finally {
                    if (null != gLContextImpl) {
                        gLContextImpl.getDrawableImpl().unlockSurface();
                    }
                }
                if (DEBUG) {
                    if (bl2) {
                        System.err.println(GLContextImpl.getThreadName() + ": !!! Create GL context OK: " + GLContextImpl.toHexString(this.contextHandle) + " for " + this.getClass().getName());
                    } else {
                        System.err.println(GLContextImpl.getThreadName() + ": !!! Create GL context FAILED for " + this.getClass().getName());
                    }
                }
                if (!bl2) {
                    bl = true;
                    int n3 = 0;
                    return n3;
                }
                GLContextShareSet.contextCreated(this);
                int n4 = 2;
                return n4;
            }
            this.makeCurrentImpl();
            int n5 = 1;
            return n5;
        }
        finally {
            if (bl) {
                this.drawable.unlockSurface();
            }
        }
    }

    protected abstract void makeCurrentImpl() throws GLException;

    protected abstract boolean createImpl(GLContextImpl var1) throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final long createContextARB(long l, boolean bl) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        GLProfile gLProfile2 = gLProfile.getImpl();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! createContextARB: mappedVersionsAvailableSet(" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
            this.mapGLVersions(abstractGraphicsDevice);
        }
        int n = gLProfile2.isGL4() ? 4 : (gLProfile2.isGL3() ? 3 : 2);
        boolean bl2 = gLProfile2.isGL2();
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        long l2 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, bl2 ? 2 : 4, nArray, nArray2, nArray3)) {
            nArray3[0] = nArray3[0] | this.additionalCtxCreationFlags;
            l2 = this.createContextARBImpl(l, bl, nArray3[0], nArray[0], nArray2[0]);
            if (0L != l2) {
                this.setGLFunctionAvailability(true, nArray[0], nArray2[0], nArray3[0]);
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        HashMap<String, Integer> hashMap = GLContext.deviceVersionAvailable;
        synchronized (hashMap) {
            this.createContextARBMapVersionsAvailable(4, true);
            this.createContextARBMapVersionsAvailable(4, false);
            this.createContextARBMapVersionsAvailable(3, true);
            this.createContextARBMapVersionsAvailable(3, false);
            this.createContextARBMapVersionsAvailable(2, true);
            GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
            this.resetStates();
        }
    }

    private final void createContextARBMapVersionsAvailable(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = bl ? 2 : 4;
        int n7 = 37;
        if (bl) {
            n7 &= 0xFFFFFFFB;
            n7 |= 2;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (4 == n) {
            n5 = 4;
            n4 = GLContext.getMaxMinor(n5);
            n3 = 4;
            n2 = 0;
        } else if (3 == n) {
            n5 = 3;
            n4 = GLContext.getMaxMinor(n5);
            n3 = 3;
            n2 = 1;
        } else {
            n5 = 3;
            n4 = 0;
            n3 = 1;
            n2 = 1;
        }
        long l = this.createContextARBVersions(0L, true, n7, n5, n4, n3, n2, nArray, nArray2);
        if (0L == l && !bl) {
            n7 &= 0xFFFFFFFD;
            n7 |= 4;
            n7 &= 0xFFFFFFDF;
            l = this.createContextARBVersions(0L, true, n7 |= 0x10, n5, n4, n3, n2, nArray, nArray2);
            if (0L == l) {
                n7 &= 0xFFFFFFFB;
                n7 |= 2;
                n7 &= 0xFFFFFFEF;
                l = this.createContextARBVersions(0L, true, n7 |= 0x20, n5, n4, n3, n2, nArray, nArray2);
            }
        }
        if (0L != l) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            if (this.isExtensionAvailable("GL_ARB_ES2_compatibility")) {
                n7 |= 0x100;
            }
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, n6, nArray[0], nArray2[0], n7);
            this.destroyContextARBImpl(l);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! createContextARBMapVersionsAvailable HAVE: " + GLContext.getAvailableGLVersionAsString(abstractGraphicsDevice, n, n6));
            }
        } else if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! createContextARBMapVersionsAvailable NOPE: " + n + "." + n6);
        }
    }

    private final long createContextARBVersions(long l, boolean bl, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        nArray[0] = n2;
        nArray2[0] = n3;
        long l2 = 0L;
        boolean bl2 = false;
        while (!bl2 && GLContext.isValidGLVersion(nArray[0], nArray2[0]) && (nArray[0] > n4 || nArray[0] == n4 && nArray2[0] >= n5)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0]);
            }
            if (0L != (l2 = this.createContextARBImpl(l, bl, n, nArray[0], nArray2[0]))) {
                bl2 = true;
                this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n);
            } else {
                bl2 = false;
            }
            if (bl2 && nArray[0] >= 3) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                this.gl.glGetIntegerv(33307, nArray3, 0);
                this.gl.glGetIntegerv(33308, nArray4, 0);
                boolean bl3 = bl2 = nArray3[0] > nArray[0] || nArray3[0] == nArray[0] && nArray4[0] >= nArray2[0];
                if (!bl2) {
                    this.removeCachedVersion(nArray[0], nArray2[0], n);
                    this.destroyContextARBImpl(l2);
                    l2 = 0L;
                }
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: version verification - expected " + nArray[0] + "." + nArray2[0] + ", has " + nArray3[0] + "." + nArray4[0] + " == " + bl2);
                }
            }
            if (bl2 || GLContext.decrementGLVersion(nArray, nArray2)) continue;
            break;
        }
        return l2;
    }

    private final void setContextVersion(int n, int n2, int n3) {
        if (0 == n3) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        if (n > 0 || n2 > 0) {
            if (!GLContext.isValidGLVersion(n, n2)) {
                GLException gLException = new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
                throw gLException;
            }
            this.ctxMajorVersion = n;
            this.ctxMinorVersion = n2;
            this.ctxOptions = n3;
            this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, this.getGL().glGetString(7938));
            return;
        }
        if (n == 0 && n2 == 0) {
            String string = this.getGL().glGetString(7938);
            if (null == string) {
                throw new GLException("GL_VERSION is NULL: " + this);
            }
            this.ctxOptions = n3;
            GLVersionNumber gLVersionNumber = new GLVersionNumber(string);
            if (gLVersionNumber.isValid()) {
                this.ctxMajorVersion = gLVersionNumber.getMajor();
                this.ctxMinorVersion = gLVersionNumber.getMinor();
                if ((this.ctxMajorVersion > 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion >= 1) && 0 == (this.ctxOptions & 1)) {
                    this.ctxMajorVersion = 3;
                    this.ctxMinorVersion = 0;
                }
                this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, string);
                return;
            }
        }
    }

    private Object createInstance(GLProfile gLProfile, String string, Class<?>[] classArray, Object[] objectArray) {
        return ReflectionUtil.createInstance((String)(gLProfile.getGLImplBaseClassName() + string), (Class[])classArray, (Object[])objectArray, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf((Object)object, (String)(gLProfile.getGLImplBaseClassName() + string));
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, "Impl", new Class[]{GLProfile.class, GLContextImpl.class}, new Object[]{gLProfile, this});
        return gL;
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    protected final String mapToRealGLFunctionName(String string) {
        String string2;
        Map<String, String> map = this.getFunctionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getFunctionNameMap();

    protected final String mapToRealGLExtensionName(String string) {
        String string2;
        Map<String, String> map = this.getExtensionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getExtensionNameMap();

    protected final void resetProcAddressTable(ProcAddressTable procAddressTable) {
        procAddressTable.reset((DynamicLookupHelper)this.getDrawableImpl().getGLDynamicLookupHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setGLFunctionAvailability(boolean bl, int n, int n2, int n3) {
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return;
        }
        if (null == this.gl || !this.verifyInstance(this.gl.getGLProfile(), "Impl", this.gl)) {
            this.setGL(this.createGL(this.getGLDrawable().getGLProfile()));
        }
        this.updateGLXProcAddressTable();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        int n4 = this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? 2 : 1;
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3, n4);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! Context FQN: " + this.contextFQN);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = mappedGLProcAddress.get(this.contextFQN);
            if (null != procAddressTable && !this.verifyInstance(this.gl.getGLProfile(), "ProcAddressTable", procAddressTable)) {
                throw new InternalError("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + ") -> " + procAddressTable.getClass().getName() + " not matching " + this.gl.getGLProfile().getGLImplBaseClassName());
            }
        }
        if (null != procAddressTable) {
            this.glProcAddressTable = procAddressTable;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ProcAddressTable reusing key(" + this.contextFQN + ") -> " + procAddressTable.hashCode());
            }
        } else {
            if (this.glProcAddressTable == null) {
                this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), "ProcAddressTable", new Class[]{FunctionAddressResolver.class}, new Object[]{new GLProcAddressResolver()});
            }
            this.resetProcAddressTable(this.getGLProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLProcAddress.put(this.contextFQN, this.getGLProcAddressTable());
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + this.getGLProcAddressTable().hashCode());
                }
            }
        }
        this.setContextVersion(n, n2, n3);
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object) {
            this.extensionAvailability = object;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        } else {
            if (null == this.extensionAvailability) {
                this.extensionAvailability = new ExtensionAvailabilityCache(this);
            }
            this.extensionAvailability.reset();
            object2 = mappedContextTypeObjectLock;
            synchronized (object2) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + this.extensionAvailability.hashCode());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeCachedVersion(int n, int n2, int n3) {
        Object object;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        int n4 = this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? 2 : 1;
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3, n4);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! RM Context FQN: " + this.contextFQN);
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.remove(this.contextFQN);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! RM GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        }
        object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.get(this.contextFQN);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! RM GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        }
    }

    protected abstract void updateGLXProcAddressTable();

    protected abstract StringBuffer getPlatformExtensionsStringImpl();

    public final boolean isFunctionAvailable(String string) {
        ProcAddressTable procAddressTable = this.getGLProcAddressTable();
        if (null != procAddressTable) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        String string2 = GLExtensionNames.normalizeVEN(GLExtensionNames.normalizeARB(string, true), true);
        long l = 0L;
        int n = GLExtensionNames.getFuncNamePermutationNumber(string2);
        for (int i = 0; 0L == l && i < n; ++i) {
            String string3 = GLExtensionNames.getFuncNamePermutation(string2, i);
            try {
                l = gLDynamicLookupHelper.dynamicLookupFunction(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L != l;
    }

    public boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    @Override
    public final String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    @Override
    public final String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3, int n4) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.compose8bit(n, n2, n3, n4));
    }

    protected String getContextFQN() {
        return this.contextFQN;
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public abstract int getOffscreenContextPixelDataType();

    public void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }

    @Override
    public final String getGLDebugMessageExtension() {
        return this.glDebugHandler.getExtension();
    }

    @Override
    public final boolean isGLDebugMessageEnabled() {
        return this.glDebugHandler.isEnabled();
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setContextCreationFlags(int n) {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = n & 0x40;
        }
    }

    @Override
    public final boolean isGLDebugSynchronous() {
        return this.glDebugHandler.isSynchronous();
    }

    @Override
    public final void setGLDebugSynchronous(boolean bl) {
        this.glDebugHandler.setSynchronous(bl);
    }

    @Override
    public final void enableGLDebugMessage(boolean bl) throws GLException {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = bl ? (this.additionalCtxCreationFlags |= 0x40) : (this.additionalCtxCreationFlags &= 0xFFFFFFBF);
        } else if (0 != (this.additionalCtxCreationFlags & 0x40) && null != this.getGLDebugMessageExtension()) {
            this.glDebugHandler.enable(bl);
        }
    }

    @Override
    public final void addGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.addListener(gLDebugListener);
    }

    @Override
    public final void removeGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.removeListener(gLDebugListener);
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, IntBuffer intBuffer, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, intBuffer, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, intBuffer, bl);
        }
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, int[] nArray, int n5, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, nArray, n5, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, nArray, n5, bl);
        }
    }

    @Override
    public final void glDebugMessageInsert(int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6 = n5 = null != string ? string.length() : 0;
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageInsertARB(n, n2, n3, n4, n5, string);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageInsertAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n4, n3, n5, string);
        }
    }
}

