/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.ScreenModeUtil;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.x11.X11Display;

public class X11Screen
extends ScreenImpl {
    private int[] nrotations;
    private int nrotation_index;
    private int nres_number;
    private int nres_index;
    private int[] nrates;
    private int nrate_index;
    private int nmode_number;

    @Override
    protected void createNativeImpl() {
        Long l = this.display.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<Long>(){

            @Override
            public Long run(long l) {
                long l2 = X11Screen.GetScreen0(l, X11Screen.this.screen_idx);
                if (0L != l2) {
                    X11Screen.this.setScreenSize(X11Screen.getWidth0(l, X11Screen.this.screen_idx), X11Screen.getHeight0(l, X11Screen.this.screen_idx));
                }
                return new Long(l2);
            }
        });
        if (l == 0L) {
            throw new RuntimeException("Error creating screen: " + this.screen_idx);
        }
        this.aScreen = new X11GraphicsScreen((X11GraphicsDevice)this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    @Override
    protected int[] getScreenModeFirstImpl() {
        return this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<int[]>(){

            @Override
            public int[] run(long l) {
                X11Screen.access$702(X11Screen.this, X11Screen.getAvailableScreenModeRotations0(l, X11Screen.this.screen_idx));
                if (null == X11Screen.this.nrotations || 0 == X11Screen.this.nrotations.length) {
                    return null;
                }
                X11Screen.this.nrotation_index = 0;
                X11Screen.this.nres_number = X11Screen.getNumScreenModeResolutions0(l, X11Screen.this.screen_idx);
                if (0 == X11Screen.this.nres_number) {
                    return null;
                }
                X11Screen.this.nres_index = 0;
                X11Screen.access$1502(X11Screen.this, X11Screen.getScreenModeRates0(l, X11Screen.this.screen_idx, X11Screen.this.nres_index));
                if (null == X11Screen.this.nrates || 0 == X11Screen.this.nrates.length) {
                    return null;
                }
                X11Screen.this.nrate_index = 0;
                X11Screen.this.nmode_number = 0;
                return X11Screen.this.getScreenModeNextImpl();
            }
        });
    }

    @Override
    protected int[] getScreenModeNextImpl() {
        return this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<int[]>(){

            @Override
            public int[] run(long l) {
                int[] nArray = X11Screen.getScreenModeResolution0(l, X11Screen.this.screen_idx, X11Screen.this.nres_index);
                if (null == nArray || 0 == nArray.length) {
                    return null;
                }
                if (0 >= nArray[0] || 0 >= nArray[1]) {
                    throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + X11Screen.this.nres_index + "/" + X11Screen.this.nres_number);
                }
                int n = 32;
                int n2 = X11Screen.this.nrates[X11Screen.this.nrate_index];
                if (0 >= n2) {
                    throw new InternalError("invalid rate: " + n2 + " at index " + X11Screen.this.nrate_index + "/" + X11Screen.this.nrates.length);
                }
                int n3 = X11Screen.this.nrotations[X11Screen.this.nrotation_index];
                int[] nArray2 = new int[9];
                int n4 = 0;
                nArray2[n4++] = X11Screen.this.nres_index;
                nArray2[n4++] = 0;
                nArray2[n4++] = nArray[0];
                nArray2[n4++] = nArray[1];
                nArray2[n4++] = n;
                nArray2[n4++] = nArray[2];
                nArray2[n4++] = nArray[3];
                nArray2[n4++] = n2;
                nArray2[n4++] = n3;
                nArray2[n4 - 8] = n4 - 1;
                X11Screen.this.nmode_number++;
                X11Screen.this.nrotation_index++;
                if (X11Screen.this.nrotation_index == X11Screen.this.nrotations.length) {
                    X11Screen.this.nrotation_index = 0;
                    X11Screen.this.nrate_index++;
                    if (null == X11Screen.this.nrates || X11Screen.this.nrate_index == X11Screen.this.nrates.length) {
                        X11Screen.this.nres_index++;
                        if (X11Screen.this.nres_index == X11Screen.this.nres_number) {
                            X11Screen.access$1502(X11Screen.this, null);
                            X11Screen.access$702(X11Screen.this, null);
                            return null;
                        }
                        X11Screen.access$1502(X11Screen.this, X11Screen.getScreenModeRates0(l, X11Screen.this.screen_idx, X11Screen.this.nres_index));
                        if (null == X11Screen.this.nrates || 0 == X11Screen.this.nrates.length) {
                            return null;
                        }
                        X11Screen.this.nrate_index = 0;
                    }
                }
                return nArray2;
            }
        });
    }

    @Override
    protected ScreenMode getCurrentScreenModeImpl() {
        return this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<ScreenMode>(){

            @Override
            public ScreenMode run(long l) {
                int n = X11Screen.getNumScreenModeResolutions0(l, X11Screen.this.screen_idx);
                if (0 == n) {
                    return null;
                }
                int n2 = X11Screen.getCurrentScreenResolutionIndex0(l, X11Screen.this.screen_idx);
                if (0 > n2) {
                    return null;
                }
                if (n2 >= n) {
                    throw new RuntimeException("Invalid resolution index: ! " + n2 + " < " + n);
                }
                int[] nArray = X11Screen.getScreenModeResolution0(l, X11Screen.this.screen_idx, n2);
                if (null == nArray || 0 == nArray.length) {
                    return null;
                }
                if (0 >= nArray[0] || 0 >= nArray[1]) {
                    throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n2 + "/" + n);
                }
                int n3 = X11Screen.getCurrentScreenRate0(l, X11Screen.this.screen_idx);
                if (0 > n3) {
                    return null;
                }
                int n4 = X11Screen.getCurrentScreenRotation0(l, X11Screen.this.screen_idx);
                if (0 > n4) {
                    return null;
                }
                int[] nArray2 = new int[8];
                int n5 = 0;
                nArray2[n5++] = 0;
                nArray2[n5++] = nArray[0];
                nArray2[n5++] = nArray[1];
                nArray2[n5++] = 32;
                nArray2[n5++] = nArray[2];
                nArray2[n5++] = nArray[3];
                nArray2[n5++] = n3;
                nArray2[n5++] = n4;
                nArray2[n5 - 8] = n5;
                return ScreenModeUtil.streamIn(nArray2, 0);
            }
        });
    }

    @Override
    protected boolean setCurrentScreenModeImpl(final ScreenMode screenMode) {
        ArrayHashSet<ScreenMode> arrayHashSet = this.getScreenModesOrig();
        final int n = arrayHashSet.indexOf(screenMode);
        if (0 > n) {
            throw new RuntimeException("ScreenMode not element of ScreenMode list: " + screenMode);
        }
        final long l = System.currentTimeMillis();
        boolean bl = this.runWithLockedDisplayHandle(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l2) {
                boolean bl = false;
                int n5 = X11Screen.getNumScreenModeResolutions0(l2, X11Screen.this.screen_idx);
                int n2 = X11Screen.this.getScreenModesIdx2NativeIdx().get(n);
                if (0 > n2 || n2 >= n5) {
                    throw new RuntimeException("Invalid resolution index: ! 0 < " + n2 + " < " + n5 + ", screenMode[" + n + "] " + screenMode);
                }
                int n3 = screenMode.getMonitorMode().getRefreshRate();
                int n4 = screenMode.getRotation();
                if (X11Screen.setCurrentScreenModeStart0(l2, X11Screen.this.screen_idx, n2, n3, n4)) {
                    while (!bl && System.currentTimeMillis() - l < 10000L) {
                        bl = X11Screen.setCurrentScreenModePollEnd0(l2, X11Screen.this.screen_idx, n2, n3, n4);
                        if (bl) continue;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return bl;
            }
        });
        if (DEBUG || !bl) {
            System.err.println("X11Screen.setCurrentScreenModeImpl: TO (10000) reached: " + (System.currentTimeMillis() - l) + "ms; Current: " + this.getCurrentScreenMode() + "; Desired: " + screenMode);
        }
        return bl;
    }

    private final <T> T runWithLockedDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return this.display.runWithLockedDisplayHandle(displayRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T runWithTempDisplayHandle(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        T t;
        long l = X11Util.openDisplay(this.display.getName());
        if (0L == l) {
            throw new RuntimeException("null device");
        }
        try {
            t = displayRunnable.run(l);
        }
        finally {
            X11Util.closeDisplay(l);
        }
        return t;
    }

    private final <T> T runWithoutLock(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return displayRunnable.run(this.display.getHandle());
    }

    private static native long GetScreen0(long var0, int var2);

    private static native int getWidth0(long var0, int var2);

    private static native int getHeight0(long var0, int var2);

    private static native int[] getAvailableScreenModeRotations0(long var0, int var2);

    private static native int getNumScreenModeResolutions0(long var0, int var2);

    private static native int[] getScreenModeResolution0(long var0, int var2, int var3);

    private static native int[] getScreenModeRates0(long var0, int var2, int var3);

    private static native int getCurrentScreenResolutionIndex0(long var0, int var2);

    private static native int getCurrentScreenRate0(long var0, int var2);

    private static native int getCurrentScreenRotation0(long var0, int var2);

    private static native boolean setCurrentScreenModeStart0(long var0, int var2, int var3, int var4, int var5);

    private static native boolean setCurrentScreenModePollEnd0(long var0, int var2, int var3, int var4, int var5);

    static /* synthetic */ int[] access$702(X11Screen x11Screen, int[] nArray) {
        x11Screen.nrotations = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$1502(X11Screen x11Screen, int[] nArray) {
        x11Screen.nrates = nArray;
        return nArray;
    }

    static {
        X11Display.initSingleton();
    }
}

