/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.util.LongObjectHashMap;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.x11.X11Lib;

public class X11Util {
    public static final boolean ATI_HAS_XCLOSEDISPLAY_BUG = true;
    public static final boolean XINITTHREADS_ALWAYS_ENABLED = true;
    public static final boolean HAS_XLOCKDISPLAY_BUG = true;
    private static final boolean DEBUG = Debug.debug("X11Util");
    private static final boolean TRACE_DISPLAY_LIFECYCLE = Debug.getBooleanProperty("nativewindow.debug.X11Util.TraceDisplayLifecycle", true, AccessController.getContext());
    private static String nullDisplayName = null;
    private static boolean isX11LockAvailable = false;
    private static boolean requiresX11Lock = true;
    private static volatile boolean isInit = false;
    private static boolean markAllDisplaysUnclosable = false;
    private static int setX11ErrorHandlerRecCount = 0;
    private static Object setX11ErrorHandlerLock = new Object();
    private static Object globalLock = new Object();
    private static LongObjectHashMap openDisplayMap = new LongObjectHashMap();
    private static List<NamedDisplay> openDisplayList = new ArrayList<NamedDisplay>();
    private static List<NamedDisplay> pendingDisplayList = new ArrayList<NamedDisplay>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initSingleton(boolean bl) {
        if (isInit) return;
        Class<X11Util> clazz = X11Util.class;
        synchronized (X11Util.class) {
            if (isInit) return;
            isInit = true;
            NWJNILibLoader.loadNativeWindow("x11");
            boolean bl2 = true;
            boolean bl3 = X11Util.initialize0(true);
            if (bl3) {
                // empty if block
            }
            isX11LockAvailable = false;
            long l = X11Lib.XOpenDisplay(null);
            try {
                nullDisplayName = X11Lib.XDisplayString(l);
            }
            finally {
                X11Lib.XCloseDisplay(l);
            }
            if (!DEBUG) return;
            System.err.println("X11Util firstX11ActionOnProcess: " + bl + ", requiresX11Lock " + requiresX11Lock + ", XInitThreads [called " + bl2 + ", OK " + bl3 + "]" + ", isX11LockAvailable " + isX11LockAvailable + ", X11 Display(NULL) <" + nullDisplayName + ">");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized boolean isNativeLockAvailable() {
        return isX11LockAvailable;
    }

    public static synchronized boolean requiresToolkitLock() {
        return requiresX11Lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setX11ErrorHandler(boolean bl, boolean bl2) {
        Object object = setX11ErrorHandlerLock;
        synchronized (object) {
            if (bl) {
                if (0 == setX11ErrorHandlerRecCount) {
                    X11Util.setX11ErrorHandler0(true, bl2);
                }
                ++setX11ErrorHandlerRecCount;
            } else {
                if (0 >= setX11ErrorHandlerRecCount) {
                    throw new InternalError();
                }
                if (0 == --setX11ErrorHandlerRecCount) {
                    X11Util.setX11ErrorHandler0(false, false);
                }
            }
        }
    }

    public static String getNullDisplayName() {
        return nullDisplayName;
    }

    public static boolean getMarkAllDisplaysUnclosable() {
        return markAllDisplaysUnclosable;
    }

    public static void setMarkAllDisplaysUnclosable(boolean bl) {
        markAllDisplaysUnclosable = bl;
    }

    private X11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int shutdown(boolean bl, boolean bl2) {
        int n = 0;
        if (DEBUG || bl2 || pendingDisplayList.size() > 0) {
            System.err.println("X11Util.Display: Shutdown (close open / pending Displays: " + bl + ", open (no close attempt): " + openDisplayMap.size() + "/" + openDisplayList.size() + ", pending (not closed, marked uncloseable): " + pendingDisplayList.size() + ")");
            if (DEBUG) {
                Thread.dumpStack();
            }
            if (openDisplayList.size() > 0) {
                X11Util.dumpOpenDisplayConnections();
            }
            if (pendingDisplayList.size() > 0) {
                X11Util.dumpPendingDisplayConnections();
            }
        }
        Object object = globalLock;
        synchronized (object) {
            if (bl) {
                X11Util.closePendingDisplayConnections();
                openDisplayList.clear();
                pendingDisplayList.clear();
                openDisplayMap.clear();
                X11Util.shutdown0();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int closePendingDisplayConnections() {
        int n = 0;
        Object object = globalLock;
        synchronized (object) {
            if (DEBUG) {
                System.err.println("X11Util: Closing Pending X11 Display Connections: " + pendingDisplayList.size());
            }
            for (int i = pendingDisplayList.size() - 1; i >= 0; --i) {
                NamedDisplay namedDisplay = pendingDisplayList.get(i);
                if (DEBUG) {
                    System.err.println("X11Util.closePendingDisplayConnections(): Closing [" + i + "]: " + namedDisplay);
                }
                X11Util.XCloseDisplay(namedDisplay.getHandle());
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOpenDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return openDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpOpenDisplayConnections() {
        Object object = globalLock;
        synchronized (object) {
            System.err.println("X11Util: Open X11 Display Connections: " + openDisplayList.size());
            for (int i = 0; i < openDisplayList.size(); ++i) {
                Throwable throwable;
                NamedDisplay namedDisplay = openDisplayList.get(i);
                System.err.println("X11Util: Open[" + i + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPendingDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return pendingDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpPendingDisplayConnections() {
        Object object = globalLock;
        synchronized (object) {
            System.err.println("X11Util: Pending X11 Display Connections: " + pendingDisplayList.size());
            for (int i = 0; i < pendingDisplayList.size(); ++i) {
                Throwable throwable;
                NamedDisplay namedDisplay = pendingDisplayList.get(i);
                System.err.println("X11Util: Pending[" + i + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean markDisplayUncloseable(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)openDisplayMap.get(l);
        }
        if (null != namedDisplay) {
            namedDisplay.setUncloseable(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openDisplay(String string) {
        long l = 0L;
        NamedDisplay namedDisplay = null;
        string = X11Util.validateDisplayName(string);
        boolean bl = false;
        Object object = globalLock;
        synchronized (object) {
            for (int i = 0; i < pendingDisplayList.size(); ++i) {
                if (!pendingDisplayList.get(i).getName().equals(string)) continue;
                namedDisplay = pendingDisplayList.remove(i);
                l = namedDisplay.getHandle();
                bl = true;
                break;
            }
            if (0L == l) {
                l = X11Util.XOpenDisplay(string);
                if (0L == l) {
                    throw new NativeWindowException("X11Util.Display: Unable to create a display(" + string + ") connection. Thread " + Thread.currentThread().getName());
                }
                namedDisplay = new NamedDisplay(string, l);
            }
            namedDisplay.addRef();
            openDisplayMap.put(l, (Object)namedDisplay);
            openDisplayList.add(namedDisplay);
            if (markAllDisplaysUnclosable) {
                namedDisplay.setUncloseable(true);
            }
        }
        if (DEBUG) {
            System.err.println("X11Util.Display: openDisplay [reuse " + bl + "] " + namedDisplay + ". Thread " + Thread.currentThread().getName());
        }
        return namedDisplay.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDisplay(long l) {
        Object object = globalLock;
        synchronized (object) {
            NamedDisplay namedDisplay = (NamedDisplay)openDisplayMap.remove(l);
            if (null == namedDisplay) {
                X11Util.dumpPendingDisplayConnections();
                throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") with given handle is not mapped. Thread " + Thread.currentThread().getName());
            }
            if (namedDisplay.getHandle() != l) {
                X11Util.dumpPendingDisplayConnections();
                throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") Mapping error: " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            }
            namedDisplay.removeRef();
            if (!openDisplayList.remove(namedDisplay)) {
                throw new RuntimeException("Internal: " + namedDisplay);
            }
            if (!namedDisplay.isUncloseable()) {
                X11Util.XCloseDisplay(namedDisplay.getHandle());
            } else {
                pendingDisplayList.add(namedDisplay);
            }
            if (DEBUG) {
                System.err.println("X11Util.Display: Closed (real: " + !namedDisplay.isUncloseable() + ") " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedDisplay getNamedDisplay(long l) {
        Object object = globalLock;
        synchronized (object) {
            return (NamedDisplay)openDisplayMap.get(l);
        }
    }

    public static String validateDisplayName(String string) {
        return null == string || "decon".equals(string) ? X11Util.getNullDisplayName() : string;
    }

    public static String validateDisplayName(String string, long l) {
        if ((null == string || "decon".equals(string)) && 0L != l) {
            string = X11Lib.XDisplayString(l);
        }
        return X11Util.validateDisplayName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long XOpenDisplay(String string) {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            long l = X11Lib.XOpenDisplay(string);
            if (TRACE_DISPLAY_LIFECYCLE) {
                System.err.println(Thread.currentThread() + " - X11Util.XOpenDisplay(" + string + ") 0x" + Long.toHexString(l));
            }
            long l2 = l;
            return l2;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int XCloseDisplay(long l) {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            if (TRACE_DISPLAY_LIFECYCLE) {
                System.err.println(Thread.currentThread() + " - X11Util.XCloseDisplay() 0x" + Long.toHexString(l));
            }
            int n = -1;
            X11Util.setX11ErrorHandler(true, !DEBUG);
            try {
                n = X11Lib.XCloseDisplay(l);
            }
            catch (Exception exception) {
                System.err.println("X11Util: Catched Exception:");
                exception.printStackTrace();
            }
            finally {
                X11Util.setX11ErrorHandler(false, false);
            }
            int n2 = n;
            return n2;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    private static native boolean initialize0(boolean var0);

    private static native void shutdown0();

    private static native void setX11ErrorHandler0(boolean var0, boolean var1);

    public static class NamedDisplay {
        final String name;
        final long handle;
        final int hash32;
        int refCount;
        boolean unCloseable;
        Throwable creationStack;

        protected NamedDisplay(String string, long l) {
            this.name = string;
            this.handle = l;
            this.refCount = 0;
            this.unCloseable = false;
            int n = 31 + (int)l;
            this.hash32 = n = (n << 5) - n + (int)(l >>> 32);
            this.creationStack = DEBUG ? new Throwable("NamedDisplay Created at:") : null;
        }

        public final int hashCode() {
            return this.hash32;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof NamedDisplay) {
                NamedDisplay namedDisplay = (NamedDisplay)object;
                return this.handle == namedDisplay.handle;
            }
            return false;
        }

        public final void addRef() {
            ++this.refCount;
        }

        public final void removeRef() {
            --this.refCount;
        }

        public final String getName() {
            return this.name;
        }

        public final long getHandle() {
            return this.handle;
        }

        public final int getRefCount() {
            return this.refCount;
        }

        public final void setUncloseable(boolean bl) {
            this.unCloseable = bl;
        }

        public final boolean isUncloseable() {
            return this.unCloseable;
        }

        public final Throwable getCreationStack() {
            return this.creationStack;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String toString() {
            return "NamedX11Display[" + this.name + ", 0x" + Long.toHexString(this.handle) + ", refCount " + this.refCount + ", unCloseable " + this.unCloseable + "]";
        }
    }
}

