/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceUpdatedListener;
import jogamp.nativewindow.SurfaceUpdatedHelper;

public abstract class ProxySurface
implements NativeSurface {
    private SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private AbstractGraphicsConfiguration config;
    protected RecursiveLock surfaceLock = LockFactory.createRecursiveLock();
    protected long displayHandle;
    protected int height;
    protected int scrnIndex;
    protected int width;

    public ProxySurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.invalidate();
        this.config = abstractGraphicsConfiguration;
        this.displayHandle = abstractGraphicsConfiguration.getNativeGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    void invalidate() {
        this.displayHandle = 0L;
        this.invalidateImpl();
    }

    protected abstract void invalidateImpl();

    @Override
    public final long getDisplayHandle() {
        return this.displayHandle;
    }

    protected final AbstractGraphicsConfiguration getPrivateGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public final int getScreenIndex() {
        return this.getGraphicsConfiguration().getScreen().getIndex();
    }

    @Override
    public abstract long getSurfaceHandle();

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public void surfaceSizeChanged(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lockSurface() throws NativeWindowException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getHoldCount() == 1 ? 1 : 3;
        if (1 == n) {
            try {
                AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                abstractGraphicsDevice.lock();
                try {
                    n = this.lockSurfaceImpl();
                }
                finally {
                    if (1 >= n) {
                        abstractGraphicsDevice.unlock();
                    }
                }
            }
            finally {
                if (1 >= n) {
                    this.surfaceLock.unlock();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        if (this.surfaceLock.getHoldCount() == 1) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    protected abstract int lockSurfaceImpl();

    protected abstract void unlockSurfaceImpl();

    public final void validateSurfaceLocked() {
        this.surfaceLock.validateLocked();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.surfaceLock.isLocked();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    public abstract String toString();
}

