/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.Renderer;
import com.jogamp.graph.font.Font;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.opengl.GL2ES2;
import jogamp.graph.curve.opengl.TextRendererImpl01;
import jogamp.graph.curve.text.GlyphString;

public abstract class TextRenderer
extends Renderer {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private HashMap<String, GlyphString> stringCacheMap = new HashMap(256);
    private ArrayList<String> stringCacheArray = new ArrayList(256);
    private int stringCacheLimit = 256;

    public static TextRenderer create(RenderState renderState, int n) {
        return new TextRendererImpl01(renderState, n);
    }

    protected TextRenderer(RenderState renderState, int n) {
        super(renderState, n);
    }

    public abstract void drawString3D(GL2ES2 var1, Font var2, String var3, float[] var4, int var5, int var6);

    public GlyphString createString(GL2ES2 gL2ES2, Font font, int n, String string) {
        GlyphString glyphString = GlyphString.createString(null, this.rs.getVertexFactory(), font, n, string);
        glyphString.createRegion(gL2ES2, this.renderModes);
        return glyphString;
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2) {
        for (GlyphString glyphString : this.stringCacheMap.values()) {
            glyphString.destroy(gL2ES2, this.rs);
        }
        this.stringCacheMap.clear();
        this.stringCacheArray.clear();
    }

    public final void setCacheLimit(int n) {
        this.stringCacheLimit = n;
    }

    public final void setCacheLimit(GL2ES2 gL2ES2, int n) {
        this.stringCacheLimit = n;
        this.validateCache(gL2ES2, 0);
    }

    public final int getCacheLimit() {
        return this.stringCacheLimit;
    }

    public final int getCacheSize() {
        return this.stringCacheArray.size();
    }

    protected final void validateCache(GL2ES2 gL2ES2, int n) {
        if (this.getCacheLimit() > 0) {
            while (this.getCacheSize() + n > this.getCacheLimit()) {
                this.removeCachedGlyphString(gL2ES2, 0);
            }
        }
    }

    protected final GlyphString getCachedGlyphString(Font font, String string, int n) {
        return this.stringCacheMap.get(this.getKey(font, string, n));
    }

    protected final void addCachedGlyphString(GL2ES2 gL2ES2, Font font, String string, int n, GlyphString glyphString) {
        String string2;
        GlyphString glyphString2;
        if (0 != this.getCacheLimit() && null == (glyphString2 = this.stringCacheMap.put(string2 = this.getKey(font, string, n), glyphString))) {
            this.validateCache(gL2ES2, 1);
            this.stringCacheArray.add(this.stringCacheArray.size(), string2);
        }
    }

    protected final void removeCachedGlyphString(GL2ES2 gL2ES2, Font font, String string, int n) {
        String string2 = this.getKey(font, string, n);
        GlyphString glyphString = this.stringCacheMap.remove(string2);
        if (null != glyphString) {
            glyphString.destroy(gL2ES2, this.rs);
        }
        this.stringCacheArray.remove(string2);
    }

    protected final void removeCachedGlyphString(GL2ES2 gL2ES2, int n) {
        String string = this.stringCacheArray.remove(n);
        GlyphString glyphString = this.stringCacheMap.remove(string);
        if (null != glyphString) {
            glyphString.destroy(gL2ES2, this.rs);
        }
    }

    protected final String getKey(Font font, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        return font.getName(stringBuilder, 3).append(".").append(string.hashCode()).append(".").append(n).toString();
    }
}

