/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils.wav;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jouvieje.bass.utils.FileIOUtils;
import jouvieje.bass.utils.wav.RiffChunk;

public class WavHeader {
    public static final int SIZEOF_WAV_HEADER = 12;
    private final RiffChunk chunk;
    private final byte[] rifftype;

    public WavHeader(RiffChunk chunk, byte[] rifftype) {
        this.chunk = chunk;
        this.rifftype = rifftype;
    }

    public RiffChunk getChunk() {
        return this.chunk;
    }

    public byte[] getRifftype() {
        return this.rifftype;
    }

    public void write(RandomAccessFile file, FileIOUtils io) throws IOException {
        this.chunk.write(file, io);
        io.writeByteArray(file, this.getRifftype());
    }

    public void put(ByteBuffer buffer) {
        this.chunk.put(buffer);
        buffer.put(this.getRifftype());
    }
}

