/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class WindowsDynamicLinkerImpl
implements DynamicLinker {
    private static boolean DEBUG;

    private static native int FreeLibrary(long var0);

    private static native int GetLastError();

    private static native long GetProcAddressA(long var0, String var2);

    private static native long LoadLibraryW(String var0);

    @Override
    public long openLibraryLocal(String string, boolean bl) {
        return this.openLibraryGlobal(string, bl);
    }

    @Override
    public long openLibraryGlobal(String string, boolean bl) {
        long l = WindowsDynamicLinkerImpl.LoadLibraryW(string);
        if (0L == l && bl) {
            int n = WindowsDynamicLinkerImpl.GetLastError();
            System.err.println("LoadLibraryW \"" + string + "\" failed, error code: 0x" + Integer.toHexString(n) + ", " + n);
        }
        return l;
    }

    @Override
    public long lookupSymbol(long l, String string) {
        String string2 = string;
        long l2 = WindowsDynamicLinkerImpl.GetProcAddressA(l, string2);
        if (0L == l2) {
            for (int i = 0; 0L == l2 && i <= 12; ++i) {
                string2 = string + "@" + i * 4;
                l2 = WindowsDynamicLinkerImpl.GetProcAddressA(l, string2);
            }
        }
        if (DEBUG) {
            System.err.println("WindowsDynamicLinkerImpl.lookupSymbol(0x" + Long.toHexString(l) + ", " + string + ") -> " + string2 + ", 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    @Override
    public long lookupSymbolGlobal(String string) {
        if (DEBUG) {
            System.err.println("lookupSymbolGlobal: Not supported on Windows");
        }
        return 0L;
    }

    @Override
    public void closeLibrary(long l) {
        WindowsDynamicLinkerImpl.FreeLibrary(l);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DEBUG = System.getProperty("jogamp.debug.NativeLibrary") != null;
                return null;
            }
        });
    }
}

