/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.os.Platform;

public class MachineDescriptionRuntime {
    static volatile boolean smdQueried = false;
    static MachineDescription.StaticConfig smd = null;
    static volatile boolean rmdQueried = false;
    static MachineDescription rmd = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MachineDescription.StaticConfig getStatic() {
        if (smdQueried) return smd;
        Class<MachineDescription> clazz = MachineDescription.class;
        synchronized (MachineDescription.class) {
            if (smdQueried) return smd;
            smd = MachineDescriptionRuntime.getStaticImpl();
            smdQueried = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return smd;
        }
    }

    private static boolean isCPUArch32Bit() throws RuntimeException {
        switch (Platform.CPU_ARCH) {
            case X86_32: 
            case ARM: 
            case ARMv5: 
            case ARMv6: 
            case ARMv7: 
            case SPARC_32: 
            case PPC: {
                return true;
            }
            case X86_64: 
            case IA64: 
            case SPARCV9_64: 
            case PA_RISC2_0: {
                return false;
            }
        }
        throw new RuntimeException("Please port CPU detection (32/64 bit) to your platform (" + Platform.OS_lower + "/" + Platform.ARCH_lower + "(" + (Object)((Object)Platform.CPU_ARCH) + "))");
    }

    private static MachineDescription.StaticConfig getStaticImpl() {
        if (MachineDescriptionRuntime.isCPUArch32Bit()) {
            if (Platform.getCPUFamily() == Platform.CPUFamily.ARM && Platform.isLittleEndian()) {
                return MachineDescription.StaticConfig.ARMle_EABI;
            }
            if (Platform.getOSType() == Platform.OSType.WINDOWS) {
                return MachineDescription.StaticConfig.X86_32_WINDOWS;
            }
            if (Platform.getOSType() == Platform.OSType.MACOS) {
                return MachineDescription.StaticConfig.X86_32_MACOS;
            }
            return MachineDescription.StaticConfig.X86_32_UNIX;
        }
        if (Platform.getOSType() == Platform.OSType.WINDOWS) {
            return MachineDescription.StaticConfig.X86_64_WINDOWS;
        }
        return MachineDescription.StaticConfig.X86_64_UNIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MachineDescription getRuntime() {
        if (rmdQueried) return rmd;
        Class<MachineDescription> clazz = MachineDescription.class;
        synchronized (MachineDescription.class) {
            if (rmdQueried) return rmd;
            rmd = MachineDescriptionRuntime.getRuntimeImpl();
            rmdQueried = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return rmd;
        }
    }

    private static MachineDescription getRuntimeImpl() {
        try {
            Platform.initSingleton();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return null;
        }
        int n = MachineDescriptionRuntime.getPointerSizeInBytesImpl();
        switch (n) {
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported pointer size " + n + "bytes, please implement.");
            }
        }
        long l = MachineDescriptionRuntime.getPageSizeInBytesImpl();
        if (Integer.MAX_VALUE < l) {
            throw new InternalError("PageSize exceeds integer value: " + l);
        }
        return new MachineDescription(true, Platform.isLittleEndian(), MachineDescriptionRuntime.getSizeOfIntImpl(), MachineDescriptionRuntime.getSizeOfLongImpl(), MachineDescriptionRuntime.getSizeOfFloatImpl(), MachineDescriptionRuntime.getSizeOfDoubleImpl(), MachineDescriptionRuntime.getSizeOfLongDoubleImpl(), n, (int)l, MachineDescriptionRuntime.getAlignmentInt8Impl(), MachineDescriptionRuntime.getAlignmentInt16Impl(), MachineDescriptionRuntime.getAlignmentInt32Impl(), MachineDescriptionRuntime.getAlignmentInt64Impl(), MachineDescriptionRuntime.getAlignmentIntImpl(), MachineDescriptionRuntime.getAlignmentLongImpl(), MachineDescriptionRuntime.getAlignmentFloatImpl(), MachineDescriptionRuntime.getAlignmentDoubleImpl(), MachineDescriptionRuntime.getAlignmentLongDoubleImpl(), MachineDescriptionRuntime.getAlignmentPointerImpl());
    }

    private static native int getPointerSizeInBytesImpl();

    private static native long getPageSizeInBytesImpl();

    private static native int getAlignmentInt8Impl();

    private static native int getAlignmentInt16Impl();

    private static native int getAlignmentInt32Impl();

    private static native int getAlignmentInt64Impl();

    private static native int getAlignmentIntImpl();

    private static native int getAlignmentLongImpl();

    private static native int getAlignmentPointerImpl();

    private static native int getAlignmentFloatImpl();

    private static native int getAlignmentDoubleImpl();

    private static native int getAlignmentLongDoubleImpl();

    private static native int getSizeOfIntImpl();

    private static native int getSizeOfLongImpl();

    private static native int getSizeOfPointerImpl();

    private static native int getSizeOfFloatImpl();

    private static native int getSizeOfDoubleImpl();

    private static native int getSizeOfLongDoubleImpl();
}

