/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public class RunnableTask
implements Runnable {
    Runnable runnable;
    final Object syncObject;
    boolean catchExceptions;
    Object attachment;
    Throwable runnableException;
    long ts0;
    long ts1;
    long ts2;

    public RunnableTask(Runnable runnable) {
        this(runnable, null, false);
    }

    public RunnableTask(Runnable runnable, Object object) {
        this(runnable, object, false);
    }

    public RunnableTask(Runnable runnable, Object object, boolean bl) {
        this.runnable = runnable;
        this.syncObject = object;
        this.catchExceptions = bl;
        this.ts0 = System.currentTimeMillis();
        this.ts1 = 0L;
        this.ts2 = 0L;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public Object getSyncObject() {
        return this.syncObject;
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.ts1 = System.currentTimeMillis();
        if (null == this.syncObject) {
            try {
                this.runnable.run();
                return;
            }
            catch (Throwable throwable) {
                this.runnableException = throwable;
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.ts2 = System.currentTimeMillis();
            }
        }
        Object object = this.syncObject;
        synchronized (object) {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                this.runnableException = throwable;
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.ts2 = System.currentTimeMillis();
                this.syncObject.notifyAll();
            }
            return;
        }
    }

    public boolean isExecuted() {
        return 0L != this.ts2;
    }

    public boolean hasWaiter() {
        return null != this.syncObject;
    }

    public Throwable getThrowable() {
        return this.runnableException;
    }

    public long getTimestampCreate() {
        return this.ts0;
    }

    public long getTimestampBeforeExec() {
        return this.ts1;
    }

    public long getTimestampAfterExec() {
        return this.ts2;
    }

    public long getDurationInQueue() {
        return this.ts1 - this.ts0;
    }

    public long getDurationInExec() {
        return this.ts2 - this.ts1;
    }

    public long getDurationTotal() {
        return this.ts2 - this.ts0;
    }

    public String toString() {
        return "RunnableTask[executed " + this.isExecuted() + ", t2-t0 " + this.getDurationTotal() + ", t2-t1 " + this.getDurationInExec() + ", t1-t0 " + this.getDurationInQueue() + ", throwable " + this.getThrowable() + ", Runnable " + this.runnable + ", Attachment " + this.attachment + "]";
    }
}

