/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.quadtree;

import com.js.test.terra.area.chunks.provider.ChunkProvider;
import com.js.test.terra.area.chunks.provider.impl.Coord;
import com.js.test.terra.area.quadtree.QuadTreeNode;
import com.js.test.terra.area.quadtree.generator.TestGenerator;
import com.js.test.terra.math.Vector3;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MegaQuadTreeContainer {
    private Map<String, QuadTreeNode> myNodes = new HashMap<String, QuadTreeNode>();
    private ChunkProvider myProvider;
    private Coord myOldPlayerPos;

    public MegaQuadTreeContainer(float x, float y, float z, ChunkProvider theProvider) {
        Coord aCenter;
        this.myProvider = theProvider;
        this.myOldPlayerPos = aCenter = theProvider.fromWorldToMegaChunk((int)x, (int)y, (int)z);
        int centerX = aCenter.x * theProvider.getMyMegaSizeX();
        int centerY = aCenter.y * theProvider.getMyMegaSizeY();
        int centerZ = aCenter.z * theProvider.getMyMegaSizeZ();
        int i = centerX - 1;
        while (i <= centerX + 1) {
            int j = centerY - 1;
            while (j <= centerY + 1) {
                int k = centerZ - 1;
                while (k <= centerZ + 1) {
                    this.myNodes.put(this.getHashFor(i, j, k), this.doNodeFor(i, j, k, theProvider));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void checkVisibilityOnNodes() {
        for (QuadTreeNode aNode : this.myNodes.values()) {
            aNode.checkVisibility();
        }
    }

    public void checkEmptyOnNodes() {
        for (QuadTreeNode aNode : this.myNodes.values()) {
            aNode.checkEmpty();
        }
    }

    private String getHashFor(int x, int y, int z) {
        return String.valueOf(x) + "|" + y + "|" + z;
    }

    private QuadTreeNode doNodeFor(float x, float y, float z, ChunkProvider theProvider) {
        Coord aCenter = new Coord((int)x, (int)y, (int)z);
        int centerX = aCenter.x * theProvider.getMyMegaSizeX();
        int centerY = aCenter.y * theProvider.getMyMegaSizeY();
        int centerZ = aCenter.z * theProvider.getMyMegaSizeZ();
        QuadTreeNode aNode = TestGenerator.generateQuadTree(theProvider.getMyMegaSizeX(), theProvider.getMyChunkSize(), new Vector3(centerX, centerY, centerZ), theProvider);
        return aNode;
    }

    public void recalcForPlayerPos(float x, float y, float z) {
        Coord aCenter = this.myProvider.fromWorldToMegaChunk((int)x, (int)y, (int)z);
        if (this.myOldPlayerPos.x != aCenter.x || this.myOldPlayerPos.y != aCenter.y || this.myOldPlayerPos.z != aCenter.z) {
            Iterator<String> keyIterator = this.myNodes.keySet().iterator();
            while (keyIterator.hasNext()) {
                String aKey = keyIterator.next();
                if (this.keyInBound(aCenter.x, aCenter.y, aCenter.z, aKey)) continue;
                keyIterator.remove();
            }
            int i = aCenter.x - 1;
            while (i <= aCenter.x + 1) {
                int j = aCenter.y - 1;
                while (j <= aCenter.y + 1) {
                    int k = aCenter.z - 1;
                    while (k <= aCenter.z + 1) {
                        String aKey = this.getHashFor(i, j, k);
                        if (this.myNodes.get(aKey) == null) {
                            this.myNodes.put(aKey, this.doNodeFor(i, j, k, this.myProvider));
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean keyInBound(int x, int y, int z, String key) {
        int i = x - 1;
        while (i <= x + 1) {
            int j = y - 1;
            while (j <= y + 1) {
                int k = z - 1;
                while (k <= z + 1) {
                    if (key.equals(this.getHashFor(i, j, k))) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public Collection<QuadTreeNode> getNodesToEvaluate() {
        return this.myNodes.values();
    }
}

