/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.chunks.generators;

import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.generators.ChunkWork;
import com.js.test.terra.area.chunks.generators.LightHolder;
import com.js.test.terra.area.chunks.generators.VoxelGenerator;
import com.js.test.terra.area.chunks.provider.Chunk;
import com.js.test.terra.math.Gradient;
import com.js.test.terra.math.SimplexNoise;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class WorldGenerator
implements VoxelGenerator,
Runnable {
    private BlockingQueue<ChunkWork> myChunksToDo = new LinkedBlockingQueue<ChunkWork>();
    private Random aRandom = new Random();
    private Map<String, Boolean> myHasAstroid;
    private int myAstroidSize;

    public WorldGenerator(int mySize) {
        new Thread(this).start();
        this.myAstroidSize = mySize;
        this.myHasAstroid = new HashMap<String, Boolean>();
        this.myHasAstroid.put("0|0|0", true);
    }

    @Override
    public void generate(int width, int height, int depth, int[] theData, List<LightHolder> lights) {
    }

    @Override
    public void generate(int mcx, int mcy, int mcz, int width, int height, int depth, int offsetW, int offsetH, int offsetD, Chunk theData, long theSeed) {
        if (this.isSpace(mcx, mcy, mcz)) {
            return;
        }
        int aMaxRandom = BlockLoader.getInstance().getMyAmountOfBlocksForTerrainGen();
        int[] someBlocks = new int[width * height * depth];
        Block[] blockList = BlockLoader.getInstance().getMyBlocksForTerrainGenAsArray();
        int[] debrisBlockList = new int[]{43, 3, 43};
        boolean isEmpty = true;
        boolean isSpacyRock = false;
        this.aRandom = new Random(offsetH + offsetD + offsetW);
        Random aRandomForWorld = new Random(theSeed);
        float aSeedOfsX = aRandomForWorld.nextFloat() * 5.0f;
        float aSeedOfsY = aRandomForWorld.nextFloat() * 5.0f;
        float aSeedOfsZ = aRandomForWorld.nextFloat() * 5.0f;
        int noOfIceBalls = this.aRandom.nextInt(5);
        System.out.println("wg o: " + offsetW + ", " + offsetH + ", " + offsetD + "|" + Math.abs(offsetW) + ", " + Math.abs(offsetH) + ", " + Math.abs(offsetD));
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int k = 0;
                while (k < depth) {
                    int index = i + j * width + k * height * height;
                    int realX = Math.abs(offsetW + i);
                    int realY = Math.abs(offsetH + j);
                    int realZ = Math.abs(offsetD + k);
                    index = i + j * width + k * height * height;
                    int aBlockId = someBlocks[index];
                    if (aBlockId == 0) {
                        aBlockId = 0x10000000;
                    }
                    float aNoiceVal = 0.0f;
                    double aSimplexNoise2 = 0.0;
                    float boundsVal = this.fadeFromCenter(realX, realY, realZ, this.myAstroidSize, this.myAstroidSize, this.myAstroidSize, 1.0f);
                    double boundsValMod = SimplexNoise.turbulentNoise((float)realX / 256.0f + aSeedOfsX, (float)realY / 256.0f + aSeedOfsY, (float)realZ / 256.0f + aSeedOfsZ, 4);
                    double aSimplexNoise3 = 0.0;
                    if ((boundsVal = (float)((double)boundsVal + boundsValMod * 0.2)) > 0.54f) {
                        double aSimplexNoise4;
                        double aGrandient = Gradient.gradientY01(realY, this.myAstroidSize);
                        double aSimplexNoise1 = SimplexNoise.turbulentNoise((float)realX / 256.0f + aSeedOfsX, (float)realY / 256.0f + aSeedOfsY, (float)realZ / 256.0f + aSeedOfsZ, 3);
                        double aSmoothVal = aGrandient += aSimplexNoise1 * (double)0.1f;
                        double aStrangeFormations = 0.0;
                        if (aSimplexNoise1 < 0.2) {
                            aStrangeFormations = -Math.abs(SimplexNoise.turbulentNoise((float)realX / 64.0f + 78.0f + aSeedOfsX, (float)realY / 256.0f + 78.0f + aSeedOfsY, (float)realZ / 128.0f + 78.0f + aSeedOfsZ, 4));
                        }
                        if ((aGrandient += aStrangeFormations * (double)0.1f) < 0.5) {
                            aNoiceVal = 1.0f;
                            if (aSmoothVal < 0.5) {
                                double aCaveNoise = SimplexNoise.turbulentNoise((float)realX / 256.0f + aSeedOfsX, (float)realY / 300.0f + 0.3f + aSeedOfsY, (float)realZ / 200.0f + aSeedOfsZ, 2);
                                double aCaveModNoise = SimplexNoise.turbulentNoise((float)realX / 128.0f + 0.1f + aSeedOfsX, (float)realY / 64.0f + 0.6f + aSeedOfsY, (float)realZ / 200.0f + aSeedOfsZ, 4);
                                if ((aCaveNoise += aCaveModNoise * 0.1 - 0.05) > 0.0 && aCaveNoise < 0.062) {
                                    aNoiceVal = 0.0f;
                                }
                            }
                        } else {
                            aNoiceVal = 0.0f;
                        }
                        if ((aSimplexNoise2 = SimplexNoise.turbulentNoise((float)realX / 64.0f + aSeedOfsX, (float)realY / 128.0f + aSeedOfsY, (float)realZ / 64.0f + aSeedOfsZ, 3)) > 0.6) {
                            aNoiceVal = 0.0f;
                        }
                        if (aGrandient > 0.8 && (aSimplexNoise4 = SimplexNoise.turbulentNoise((float)realX / 128.0f + aSeedOfsX, (float)realY / 128.0f + aSeedOfsY, (float)realZ / 128.0f + aSeedOfsZ, 3)) > 0.6) {
                            aNoiceVal = 1.0f;
                            isSpacyRock = true;
                        }
                    }
                    if ((double)aNoiceVal > 0.6) {
                        int aBlockIndex;
                        double aBlockNoise;
                        int aBlockToSet = 0;
                        if (isSpacyRock) {
                            aBlockNoise = SimplexNoise.turbulentNoise((float)realX / 256.0f + aSeedOfsX, (float)realY / 256.0f + aSeedOfsY, (float)realZ / 256.0f + aSeedOfsZ, 2);
                            aBlockIndex = Math.abs((int)Math.round(aBlockNoise *= 10.0)) + 1;
                            aBlockToSet = debrisBlockList[aBlockIndex % debrisBlockList.length];
                            if (aBlockToSet == 43 && (aSimplexNoise3 = SimplexNoise.turbulentNoise((float)realX / 32.0f + aSeedOfsX, (float)realY / 32.0f + aSeedOfsY, (float)realZ / 32.0f + aSeedOfsZ, 2)) > 0.6) {
                                aBlockToSet = 44;
                            }
                        } else if (aSimplexNoise2 <= 0.6 && aSimplexNoise2 >= 0.56) {
                            aBlockToSet = 12;
                        } else {
                            aBlockNoise = SimplexNoise.turbulentNoise((float)realX / 256.0f + aSeedOfsX, (float)realY / 256.0f + aSeedOfsY, (float)realZ / 256.0f + aSeedOfsZ, 2);
                            aBlockIndex = Math.abs((int)Math.round(aBlockNoise *= (double)(aMaxRandom + 1))) + 1;
                            aBlockToSet = blockList[aBlockIndex % aMaxRandom].getMyId();
                            if (aBlockToSet == 5 && (aSimplexNoise3 = SimplexNoise.turbulentNoise((float)realX / 32.0f + aSeedOfsX, (float)realY / 32.0f + aSeedOfsY, (float)realZ / 32.0f + aSeedOfsZ, 2)) > 0.6) {
                                aBlockToSet = 42;
                            }
                            if (BlockLoader.getInstance().isLightOrTransparent(aBlockToSet)) {
                                aBlockToSet += 0x10000000;
                            }
                        }
                        aBlockId = aBlockToSet;
                        isEmpty = false;
                    } else if (j != 0) {
                        if (someBlocks[index - width] == 12) {
                            if (this.aRandom.nextInt(100) > 95) {
                                aBlockId = 0x1000001F;
                                isEmpty = false;
                            }
                        } else if (someBlocks[index - width] == 6) {
                            if (this.aRandom.nextInt(100) > 95) {
                                aBlockId = 0x10000020;
                                isEmpty = false;
                            }
                        } else if (someBlocks[index - width] != 0x10000000 && someBlocks[index - width] != 268435496 && someBlocks[index - width] != 268435497 && j < height - 4 && i > 0 && i < width - 1 && k > 0 && k < depth - 1 && this.aRandom.nextInt(2000) > 1995) {
                            someBlocks[index + width] = aBlockId = 268435495;
                            someBlocks[index + width + width] = 268435496;
                            someBlocks[index + width + width + 1] = 268435497;
                            someBlocks[index + width + width - 1] = 268435497;
                            someBlocks[index + width + width + height * height] = 268435497;
                            someBlocks[index + width + width - height * height] = 268435497;
                        }
                    }
                    someBlocks[index] = aBlockId;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (!isEmpty) {
            theData.myBlocks = someBlocks;
            theData.isEmpty = false;
        }
    }

    private float fadeFromCenter(int x, int y, int z, int width, int height, int depth, float threshold) {
        int w2 = width / 2;
        int h2 = height / 2;
        int d2 = depth / 2;
        int distX = x - w2;
        int distY = y - h2;
        int distZ = z - d2;
        double tlength = Math.sqrt(distX * distX + distY * distY + distZ * distZ);
        double flength = Math.sqrt(w2 * w2 + h2 * h2 + d2 * d2);
        double normalized = tlength / flength;
        return (float)(1.0 - normalized);
    }

    @Override
    public void createGenerationJob(Chunk theChunkToDo, int mcx, int mcy, int mcz, int width, int height, int depth, int offsetW, int offsetH, int offsetD, long theSeed) {
        System.out.println("putting job on queue");
        ChunkWork aWork = new ChunkWork(theChunkToDo, mcx, mcy, mcz, width, height, depth, offsetW, offsetH, offsetD, theSeed);
        try {
            theChunkToDo.isInQueue = true;
            this.myChunksToDo.put(aWork);
        }
        catch (InterruptedException ex) {
            System.out.println("not good");
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ChunkWork aWorkToDo = this.myChunksToDo.take();
                    this.generate(aWorkToDo.mcx, aWorkToDo.mcy, aWorkToDo.mcz, aWorkToDo.width, aWorkToDo.height, aWorkToDo.depth, aWorkToDo.offsetW, aWorkToDo.offsetH, aWorkToDo.offsetD, aWorkToDo.myChunk, aWorkToDo.seed);
                    aWorkToDo.myChunk.isInitialized = true;
                    aWorkToDo.myChunk.isInQueue = false;
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isSpace(int mcx, int mcy, int mcz) {
        return this.myHasAstroid.get(String.valueOf(mcx) + "|" + mcy + "|" + mcz) == null;
    }
}

