/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.blocks;

import com.js.test.terra.area.blocks.Block;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class BlockLoader {
    private static BlockLoader myInstance;
    private List<Block> myBlockList;
    private Block[] myBlocksAsArray;
    private Block[] myBlocksForTerrainGenAsArray;
    private Block[] myLightBlocks;
    private int myAmountOfBlocks;
    private int myAmountOfBlocksForTerrainGen;
    private int myAmountOfAnimatedBlocks;
    private int[] myQuickIsLightOrTransparentList;

    private BlockLoader() {
        try {
            Properties someBlockProperties = new Properties();
            FileInputStream fis = new FileInputStream(new File("data/blocks.properties"));
            someBlockProperties.load(fis);
            fis.close();
            this.myBlockList = new ArrayList<Block>();
            boolean noMore = false;
            int count = 0;
            int countPartOfTerrainGen = 0;
            int countTransparentAndLight = 0;
            int countLight = 0;
            int countAnimatedBlocks = 0;
            while (!noMore) {
                String aPropertyValue = someBlockProperties.getProperty("block." + count);
                String aPropertyName = "block." + count;
                if (aPropertyValue != null) {
                    String canBeTunableProp;
                    String canBePoweredProp;
                    String hasStrengthProp;
                    String hasObjectTypeProp;
                    String hasMetaDataProp;
                    String isActivatableProp;
                    String isAnimatedProp;
                    boolean isTransparent = Boolean.parseBoolean(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".transparent"));
                    boolean isMultisided = Boolean.parseBoolean(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".multisided"));
                    boolean isPartOfTerrainGen = Boolean.parseBoolean(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".in_natural_terrain"));
                    boolean isLight = false;
                    boolean isAnimated = false;
                    boolean isActivatable = false;
                    boolean hasMetaData = false;
                    boolean isTunable = false;
                    String metaData = null;
                    int objectType = 0;
                    int lightStrength = 0;
                    int lightR = 0;
                    int lightG = 0;
                    int lightB = 0;
                    int blockStrength = 1;
                    boolean isManuallyActivatable = false;
                    boolean canBePowered = false;
                    String isLightProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".light");
                    if (isLightProp != null && isLightProp.length() > 0) {
                        isLight = Boolean.parseBoolean(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".light"));
                        lightStrength = Integer.parseInt(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".light_value"));
                        lightR = Integer.parseInt(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".light_r"));
                        lightG = Integer.parseInt(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".light_g"));
                        lightB = Integer.parseInt(someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".light_b"));
                    }
                    if ((isAnimatedProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".animated")) != null && isAnimatedProp.length() > 0) {
                        isAnimated = Boolean.parseBoolean(isAnimatedProp);
                        ++countAnimatedBlocks;
                    }
                    if ((isActivatableProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".activatable")) != null && isActivatableProp.length() > 0) {
                        isActivatable = Boolean.parseBoolean(isActivatableProp);
                    }
                    if (isActivatable) {
                        isManuallyActivatable = true;
                        String isManuallyActivatableProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".manually_activatable");
                        if (isManuallyActivatableProp != null && isManuallyActivatableProp.length() > 0) {
                            isManuallyActivatable = Boolean.parseBoolean(isManuallyActivatableProp);
                        }
                    }
                    if ((hasMetaDataProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".metadata")) != null && hasMetaDataProp.length() > 0) {
                        hasMetaData = true;
                        metaData = hasMetaDataProp;
                    }
                    if ((hasObjectTypeProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".objecttype")) != null && hasObjectTypeProp.length() > 0) {
                        objectType = Integer.parseInt(hasObjectTypeProp);
                    }
                    if ((hasStrengthProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".strength")) != null && hasStrengthProp.length() > 0) {
                        blockStrength = Integer.parseInt(hasStrengthProp);
                    }
                    if ((canBePoweredProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".powerable")) != null && canBePoweredProp.length() > 0) {
                        canBePowered = Boolean.parseBoolean(canBePoweredProp);
                    }
                    if ((canBeTunableProp = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".tunable")) != null && canBeTunableProp.length() > 0) {
                        isTunable = Boolean.parseBoolean(canBeTunableProp);
                    }
                    String asset = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".asset");
                    Block aNewBlock = new Block(aPropertyValue, count, isMultisided, asset, isTransparent, isPartOfTerrainGen, isLight, lightStrength, lightR, lightG, lightB, isAnimated, isActivatable, hasMetaData, metaData, objectType, blockStrength, isManuallyActivatable, canBePowered, isTunable);
                    if (isPartOfTerrainGen) {
                        ++countPartOfTerrainGen;
                    }
                    if (isLight || isTransparent) {
                        ++countTransparentAndLight;
                    }
                    if (isLight) {
                        ++countLight;
                    }
                    this.myBlockList.add(aNewBlock);
                    ++count;
                    continue;
                }
                noMore = true;
            }
            this.myAmountOfBlocks = this.myBlockList.size();
            this.myAmountOfBlocksForTerrainGen = countPartOfTerrainGen;
            this.myBlocksAsArray = new Block[this.myAmountOfBlocks];
            int i = 0;
            while (i < this.myAmountOfBlocks) {
                this.myBlocksAsArray[i] = this.myBlockList.get(i);
                ++i;
            }
            this.myQuickIsLightOrTransparentList = new int[countTransparentAndLight];
            int index = 0;
            for (Block aBlock : this.myBlockList) {
                if (!aBlock.isTransparent() && !aBlock.isLight()) continue;
                this.myQuickIsLightOrTransparentList[index] = aBlock.getMyId();
                ++index;
            }
            this.myBlocksForTerrainGenAsArray = new Block[this.myAmountOfBlocksForTerrainGen];
            index = 0;
            for (Block aBlock : this.myBlockList) {
                if (!aBlock.isPartOfTerrainGen()) continue;
                this.myBlocksForTerrainGenAsArray[index] = aBlock;
                ++index;
            }
            this.myLightBlocks = new Block[countLight];
            index = 0;
            for (Block aBlock : this.myBlockList) {
                if (!aBlock.isLight()) continue;
                this.myLightBlocks[index] = aBlock;
                ++index;
            }
            this.myAmountOfAnimatedBlocks = countAnimatedBlocks;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BlockLoader getInstance() {
        if (myInstance == null) {
            myInstance = new BlockLoader();
            return myInstance;
        }
        return myInstance;
    }

    public List<Block> getMyBlockList() {
        return this.myBlockList;
    }

    public void setMyBlockList(List<Block> myBlockList) {
        this.myBlockList = myBlockList;
    }

    public Block[] getMyBlocksAsArray() {
        return this.myBlocksAsArray;
    }

    public void setMyBlocksAsArray(Block[] myBlocksAsArray) {
        this.myBlocksAsArray = myBlocksAsArray;
    }

    public int getMyAmountOfBlocks() {
        return this.myAmountOfBlocks;
    }

    public void setMyAmountOfBlocks(int myAmountOfBlocks) {
        this.myAmountOfBlocks = myAmountOfBlocks;
    }

    public Block[] getMyBlocksForTerrainGenAsArray() {
        return this.myBlocksForTerrainGenAsArray;
    }

    public void setMyBlocksForTerrainGenAsArray(Block[] myBlocksForTerrainGenAsArray) {
        this.myBlocksForTerrainGenAsArray = myBlocksForTerrainGenAsArray;
    }

    public int getMyAmountOfBlocksForTerrainGen() {
        return this.myAmountOfBlocksForTerrainGen;
    }

    public void setMyAmountOfBlocksForTerrainGen(int myAmountOfBlocksForTerrainGen) {
        this.myAmountOfBlocksForTerrainGen = myAmountOfBlocksForTerrainGen;
    }

    public int[] getMyQuickIsLightOrTransparentList() {
        return this.myQuickIsLightOrTransparentList;
    }

    public void setMyQuickIsLightOrTransparentList(int[] myQuickIsLightOrTransparentList) {
        this.myQuickIsLightOrTransparentList = myQuickIsLightOrTransparentList;
    }

    public int getMyAmountOfAnimatedBlocks() {
        return this.myAmountOfAnimatedBlocks;
    }

    public void setMyAmountOfAnimatedBlocks(int myAmountOfAnimatedBlocks) {
        this.myAmountOfAnimatedBlocks = myAmountOfAnimatedBlocks;
    }

    public Block[] getMyLightBlocks() {
        return this.myLightBlocks;
    }

    public void setMyLightBlocks(Block[] myLightBlocks) {
        this.myLightBlocks = myLightBlocks;
    }

    public boolean isLightOrTransparent(int theBlockId) {
        if (theBlockId == 0) {
            return true;
        }
        int i = 0;
        while (i < this.myQuickIsLightOrTransparentList.length) {
            if (this.myQuickIsLightOrTransparentList[i] == theBlockId) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

