/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.animatedgenerator;

import com.js.test.terra.area.animatedgenerator.AnimatedGenerator;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class ElevatorGenerator
extends AnimatedGenerator {
    private BigChunkDataGrid myGrid;

    public ElevatorGenerator(int w, int h, int d, int x, int y, int z, int blockId, BigChunkDataGrid theGrid, GL2 theGl) {
        super(w, h, d);
        this.myBlockId = blockId;
        this.myGrid = theGrid;
        this.myCenter = new Vector3(0.0, 0.0, 0.0);
        this.myCenter.x = x;
        this.myCenter.y = (float)y - (float)h / 2.0f + 0.5f;
        this.myCenter.z = z;
        this.myRenderCenter = new Vector3(0.0, 0.0, 0.0);
        this.myX = x;
        this.myY = y;
        this.myZ = z;
        this.fillCube(theGrid);
        this.generateVBOForMyBlock(theGl);
    }

    private void fillCube(BigChunkDataGrid theGrid) {
        int blockCount = 0;
        boolean keepDoingIt = true;
        int k = 0;
        while (k < this.myDepth) {
            int j = this.myHeight - 1;
            while (j >= 0) {
                int i = 0;
                while (i < this.myWidth) {
                    if (theGrid.getBlockAt(this.myX + i, this.myY + this.myHeight - j, this.myZ + k) == 0 && keepDoingIt) {
                        this.myBlocks[i + j * this.myWidth + k * this.myWidth * this.myHeight] = this.myBlockId;
                        ++blockCount;
                    } else {
                        keepDoingIt = false;
                    }
                    ++i;
                }
                --j;
            }
            ++k;
        }
        this.myAmountOfBlocks = blockCount;
    }

    @Override
    public boolean doTick(GL2 theGl, GLU theGlu, float amount, BigChunkDataGrid theGrid) {
        if (this.isInvalid) {
            return true;
        }
        this.myAmountOfCurrentlyVisibleBlocks += (float)this.myAmountOfBlocks;
        if ((int)this.myAmountOfCurrentlyVisibleBlocks >= this.myAmountOfBlocks) {
            this.myGrid.insertGeometrySkipAir(this.myBlocks, this.myWidth, this.myHeight, this.myDepth, (int)((double)this.myX - Math.floor(this.myWidth / 2)), (int)((double)this.myY + Math.floor(this.myHeight)), (int)((double)this.myZ - Math.floor(this.myDepth / 2)), theGl, theGlu, true);
            return true;
        }
        return false;
    }
}

