/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.animatedgenerator;

import com.jogamp.opengl.util.GLBuffers;
import com.js.test.terra.area.animatedgenerator.AnimatedGenerator;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.util.ObjectData;
import com.js.test.terra.math.Vector3;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class CoralAnimatedGenerator
extends AnimatedGenerator {
    private BigChunkDataGrid myGrid;
    private List<Vector3> myBlockOrderList;

    public CoralAnimatedGenerator(int w, int h, int d, int x, int y, int z, int blockId, BigChunkDataGrid theGrid, GL2 theGl) {
        super(w, h, d);
        this.myBlockId = 15;
        this.myGrid = theGrid;
        if (theGrid.getBlockAt(x, y + 1, z) == 0) {
            this.myCenter = new Vector3(0.0, 0.0, 0.0);
            this.myCenter.x = x;
            this.myCenter.y = (float)y + (float)h / 2.0f + 0.5f;
            this.myCenter.z = z;
            this.myRenderCenter = new Vector3(0.0, 0.0, 0.0);
            this.myX = x;
            this.myY = y;
            this.myZ = z;
            this.generateCoral();
            this.generateVBOForMyBlock(theGl);
        } else {
            this.isInvalid = true;
        }
    }

    private void generateCoral() {
        this.myBlockOrderList = new ArrayList<Vector3>();
        int startGenAtX = Math.round(this.myWidth / 2);
        int startGenAtZ = Math.round(this.myDepth / 2);
        int startGenAtY = this.myHeight - 1;
        Random aRandom = new Random();
        this.setCoralBlock(startGenAtX, startGenAtY, startGenAtZ);
        int j = this.myHeight - 1;
        while (j >= 0) {
            boolean noHit = true;
            int i = 0;
            while (i < this.myWidth) {
                int k = 0;
                while (k < this.myDepth) {
                    int randomVal;
                    int blockBelow = this.getBlockAt(i, j + 1, k);
                    if (blockBelow > 0 && (randomVal = aRandom.nextInt(100)) > 40) {
                        this.setCoralBlock(i, j, k);
                        noHit = false;
                    } else {
                        int randomVal2;
                        boolean hasCoralClose = this.hasCoralAroundDown(i, j, k);
                        if (hasCoralClose && (randomVal2 = aRandom.nextInt(100)) > 85) {
                            this.setCoralBlock(i, j, k);
                            noHit = false;
                        }
                    }
                    ++k;
                }
                ++i;
            }
            if (noHit) {
                this.setCoralBlock(startGenAtX, j, startGenAtZ);
            }
            --j;
        }
        this.myAmountOfBlocks = this.myBlockOrderList.size();
    }

    private boolean hasCoralAroundDown(int x, int y, int z) {
        int i;
        int h;
        int g;
        int f;
        int e;
        int d;
        int c;
        int b = this.getBlockAt(x - 1, y + 1, z - 1);
        return b + (c = this.getBlockAt(x - 1, y + 1, z)) + (d = this.getBlockAt(x - 1, y + 1, z + 1)) + (e = this.getBlockAt(x, y + 1, z - 1)) + (f = this.getBlockAt(x, y + 1, z + 1)) + (g = this.getBlockAt(x + 1, y + 1, z - 1)) + (h = this.getBlockAt(x + 1, y + 1, z)) + (i = this.getBlockAt(x + 1, y + 1, z + 1)) > 0;
    }

    private int getBlockAt(int x, int y, int z) {
        if (x >= 0 && x < this.myWidth && y >= 0 && y < this.myHeight && z >= 0 && z < this.myDepth) {
            return this.myBlocks[x + y * this.myWidth + z * (this.myWidth * this.myHeight)];
        }
        return 0;
    }

    private void setCoralBlock(int x, int y, int z) {
        this.myBlocks[x + y * this.myWidth + z * (this.myHeight * this.myWidth)] = 15;
        this.myBlockOrderList.add(new Vector3(x, y, z));
    }

    @Override
    public boolean doTick(GL2 theGl, GLU theGlu, float amount, BigChunkDataGrid theGrid) {
        if (this.isInvalid) {
            return true;
        }
        this.myAmountOfCurrentlyVisibleBlocks += amount * 50.0f;
        if ((int)this.myAmountOfCurrentlyVisibleBlocks >= this.myAmountOfBlocks) {
            this.myGrid.insertGeometrySkipAir(this.myBlocks, this.myWidth, this.myHeight, this.myDepth, (int)((double)this.myX - Math.floor(this.myWidth / 2)), (int)((double)this.myY + Math.floor(this.myHeight)), (int)((double)this.myZ - Math.floor(this.myDepth / 2)), theGl, theGlu, false);
            return true;
        }
        return false;
    }

    @Override
    protected void generateVBOForMyBlock(GL2 theGl) {
        float[] myVerticesToAdd = new float[this.myAmountOfBlocks * 24 * 3];
        float[] myColorsToAdd = new float[this.myAmountOfBlocks * 24 * 3];
        float[] myCoordToAdd = new float[this.myAmountOfBlocks * 24 * 2];
        int[] myIndexesToAdd = new int[this.myAmountOfBlocks * 36];
        int dataIndex = 0;
        Block aBlockInfo = BlockLoader.getInstance().getMyBlocksAsArray()[this.myBlockId];
        float[] textureCoordListToUse = ObjectData.myObjectTexCoordData[0];
        if (aBlockInfo.isMultisided()) {
            textureCoordListToUse = ObjectData.myObjectTexCoordMultisidedData[0];
        }
        int i = 0;
        while (i < myColorsToAdd.length) {
            myColorsToAdd[i] = 1.0f;
            ++i;
        }
        for (Vector3 aBlockPos : this.myBlockOrderList) {
            int x = (int)aBlockPos.x;
            int y = this.myHeight - (int)aBlockPos.y;
            int z = (int)aBlockPos.z;
            float[] blockVertices = ObjectData.getVertexesWithOffset((float)x - (float)Math.floor(this.myWidth / 2), (float)y - (float)Math.floor(this.myHeight / 2) - 0.5f, (float)z - (float)Math.floor(this.myWidth / 2));
            int[] blockIndexes = ObjectData.getIndexesWithOffset(dataIndex * 24);
            int c = dataIndex * 24 * 3;
            int lI = 0;
            while (c < (dataIndex + 1) * 24 * 3) {
                myVerticesToAdd[c] = blockVertices[lI];
                ++c;
                ++lI;
            }
            c = dataIndex * 36;
            lI = 0;
            while (c < (dataIndex + 1) * 36) {
                myIndexesToAdd[c] = blockIndexes[lI];
                ++c;
                ++lI;
            }
            c = dataIndex * 24 * 2;
            lI = 0;
            while (c < (dataIndex + 1) * 24 * 2) {
                myCoordToAdd[c] = textureCoordListToUse[lI];
                ++c;
                ++lI;
            }
            ++dataIndex;
        }
        this.myVertexVboList = new int[1];
        this.myIndexVboList = new int[1];
        this.myTextureCoordVboList = new int[1];
        this.myColorVboList = new int[1];
        theGl.glGenBuffers(1, this.myVertexVboList, 0);
        theGl.glGenBuffers(1, this.myIndexVboList, 0);
        theGl.glGenBuffers(1, this.myTextureCoordVboList, 0);
        theGl.glGenBuffers(1, this.myColorVboList, 0);
        theGl.glBindBuffer(34962, this.myVertexVboList[0]);
        FloatBuffer fb = GLBuffers.newDirectFloatBuffer((float[])myVerticesToAdd);
        theGl.glBufferData(34962, (long)(myVerticesToAdd.length * 4), (Buffer)fb, 35044);
        theGl.glBindBuffer(34962, this.myColorVboList[0]);
        FloatBuffer fbc = GLBuffers.newDirectFloatBuffer((float[])myColorsToAdd);
        theGl.glBufferData(34962, (long)(myColorsToAdd.length * 4), (Buffer)fbc, 35044);
        theGl.glBindBuffer(34963, this.myIndexVboList[0]);
        IntBuffer ib = GLBuffers.newDirectIntBuffer((int[])myIndexesToAdd);
        theGl.glBufferData(34963, (long)(myIndexesToAdd.length * 4), (Buffer)ib, 35044);
        theGl.glBindBuffer(34962, this.myTextureCoordVboList[0]);
        FloatBuffer ftb = GLBuffers.newDirectFloatBuffer((float[])myCoordToAdd);
        theGl.glBufferData(34962, (long)(myCoordToAdd.length * 4), (Buffer)ftb, 35044);
    }
}

