/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.terra.area.animatedgenerator;

import com.js.test.terra.area.animatedgenerator.AnimatedGenerator;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.math.Vector3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class BlobbAnimatedGenerator
extends AnimatedGenerator {
    private BigChunkDataGrid myGrid;
    private List<Vector3> centers;
    private long lastBlobTick;
    private int count;

    public BlobbAnimatedGenerator(int w, int h, int d, int x, int y, int z, int blockId, BigChunkDataGrid theGrid, GL2 theGl) {
        super(w, h, d);
        this.myBlockId = blockId;
        this.myGrid = theGrid;
        this.centers = new ArrayList<Vector3>();
        this.centers.add(new Vector3(x, y, z));
        this.centers.add(new Vector3(x + 1, y, z));
        this.centers.add(new Vector3(x - 1, y, z));
        this.centers.add(new Vector3(x, y + 1, z));
        this.centers.add(new Vector3(x, y - 1, z));
        this.centers.add(new Vector3(x, y, z + 1));
        this.centers.add(new Vector3(x, y, z - 1));
        this.myCenter = new Vector3(0.0, 0.0, 0.0);
        this.myCenter.x = x;
        this.myCenter.y = y;
        this.myCenter.z = z;
        this.myRenderCenter = new Vector3(0.0, 0.0, 0.0);
        this.count = 0;
    }

    private void fillCube(BigChunkDataGrid theGrid) {
        this.myAmountOfBlocks = 100;
    }

    @Override
    public boolean doTick(GL2 theGl, GLU theGlu, float time, BigChunkDataGrid theGrid) {
        long now = System.currentTimeMillis();
        if (now > this.lastBlobTick + 1000L) {
            this.lastBlobTick = now;
            ++this.count;
            Random aRandom = new Random();
            ArrayList<Vector3> newList = new ArrayList<Vector3>();
            Iterator<Vector3> anIterator = this.centers.iterator();
            int bC = 0;
            while (bC < 10 && anIterator.hasNext()) {
                double rand;
                double distUp;
                Vector3 aGrower = anIterator.next();
                ++bC;
                anIterator.remove();
                Block aBlock = BlockLoader.getInstance().getMyBlocksAsArray()[6];
                theGrid.addBlockWithUpdates((int)aGrower.x, (int)aGrower.y, (int)aGrower.z, aBlock, theGl, theGlu, 0);
                double dist = this.myCenter.distanceTo(0.0, 0.0, 0.0);
                Vector3 up = new Vector3(aGrower.x, aGrower.y + 1.0, aGrower.z);
                Vector3 down = new Vector3(aGrower.x, aGrower.y - 1.0, aGrower.z);
                Vector3 left = new Vector3(aGrower.x - 1.0, aGrower.y, aGrower.z);
                Vector3 right = new Vector3(aGrower.x + 1.0, aGrower.y, aGrower.z);
                Vector3 back = new Vector3(aGrower.x, aGrower.y, aGrower.z - 1.0);
                Vector3 front = new Vector3(aGrower.x, aGrower.y, aGrower.z + 1.0);
                if (theGrid.getBlockAt((int)up.x, (int)up.y, (int)up.z) == 0) {
                    distUp = up.distanceTo(0.0, 0.0, 0.0);
                    rand = aRandom.nextDouble();
                    if (distUp > dist) {
                        if (rand < 0.1) {
                            newList.add(up);
                        }
                    } else if (dist - distUp < 0.8) {
                        if (rand < 0.3) {
                            newList.add(up);
                        }
                    } else if (rand < 0.7) {
                        newList.add(up);
                    }
                }
                if (theGrid.getBlockAt((int)down.x, (int)down.y, (int)down.z) == 0) {
                    distUp = down.distanceTo(0.0, 0.0, 0.0);
                    rand = aRandom.nextDouble();
                    if (distUp > dist) {
                        if (rand < 0.1) {
                            newList.add(down);
                        }
                    } else if (dist - distUp < 0.8) {
                        if (rand < 0.3) {
                            newList.add(down);
                        }
                    } else if (rand < 0.7) {
                        newList.add(down);
                    }
                }
                if (theGrid.getBlockAt((int)left.x, (int)left.y, (int)left.z) == 0) {
                    distUp = left.distanceTo(0.0, 0.0, 0.0);
                    rand = aRandom.nextDouble();
                    if (distUp > dist) {
                        if (rand < 0.1) {
                            newList.add(left);
                        }
                    } else if (dist - distUp < 0.8) {
                        if (rand < 0.3) {
                            newList.add(left);
                        }
                    } else if (rand < 0.7) {
                        newList.add(left);
                    }
                }
                if (theGrid.getBlockAt((int)right.x, (int)right.y, (int)right.z) == 0) {
                    distUp = right.distanceTo(0.0, 0.0, 0.0);
                    rand = aRandom.nextDouble();
                    if (distUp > dist) {
                        if (rand < 0.2) {
                            newList.add(right);
                        }
                    } else if (dist - distUp < 0.8) {
                        if (rand < 0.4) {
                            newList.add(right);
                        }
                    } else if (rand < 0.5) {
                        newList.add(right);
                    }
                }
                if (theGrid.getBlockAt((int)back.x, (int)back.y, (int)back.z) == 0) {
                    distUp = back.distanceTo(0.0, 0.0, 0.0);
                    rand = aRandom.nextDouble();
                    if (distUp > dist) {
                        if (rand < 0.1) {
                            newList.add(back);
                        }
                    } else if (dist - distUp < 0.8) {
                        if (rand < 0.3) {
                            newList.add(back);
                        }
                    } else if (rand < 0.5) {
                        newList.add(back);
                    }
                }
                if (theGrid.getBlockAt((int)front.x, (int)front.y, (int)front.z) != 0) continue;
                distUp = front.distanceTo(0.0, 0.0, 0.0);
                rand = aRandom.nextDouble();
                if (distUp > dist) {
                    if (!(rand < 0.1)) continue;
                    newList.add(front);
                    continue;
                }
                if (dist - distUp < 0.8) {
                    if (!(rand < 0.3)) continue;
                    newList.add(front);
                    continue;
                }
                if (!(rand < 0.5)) continue;
                newList.add(front);
            }
            this.centers.addAll(newList);
            if (this.centers.size() == 0) {
                return true;
            }
        }
        return this.count > 30;
    }
}

