/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.machines;

import com.js.test.engine.machines.BlockMakerConvertion;
import com.js.test.engine.machines.BlockMakerEntity;
import com.js.test.engine.machines.GrindConvertionEntity;
import com.js.test.engine.machines.GrinderConvertion;
import com.js.test.engine.machines.ItemMakerConvertion;
import com.js.test.engine.machines.ItemMakerEntity;
import com.js.test.engine.player.BlockMaker;
import com.js.test.engine.player.Driller;
import com.js.test.engine.player.Grinder;
import com.js.test.engine.player.Inventory;
import com.js.test.engine.player.ItemMaker;
import com.js.test.engine.player.Player;
import com.js.test.engine.player.Timer;
import com.js.test.terra.area.blocks.Block;
import com.js.test.terra.area.blocks.BlockLoader;
import com.js.test.terra.area.chunks.BigChunkDataGrid;
import com.js.test.terra.area.chunks.ChunkDataWrapper;
import com.js.test.terra.area.chunks.provider.BlockMetaData;
import com.js.test.terra.area.chunks.provider.ChunkProvider;
import com.js.test.terra.area.item.BaseItem;
import com.js.test.terra.area.item.BaseItemLoader;
import com.js.test.terra.area.item.ItemStack;
import com.js.test.terra.area.item.ItemWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class MachineHandler {
    private static MachineHandler myInstance;
    private Random myRandom = new Random();
    private long myLastCheck = 0L;

    private MachineHandler() {
    }

    public static MachineHandler getInstance() {
        if (myInstance == null) {
            myInstance = new MachineHandler();
            return myInstance;
        }
        return myInstance;
    }

    public void handleMachineTick(ChunkProvider theProvider, BigChunkDataGrid theGrid, Player thePlayer, GL2 theGl, GLU theGlu) {
        long now = System.currentTimeMillis();
        if (now - this.myLastCheck > 3000L) {
            this.myLastCheck = now;
            Collection<Grinder> someGrinders = theProvider.getGrindersMap().values();
            block8: for (Grinder aGrinder : someGrinders) {
                BlockMetaData aMetaDataBlock = theProvider.getMetaDataMap().get(String.valueOf(aGrinder.getX()) + "|" + aGrinder.getY() + "|" + aGrinder.getZ());
                int totalPowerLevel = 0;
                for (String aString : aMetaDataBlock.extraData.values()) {
                    try {
                        int aPowerLevel = Integer.parseInt(aString);
                        if (aPowerLevel <= totalPowerLevel) continue;
                        totalPowerLevel = aPowerLevel;
                    }
                    catch (Exception aPowerLevel) {
                        // empty catch block
                    }
                }
                aGrinder.setPowered(false);
                aGrinder.setMyPowerLevel(totalPowerLevel);
                if (totalPowerLevel <= 0) continue;
                aGrinder.setPowered(true);
                int i = 0;
                while (i < aGrinder.getMyInventory().getMyItems().length) {
                    ItemStack aStack = aGrinder.getMyInventory().getMyItems()[i];
                    if (aStack != null && aStack.getMyItem().isBlock) {
                        int itemToAdd;
                        GrindConvertionEntity anEntity = GrinderConvertion.getInstance().getEntityForBlock(aStack.getMyItem().blockId);
                        if (anEntity != null) {
                            itemToAdd = anEntity.getRandomizedItem(this.myRandom);
                            aStack.setMyAmount(aStack.getMyAmount() - 1);
                            if (aStack.getMyAmount() == 0) {
                                aGrinder.getMyInventory().getMyItems()[i] = null;
                            }
                            aGrinder.getMyProducedItems().addItemStackable(itemToAdd, anEntity.amount);
                            continue block8;
                        }
                        itemToAdd = 3;
                        aStack.setMyAmount(aStack.getMyAmount() - 1);
                        if (aStack.getMyAmount() == 0) {
                            aGrinder.getMyInventory().getMyItems()[i] = null;
                        }
                        aGrinder.getMyProducedItems().addItemStackable(itemToAdd, 1);
                        continue block8;
                    }
                    ++i;
                }
            }
            Collection<BlockMaker> someMakers = theProvider.getBlockMakersMap().values();
            for (BlockMaker aMaker : someMakers) {
                BlockMakerEntity anEntity;
                BlockMetaData aMetaDataBlock = theProvider.getMetaDataMap().get(String.valueOf(aMaker.getX()) + "|" + aMaker.getY() + "|" + aMaker.getZ());
                int totalPowerLevel = 0;
                for (String aString : aMetaDataBlock.extraData.values()) {
                    try {
                        int aPowerLevel = Integer.parseInt(aString);
                        if (aPowerLevel <= totalPowerLevel) continue;
                        totalPowerLevel = aPowerLevel;
                    }
                    catch (Exception aPowerLevel) {
                        // empty catch block
                    }
                }
                aMaker.setPowered(false);
                aMaker.setMyPowerLevel(totalPowerLevel);
                if (totalPowerLevel <= 0) continue;
                aMaker.setPowered(true);
                if (!aMaker.isActivated() || aMaker.getMyBlockToMake() == 0 || (anEntity = BlockMakerConvertion.getInstance().getEntityForBlock(aMaker.getMyBlockToMake())) == null || !this.hasCompontents(anEntity, aMaker.getMyInventory()) || !aMaker.isMyMakeInfinite() && aMaker.getMyMakeAmount() <= 0) continue;
                if (!aMaker.isMyMakeInfinite()) {
                    aMaker.setMyMakeAmount(aMaker.getMyMakeAmount() - 1);
                }
                this.removeComponents(anEntity, aMaker.getMyInventory());
                aMaker.getMyProducedItems().addBlock(anEntity.blockId, 1);
            }
            Collection<ItemMaker> someItemMaker = theProvider.getItemMakersMap().values();
            for (ItemMaker aMaker : someItemMaker) {
                ItemMakerEntity anEntity;
                BlockMetaData aMetaDataBlock = theProvider.getMetaDataMap().get(String.valueOf(aMaker.getX()) + "|" + aMaker.getY() + "|" + aMaker.getZ());
                int totalPowerLevel = 0;
                for (String aString : aMetaDataBlock.extraData.values()) {
                    try {
                        int aPowerLevel = Integer.parseInt(aString);
                        if (aPowerLevel <= totalPowerLevel) continue;
                        totalPowerLevel = aPowerLevel;
                    }
                    catch (Exception aPowerLevel) {
                        // empty catch block
                    }
                }
                aMaker.setPowered(false);
                aMaker.setMyPowerLevel(totalPowerLevel);
                if (totalPowerLevel <= 0) continue;
                aMaker.setPowered(true);
                if (!aMaker.isActivated() || aMaker.getMyItemToMake() == 0 || (anEntity = ItemMakerConvertion.getInstance().getEntityForItem(aMaker.getMyItemToMake())) == null || !this.hasCompontents(anEntity, aMaker.getMyInventory()) || !aMaker.isMyMakeInfinite() && aMaker.getMyMakeAmount() <= 0) continue;
                if (!aMaker.isMyMakeInfinite()) {
                    aMaker.setMyMakeAmount(aMaker.getMyMakeAmount() - 1);
                }
                this.removeComponents(anEntity, aMaker.getMyInventory());
                BaseItem anItemToMake = BaseItemLoader.getInstance().getMyItems().get(aMaker.getMyItemToMake());
                if (anItemToMake.isStackable()) {
                    aMaker.getMyProducedItems().addItemStackable(anEntity.itemId, 1);
                    continue;
                }
                ItemWrapper aWrapper = new ItemWrapper(true, false, anEntity.itemId, 0, false);
                ItemStack aStackToAdd = new ItemStack(aWrapper, 0, false);
                aMaker.getMyProducedItems().addStack(aStackToAdd);
            }
            Collection<Driller> someDrillers = theProvider.getDrillersMap().values();
            HashSet<ChunkDataWrapper> aSetToUpdate = new HashSet<ChunkDataWrapper>();
            Block aPipeBlock = BlockLoader.getInstance().getMyBlocksAsArray()[55];
            for (Driller aDriller : someDrillers) {
                BlockMetaData aMetaDataBlock = theProvider.getMetaDataMap().get(String.valueOf(aDriller.getX()) + "|" + aDriller.getY() + "|" + aDriller.getZ());
                int totalPowerLevel = 0;
                for (String aString : aMetaDataBlock.extraData.values()) {
                    try {
                        int aPowerLevel = Integer.parseInt(aString);
                        if (aPowerLevel <= totalPowerLevel) continue;
                        totalPowerLevel = aPowerLevel;
                    }
                    catch (Exception aPowerLevel) {
                        // empty catch block
                    }
                }
                aDriller.setPowered(false);
                aDriller.setMyPowerLevel(totalPowerLevel);
                if (totalPowerLevel <= 0) continue;
                aDriller.setPowered(true);
                if (!aDriller.isActive() || aDriller.getLength() >= 40) continue;
                int aNewY = aDriller.getY() - aDriller.getLength() - 1;
                int aBlock = theProvider.getBlockAt(aDriller.getX(), aNewY, aDriller.getZ());
                if (aBlock > 2) {
                    Inventory addToThis = theProvider.getInventoryFor(aDriller.getX(), aDriller.getY(), aDriller.getZ());
                    addToThis.addBlock(aBlock, 1);
                }
                aSetToUpdate.addAll(theGrid.removeBlockWithoutVBOUpdates(aDriller.getX(), aNewY, aDriller.getZ(), theGl, theGlu, false, false));
                aSetToUpdate.addAll(theGrid.addBlockWithoutVBOUpdates(aDriller.getX(), aNewY, aDriller.getZ(), aPipeBlock, theGl, theGlu, 0));
                aDriller.setLength(aDriller.getLength() + 1);
            }
            theGrid.rebuildWrapperList(aSetToUpdate);
            Collection<Timer> someTimers = theProvider.getTimersMap().values();
            long timeNow = System.currentTimeMillis();
            for (Timer aTimer : someTimers) {
                if (!aTimer.isActive()) continue;
                BlockMetaData aMetaDataBlock = theProvider.getMetaDataMap().get(String.valueOf(aTimer.getX()) + "|" + aTimer.getY() + "|" + aTimer.getZ());
                long lastUpdate = 0L;
                int interval = 2;
                String aVal = aMetaDataBlock.extraData.get("lastupdate");
                String aIntervalS = aMetaDataBlock.extraData.get("interval");
                if (aVal != null && aVal.length() > 0) {
                    lastUpdate = Long.parseLong(aVal);
                }
                if (aIntervalS != null && aIntervalS.length() > 0) {
                    interval = Integer.parseInt(aIntervalS);
                }
                if (timeNow <= lastUpdate + (long)(interval * 1000)) continue;
                aMetaDataBlock.extraData.put("lastupdate", Long.toString(lastUpdate + (long)(interval * 1000)));
                theGrid.toggleActiveWithUpdates(aTimer.getX() - 1, aTimer.getY(), aTimer.getZ(), theGl, theGlu, true, thePlayer, true);
                theGrid.toggleActiveWithUpdates(aTimer.getX() + 1, aTimer.getY(), aTimer.getZ(), theGl, theGlu, true, thePlayer, true);
                theGrid.toggleActiveWithUpdates(aTimer.getX(), aTimer.getY() - 1, aTimer.getZ(), theGl, theGlu, true, thePlayer, true);
                theGrid.toggleActiveWithUpdates(aTimer.getX(), aTimer.getY() + 1, aTimer.getZ(), theGl, theGlu, true, thePlayer, true);
                theGrid.toggleActiveWithUpdates(aTimer.getX(), aTimer.getY(), aTimer.getZ() - 1, theGl, theGlu, true, thePlayer, true);
                theGrid.toggleActiveWithUpdates(aTimer.getX(), aTimer.getY(), aTimer.getZ() + 1, theGl, theGlu, true, thePlayer, true);
            }
        }
    }

    private boolean hasCompontents(BlockMakerEntity anEntity, Inventory anInventory) {
        int i = 0;
        while (i < anEntity.myConvertions.length) {
            int anItemIdToFind = anEntity.myConvertions[i][0];
            int anMinimumAmount = anEntity.myConvertions[i][1];
            boolean found = false;
            ItemStack[] itemStackArray = anInventory.getMyItems();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack aStack = itemStackArray[n2];
                if (aStack != null && aStack.getMyItem().isItem && aStack.getMyItem().itemId == anItemIdToFind && aStack.getMyAmount() >= anMinimumAmount) {
                    found = true;
                }
                ++n2;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasCompontents(ItemMakerEntity anEntity, Inventory anInventory) {
        int i = 0;
        while (i < anEntity.myConvertions.length) {
            int anItemIdToFind = anEntity.myConvertions[i][0];
            int anMinimumAmount = anEntity.myConvertions[i][1];
            boolean found = false;
            ItemStack[] itemStackArray = anInventory.getMyItems();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack aStack = itemStackArray[n2];
                if (aStack != null && aStack.getMyItem().isItem && aStack.getMyItem().itemId == anItemIdToFind && aStack.getMyAmount() >= anMinimumAmount) {
                    found = true;
                }
                ++n2;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void removeComponents(BlockMakerEntity anEntity, Inventory anInventory) {
        int i = 0;
        while (i < anEntity.myConvertions.length) {
            int anItemIdToFind = anEntity.myConvertions[i][0];
            int anMinimumAmount = anEntity.myConvertions[i][1];
            boolean found = false;
            int anIndex = 0;
            ItemStack[] itemStackArray = anInventory.getMyItems();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack aStack = itemStackArray[n2];
                if (aStack != null) {
                    if (aStack.getMyItem().isItem && aStack.getMyItem().itemId == anItemIdToFind && aStack.getMyAmount() >= anMinimumAmount) {
                        aStack.setMyAmount(aStack.getMyAmount() - anMinimumAmount);
                        if (aStack.getMyAmount() != 0) break;
                        anInventory.getMyItems()[anIndex] = null;
                        break;
                    }
                    ++anIndex;
                }
                ++n2;
            }
            ++i;
        }
    }

    private void removeComponents(ItemMakerEntity anEntity, Inventory anInventory) {
        int i = 0;
        while (i < anEntity.myConvertions.length) {
            int anItemIdToFind = anEntity.myConvertions[i][0];
            int anMinimumAmount = anEntity.myConvertions[i][1];
            boolean found = false;
            int anIndex = 0;
            ItemStack[] itemStackArray = anInventory.getMyItems();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack aStack = itemStackArray[n2];
                if (aStack != null) {
                    if (aStack.getMyItem().isItem && aStack.getMyItem().itemId == anItemIdToFind && aStack.getMyAmount() >= anMinimumAmount) {
                        aStack.setMyAmount(aStack.getMyAmount() - anMinimumAmount);
                        if (aStack.getMyAmount() != 0) break;
                        anInventory.getMyItems()[anIndex] = null;
                        break;
                    }
                    ++anIndex;
                }
                ++n2;
            }
            ++i;
        }
    }
}

