/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.machines;

import com.js.test.engine.machines.BlockMakerEntity;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BlockMakerConvertion {
    private static BlockMakerConvertion myInstance;
    private Map<Integer, BlockMakerEntity> myConvertions;
    private Map<String, List<Integer>> myGroupConvertions;
    private int[] makableBlockList;

    private BlockMakerConvertion() {
        try {
            Properties someBlockProperties = new Properties();
            FileInputStream fis = new FileInputStream(new File("data/block_maker.properties"));
            someBlockProperties.load(fis);
            fis.close();
            this.myConvertions = new HashMap<Integer, BlockMakerEntity>();
            this.myGroupConvertions = new HashMap<String, List<Integer>>();
            boolean noMore = false;
            int count = 0;
            while (!noMore) {
                String aPropertyValue = someBlockProperties.getProperty("convert." + count + ".block");
                String aPropertyName = "convert." + count;
                if (aPropertyValue != null) {
                    String anToProp = String.valueOf(aPropertyName) + ".from";
                    String aGroup = someBlockProperties.getProperty(String.valueOf(aPropertyName) + ".group");
                    if (aGroup == null || aGroup.length() == 0) {
                        ++count;
                        continue;
                    }
                    int aBlockId = Integer.parseInt(aPropertyValue);
                    BlockMakerEntity aNewEntity = new BlockMakerEntity(aBlockId, aGroup);
                    String[] someConvs = someBlockProperties.getProperty(anToProp).split(",");
                    aNewEntity.myConvertions = new int[someConvs.length][];
                    int index = 0;
                    String[] stringArray = someConvs;
                    int n = someConvs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String aConv = stringArray[n2];
                        String[] splitConv = aConv.split("\\|");
                        if (splitConv.length == 2) {
                            aNewEntity.myConvertions[index] = new int[2];
                            aNewEntity.myConvertions[index][0] = Integer.parseInt(splitConv[0]);
                            aNewEntity.myConvertions[index][1] = Integer.parseInt(splitConv[1]);
                        }
                        ++index;
                        ++n2;
                    }
                    this.myConvertions.put(aNewEntity.blockId, aNewEntity);
                    ++count;
                    continue;
                }
                noMore = true;
            }
            this.makableBlockList = new int[this.myConvertions.values().size()];
            int index = 0;
            for (BlockMakerEntity anEntity : this.myConvertions.values()) {
                this.makableBlockList[index] = anEntity.blockId;
                ++index;
            }
            for (BlockMakerEntity anEntity : this.myConvertions.values()) {
                String gName = anEntity.group;
                if (this.myGroupConvertions.get(gName) == null) {
                    this.myGroupConvertions.put(gName, new ArrayList());
                }
                this.myGroupConvertions.get(gName).add(anEntity.blockId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BlockMakerConvertion getInstance() {
        if (myInstance == null) {
            myInstance = new BlockMakerConvertion();
            return myInstance;
        }
        return myInstance;
    }

    public BlockMakerEntity getEntityForBlock(int blockId) {
        return this.myConvertions.get(blockId);
    }

    public int[] getMakableBlocks() {
        return this.makableBlockList;
    }

    public Map<String, List<Integer>> getMyGroupConvertions() {
        return this.myGroupConvertions;
    }

    public void setMyGroupConvertions(Map<String, List<Integer>> myGroupConvertions) {
        this.myGroupConvertions = myGroupConvertions;
    }
}

