/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiButton;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiLabel;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiMouseListener;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.terra.area.chunks.provider.BlockMetaData;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class MetaValueOverlay
extends Overlay
implements GuiMouseListener {
    private GuiPanel myPanel;
    private GuiButton myIncreseBlocks;
    private GuiButton myDecreaseBlocks;
    private GuiLabel myMakeAmountLabel;
    private GuiLabel myPropertyNameLabel;
    private int myNewW;
    private int myNewH;
    private BlockMetaData myBlockMetaData;
    private String myPropertyToSet;
    private int myMaxVal;
    private int myMinVal;

    public MetaValueOverlay(int sw, int sh) {
        super("metavalue");
        this.setzIndex(10);
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        this.myNewW = sw;
        this.myNewH = sh;
        this.myPanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myDecreaseBlocks = new GuiButton(0, 0, 0, 0, "<", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myIncreseBlocks = new GuiButton(0, 0, 0, 0, ">", new Vector3(0.5, 0.5, 0.5), new Vector3(0.6, 0.6, 0.6));
        this.myMakeAmountLabel = new GuiLabel(0, 0, 0, 0, "0", new Vector3(0.5, 0.5, 0.5));
        this.myPropertyNameLabel = new GuiLabel(0, 0, 0, 0, "none", new Vector3(0.5, 0.5, 0.5));
        this.myDecreaseBlocks.addMouseListener(this);
        this.myIncreseBlocks.addMouseListener(this);
        this.myPanel.addComponent(this.myDecreaseBlocks);
        this.myPanel.addComponent(this.myIncreseBlocks);
        this.myPanel.addComponent(this.myMakeAmountLabel);
        this.myPanel.addComponent(this.myPropertyNameLabel);
    }

    @Override
    public void resize(int newW, int newH) {
        this.myNewW = newW;
        this.myNewH = newH;
    }

    public String getMyPropertyToSet() {
        return this.myPropertyToSet;
    }

    public void setMyPropertyToSet(String myPropertyToSet) {
        this.myPropertyToSet = myPropertyToSet;
    }

    public void newMetaDataValue(BlockMetaData theBlockMeta) {
        this.myBlockMetaData = theBlockMeta;
        String propertyVal = this.myBlockMetaData.extraData.get(this.myPropertyToSet);
        int valueOfProperty = this.myMinVal;
        if (propertyVal != null) {
            valueOfProperty = Integer.parseInt(propertyVal);
        }
        int tenOfSw = this.myNewW / 10;
        int tenOfSh = this.myNewH / 10;
        int itemSize = 68;
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = 0;
        this.myPanel.getBox().x = tenOfSw + offset;
        this.myPanel.getBox().y = tenOfSh * 6;
        this.myPanel.getBox().w = this.myNewW - 2 * tenOfSw;
        this.myPanel.getBox().h = tenOfSw * 2;
        this.myPanel.setVisible(true);
        this.myDecreaseBlocks.getBox().x = tenOfSw * 5 - 128;
        this.myDecreaseBlocks.getBox().y = (float)tenOfSh * 6.5f;
        this.myDecreaseBlocks.getBox().w = 64.0f;
        this.myDecreaseBlocks.getBox().h = 128.0f;
        this.myMakeAmountLabel.getBox().x = (float)(tenOfSw * 5) - 64.0f;
        this.myMakeAmountLabel.getBox().y = (float)tenOfSh * 6.5f;
        this.myMakeAmountLabel.getBox().w = 128.0f;
        this.myMakeAmountLabel.getBox().h = 128.0f;
        this.myMakeAmountLabel.setMyText(Integer.toString(valueOfProperty));
        this.myIncreseBlocks.getBox().x = tenOfSw * 5 + 64;
        this.myIncreseBlocks.getBox().y = (float)tenOfSh * 6.5f;
        this.myIncreseBlocks.getBox().w = 64.0f;
        this.myIncreseBlocks.getBox().h = 128.0f;
        this.myPropertyNameLabel.getBox().x = tenOfSw;
        this.myPropertyNameLabel.getBox().y = (float)tenOfSh * 6.5f - 128.0f;
        this.myPropertyNameLabel.getBox().w = tenOfSw * 8;
        this.myPropertyNameLabel.getBox().h = 128.0f;
        this.myPropertyNameLabel.setMyText(this.myPropertyToSet);
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.myPanel.isVisible()) {
            this.myPanel.render(theGl, theGlu);
        }
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseMove(e);
            this.myPanel.mouseOver(e);
        }
    }

    @Override
    public void click(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.click(e);
        }
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseOver(e);
        }
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseLeave(e);
        }
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.keyEvent(e);
        }
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        if (this.myPanel.isVisible()) {
            this.myPanel.mouseReleased(e);
        }
    }

    @Override
    public void click(GuiMouseEvent e, Component trigger) {
        if (trigger == this.myDecreaseBlocks) {
            String propertyVal = this.myBlockMetaData.extraData.get(this.myPropertyToSet);
            int valueOfProperty = this.myMinVal;
            if (propertyVal != null) {
                valueOfProperty = Integer.parseInt(propertyVal);
            }
            if (valueOfProperty > this.myMinVal) {
                this.myBlockMetaData.extraData.put(this.myPropertyToSet, Integer.toString(--valueOfProperty));
            }
            this.myMakeAmountLabel.setMyText(Integer.toString(valueOfProperty));
        } else if (trigger == this.myIncreseBlocks) {
            String propertyVal = this.myBlockMetaData.extraData.get(this.myPropertyToSet);
            int valueOfProperty = this.myMinVal;
            if (propertyVal != null) {
                valueOfProperty = Integer.parseInt(propertyVal);
            }
            if (valueOfProperty < this.myMaxVal) {
                this.myBlockMetaData.extraData.put(this.myPropertyToSet, Integer.toString(++valueOfProperty));
            }
            this.myMakeAmountLabel.setMyText(Integer.toString(valueOfProperty));
        }
    }

    public int getMyMaxVal() {
        return this.myMaxVal;
    }

    public void setMyMaxVal(int myMaxVal) {
        this.myMaxVal = myMaxVal;
    }

    public int getMyMinVal() {
        return this.myMinVal;
    }

    public void setMyMinVal(int myMinVal) {
        this.myMinVal = myMinVal;
    }
}

