/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.Game;
import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiButton;
import com.js.test.engine.gui.GuiCheckbox;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiLabel;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiMouseListener;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.gui.impl.LoadGameListener;
import com.js.test.engine.player.Player;
import com.js.test.terra.math.Vector3;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class MainMenuOverlay
extends Overlay
implements GuiMouseListener {
    private GuiPanel myPanel;
    private GuiButton myNewGameButton;
    private GuiButton myLoadGameButton;
    private GuiButton mySettingsButton;
    private GuiButton myQuitButton;
    private Player myPlayer;
    private Game myGame;
    private GuiPanel myStartPanel;
    private GuiPanel myLoadGamePanel;
    private List<GuiButton> myLoadGameSavesButtons;
    private GuiButton myLoadGameNextButton;
    private GuiButton myLoadGamePrevButton;
    private GuiButton myLoadGameExitButton;
    private int myLoadGameIndex;
    private int myLoadGameSaveLength;
    private GuiPanel myNewGamePanel;
    private GuiCheckbox myLargeWorldOption;
    private GuiButton myCreateNewGame;
    private GuiLabel myLargeWorldOptionLabel;
    private GuiButton myNewGameExitButton;
    private int myNewH;
    private int myNewW;

    public MainMenuOverlay(int sw, int sh, Player player, Game theGame) {
        super("mainmenu");
        this.myPlayer = player;
        this.myGame = theGame;
        this.init(sw, sh);
        this.setzIndex(100);
        this.myLoadGameSavesButtons = new ArrayList<GuiButton>();
    }

    @Override
    public void init(int sw, int sh) {
        this.myPanel = new GuiPanel(0, 0, sw, sh, new Vector3(1.0, 1.0, 1.0), 0.0f);
        this.myStartPanel = new GuiPanel(0, 0, sw, sh, new Vector3(1.0, 1.0, 1.0), 0.0f);
        this.myLoadGamePanel = new GuiPanel(0, 0, sw, sh, new Vector3(1.0, 1.0, 1.0), 0.0f);
        this.myNewGamePanel = new GuiPanel(0, 0, sw, sh, new Vector3(1.0, 1.0, 1.0), 0.0f);
        this.myNewGameButton = new GuiButton(sw / 2 - 200, sh / 2 - 100, 400, 60, "new game", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myLoadGameButton = new GuiButton(sw / 2 - 200, sh / 2 - 30, 400, 60, "load game", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.mySettingsButton = new GuiButton(sw / 2 - 200, sh / 2 + 40, 400, 60, "settings", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myQuitButton = new GuiButton(sw / 2 - 200, sh / 2 + 110, 400, 60, "quit", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myNewGameButton.addMouseListener(this);
        this.myLoadGameButton.addMouseListener(this);
        this.myQuitButton.addMouseListener(this);
        this.myStartPanel.addComponent(this.myNewGameButton);
        this.myStartPanel.addComponent(this.myLoadGameButton);
        this.myStartPanel.addComponent(this.mySettingsButton);
        this.myStartPanel.addComponent(this.myQuitButton);
        this.myLoadGamePanel.setVisible(false);
        this.myLoadGameNextButton = new GuiButton(0, 0, 0, 0, ">", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myLoadGamePrevButton = new GuiButton(0, 0, 0, 0, "<", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myLoadGameExitButton = new GuiButton(0, 0, 0, 0, "back", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myLoadGameIndex = 0;
        this.myLoadGameExitButton.addMouseListener(this);
        this.myLoadGameNextButton.addMouseListener(this);
        this.myLoadGamePrevButton.addMouseListener(this);
        this.myNewGamePanel.setVisible(false);
        this.myLargeWorldOption = new GuiCheckbox(0, 0, 0, 0, false);
        this.myLargeWorldOptionLabel = new GuiLabel(0, 0, 0, 0, "Use 512 mega chunks. Not for the fainthearted gpu", new Vector3(0.3, 0.3, 0.3));
        this.myCreateNewGame = new GuiButton(0, 0, 0, 0, "create world", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myNewGameExitButton = new GuiButton(0, 0, 0, 0, "back", new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
        this.myCreateNewGame.addMouseListener(this);
        this.myNewGameExitButton.addMouseListener(this);
        this.myNewGamePanel.addComponent(this.myLargeWorldOption);
        this.myNewGamePanel.addComponent(this.myLargeWorldOptionLabel);
        this.myNewGamePanel.addComponent(this.myCreateNewGame);
        this.myNewGamePanel.addComponent(this.myNewGameExitButton);
        this.myPanel.addComponent(this.myStartPanel);
        this.myPanel.addComponent(this.myLoadGamePanel);
        this.myPanel.addComponent(this.myNewGamePanel);
    }

    @Override
    public void resize(int newW, int newH) {
        this.myNewH = newH;
        this.myNewW = newW;
        this.myPanel.getBox().w = newW;
        this.myPanel.getBox().h = newH;
        this.myStartPanel.getBox().w = newW;
        this.myStartPanel.getBox().h = newH;
        this.myLoadGamePanel.getBox().w = newW;
        this.myLoadGamePanel.getBox().h = newH;
        this.myNewGamePanel.getBox().w = newW;
        this.myNewGamePanel.getBox().h = newH;
        this.myNewGameButton.getBox().x = newW / 2 - 200;
        this.myNewGameButton.getBox().y = newH / 2 - 100;
        this.myLoadGameButton.getBox().x = newW / 2 - 200;
        this.myLoadGameButton.getBox().y = newH / 2 - 30;
        this.mySettingsButton.getBox().x = newW / 2 - 200;
        this.mySettingsButton.getBox().y = newH / 2 + 40;
        this.myQuitButton.getBox().x = newW / 2 - 200;
        this.myQuitButton.getBox().y = newH / 2 + 110;
        this.myLoadGameExitButton.getBox().x = (int)((float)this.myNewW * 0.1f);
        this.myLoadGameExitButton.getBox().y = 600 + this.myNewH / 10;
        this.myLoadGameExitButton.getBox().w = (int)((float)this.myNewW * 0.3f);
        this.myLoadGameExitButton.getBox().h = 90.0f;
        this.myLoadGameNextButton.getBox().x = (int)((float)this.myNewW * 0.1f) + 50 + (int)((float)this.myNewW * 0.2f);
        this.myLoadGameNextButton.getBox().y = 600 + this.myNewH / 10;
        this.myLoadGameNextButton.getBox().w = (int)((float)this.myNewW * 0.2f);
        this.myLoadGameNextButton.getBox().h = 90.0f;
        this.myLoadGamePrevButton.getBox().x = (int)((float)this.myNewW * 0.1f) + 50 + (int)((float)this.myNewW * 0.2f) + 50 + (int)((float)this.myNewW * 0.2f);
        this.myLoadGamePrevButton.getBox().y = 600 + this.myNewH / 10;
        this.myLoadGamePrevButton.getBox().w = (int)((float)this.myNewW * 0.2f);
        this.myLoadGamePrevButton.getBox().h = 90.0f;
        int index = 0;
        for (GuiButton aButton : this.myLoadGameSavesButtons) {
            int y = index * 100 + this.myNewH / 10;
            int x = (int)((float)this.myNewW * 0.1f);
            int w = (int)((float)this.myNewW * 0.8f);
            int h = 90;
            aButton.getBox().x = x;
            aButton.getBox().y = y;
            aButton.getBox().w = w;
            aButton.getBox().h = h;
            ++index;
        }
        this.myLargeWorldOption.getBox().x = (int)((float)this.myNewW * 0.2f);
        this.myLargeWorldOption.getBox().y = this.myNewH / 10;
        this.myLargeWorldOption.getBox().w = 64.0f;
        this.myLargeWorldOption.getBox().h = 64.0f;
        this.myLargeWorldOptionLabel.getBox().x = (int)((float)this.myNewW * 0.2f) + 128;
        this.myLargeWorldOptionLabel.getBox().y = this.myNewH / 10;
        this.myLargeWorldOptionLabel.getBox().w = (float)this.myNewW * 0.5f;
        this.myLargeWorldOptionLabel.getBox().h = 64.0f;
        this.myCreateNewGame.getBox().x = (int)((float)this.myNewW * 0.2f);
        this.myCreateNewGame.getBox().y = this.myNewH / 10 + 128;
        this.myCreateNewGame.getBox().w = (int)((float)this.myNewW * 0.6f);
        this.myCreateNewGame.getBox().h = 64.0f;
        this.myNewGameExitButton.getBox().x = (int)((float)this.myNewW * 0.2f);
        this.myNewGameExitButton.getBox().y = this.myNewH / 10 + 256;
        this.myNewGameExitButton.getBox().w = (int)((float)this.myNewW * 0.6f);
        this.myNewGameExitButton.getBox().h = 64.0f;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        this.myPanel.render(theGl, theGlu);
    }

    @Override
    public void click(GuiMouseEvent e) {
        this.myPanel.click(e);
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        this.myPanel.mouseOver(e);
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.myPanel.mouseLeave(e);
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        this.myPanel.keyEvent(e);
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        this.myPanel.mouseOver(e);
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        this.myPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        this.myPanel.mouseReleased(e);
    }

    @Override
    public void click(GuiMouseEvent e, Component trigger) {
        if (trigger == this.myLoadGameButton) {
            this.myStartPanel.setVisible(false);
            this.myLoadGamePanel.setVisible(true);
            File aDirectoryOfSaves = new File("saves/");
            this.myLoadGameIndex = 0;
            this.myLoadGameSaveLength = 0;
            File[] fileArray = aDirectoryOfSaves.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File aSaveDir = fileArray[n2];
                if (aSaveDir.isDirectory()) {
                    ++this.myLoadGameSaveLength;
                }
                ++n2;
            }
            this.createButtonList(this.myLoadGameIndex, 5);
        } else if (trigger == this.myLoadGameExitButton) {
            this.myStartPanel.setVisible(true);
            this.myLoadGamePanel.setVisible(false);
        } else if (trigger != this.myLoadGameNextButton && trigger != this.myLoadGamePrevButton) {
            if (trigger == this.myQuitButton) {
                if (this.myPlayer.isPlaying()) {
                    this.myGame.myChunkProvider.save();
                }
                this.myGame.exit();
            } else if (trigger == this.myCreateNewGame) {
                this.myGame.createNewGameSize = this.myLargeWorldOption.isMyState() ? 512 : 256;
                this.myGame.createNewGame = true;
            } else if (trigger == this.myNewGameButton) {
                this.myStartPanel.setVisible(false);
                this.myNewGamePanel.setVisible(true);
            } else if (trigger == this.myNewGameExitButton) {
                this.myStartPanel.setVisible(true);
                this.myNewGamePanel.setVisible(false);
            }
        }
    }

    private void createButtonList(int from, int length) {
        this.myLoadGameSavesButtons.clear();
        this.myLoadGamePanel.getMyComponents().clear();
        File aDirectoryOfSaves = new File("saves/");
        int index = 0;
        File[] fileArray = aDirectoryOfSaves.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File aSaveDir = fileArray[n2];
            if (aSaveDir.isDirectory()) {
                if (index >= from && index < from + length) {
                    int y = (index - from) * 100 + this.myNewH / 10;
                    int x = (int)((float)this.myNewW * 0.1f);
                    int w = (int)((float)this.myNewW * 0.8f);
                    int h = 90;
                    GuiButton aNewButton = new GuiButton(x, y, w, h, aSaveDir.getName(), new Vector3(0.3, 0.3, 0.3), new Vector3(0.6, 0.6, 0.6));
                    LoadGameListener aListener = new LoadGameListener(this.myPlayer, this.myGame, aSaveDir.getName());
                    aNewButton.addMouseListener(aListener);
                    this.myLoadGamePanel.addComponent(aNewButton);
                    this.myLoadGameSavesButtons.add(aNewButton);
                }
                ++index;
            }
            ++n2;
        }
        this.myLoadGameExitButton.getBox().x = (int)((float)this.myNewW * 0.1f);
        this.myLoadGameExitButton.getBox().y = 600 + this.myNewH / 10;
        this.myLoadGameExitButton.getBox().w = (int)((float)this.myNewW * 0.2f);
        this.myLoadGameExitButton.getBox().h = 90.0f;
        this.myLoadGamePrevButton.getBox().x = (int)((float)this.myNewW * 0.1f) + 50 + (int)((float)this.myNewW * 0.2f);
        this.myLoadGamePrevButton.getBox().y = 600 + this.myNewH / 10;
        this.myLoadGamePrevButton.getBox().w = (int)((float)this.myNewW * 0.2f);
        this.myLoadGamePrevButton.getBox().h = 90.0f;
        this.myLoadGameNextButton.getBox().x = (int)((float)this.myNewW * 0.1f) + 50 + (int)((float)this.myNewW * 0.2f) + 50 + (int)((float)this.myNewW * 0.2f);
        this.myLoadGameNextButton.getBox().y = 600 + this.myNewH / 10;
        this.myLoadGameNextButton.getBox().w = (int)((float)this.myNewW * 0.2f);
        this.myLoadGameNextButton.getBox().h = 90.0f;
        this.myLoadGamePanel.addComponent(this.myLoadGameExitButton);
        this.myLoadGamePanel.addComponent(this.myLoadGameNextButton);
        this.myLoadGamePanel.addComponent(this.myLoadGamePrevButton);
    }

    public void reset() {
        this.myStartPanel.setVisible(true);
        this.myLoadGamePanel.setVisible(false);
        this.myNewGamePanel.setVisible(false);
    }
}

