/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui.impl;

import com.js.test.engine.gui.GuiItemContainer;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiPanel;
import com.js.test.engine.gui.Overlay;
import com.js.test.engine.player.Inventory;
import com.js.test.terra.math.Vector3;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class ContainerOverlay
extends Overlay {
    private GuiPanel myPanel;
    private GuiItemContainer myItemContainer;
    private int myNewW;
    private int myNewH;
    private Inventory myInventory;

    public ContainerOverlay(int sw, int sh) {
        super("container");
        this.init(sw, sh);
    }

    @Override
    public void init(int sw, int sh) {
        this.myNewW = sw;
        this.myNewH = sh;
        this.myPanel = new GuiPanel(0, 0, 0, 0, new Vector3(0.4, 0.4, 0.4), 1.0f);
        this.myItemContainer = new GuiItemContainer(0, 0, 0, 0, 0, 0, null);
        this.myPanel.addComponent(this.myItemContainer);
    }

    @Override
    public void resize(int newW, int newH) {
        this.myNewW = newW;
        this.myNewH = newH;
    }

    public void newInventory(Inventory theInventory) {
        this.myInventory = theInventory;
        int tenOfSw = this.myNewW / 10;
        int tenOfSh = this.myNewH / 10;
        int itemSize = (this.myNewW - 2 * tenOfSw) / this.getMyInventory().getMyW();
        if (itemSize > 68) {
            itemSize = 68;
        }
        int offset = (this.myNewW - 2 * tenOfSw - itemSize * this.getMyInventory().getMyW()) / 2;
        this.myPanel.getBox().x = tenOfSw + offset;
        this.myPanel.getBox().y = tenOfSh * 6;
        this.myPanel.getBox().w = this.myNewW - 2 * tenOfSw - offset * 2;
        this.myPanel.getBox().h = itemSize * this.getMyInventory().getMyH();
        this.myItemContainer.setMyInventory(theInventory);
        this.myItemContainer.getBox().x = tenOfSw;
        this.myItemContainer.getBox().y = tenOfSh * 6;
        this.myItemContainer.getBox().w = this.myNewW - 2 * tenOfSw;
        this.myItemContainer.getBox().h = itemSize * this.getMyInventory().getMyH();
        this.myItemContainer.setMyItemSize(itemSize);
        this.myItemContainer.setMyOffset(offset);
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        this.myPanel.render(theGl, theGlu);
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        this.myPanel.mouseMove(e);
    }

    @Override
    public void click(GuiMouseEvent e) {
        this.myPanel.click(e);
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        this.myPanel.mouseOver(e);
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        this.myPanel.mouseLeave(e);
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
        this.myPanel.keyEvent(e);
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
        this.myPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
        this.myPanel.mouseReleased(e);
    }

    public Inventory getMyInventory() {
        return this.myInventory;
    }

    public void setMyInventory(Inventory myInventory) {
        this.myInventory = myInventory;
    }
}

