/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui;

import com.js.test.engine.gui.Draggable;
import com.js.test.engine.gui.Overlay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OverlayHandler {
    private static OverlayHandler myInstance;
    Map<String, Overlay> myOverlays = new HashMap<String, Overlay>();
    private Map<String, Overlay> myActiveOverlays = new HashMap<String, Overlay>();
    private Draggable myDraggable;

    private OverlayHandler() {
    }

    public static OverlayHandler getInstance() {
        if (myInstance == null) {
            myInstance = new OverlayHandler();
            return myInstance;
        }
        return myInstance;
    }

    public void addOverlay(Overlay theOverlay) {
        this.myOverlays.put(theOverlay.getName(), theOverlay);
    }

    public Overlay getOverlay(String theName) {
        return this.myOverlays.get(theName);
    }

    public void resizeOverlays(int theNewW, int theNewH) {
        for (Overlay anOverlay : this.myOverlays.values()) {
            anOverlay.resize(theNewW, theNewH);
        }
    }

    public void addActiveOverlay(String theName) {
        Overlay anOverlay = this.myOverlays.get(theName);
        if (anOverlay != null) {
            this.myActiveOverlays.put(theName, anOverlay);
        }
    }

    public void removeActiveOverlay(String theName) {
        this.myActiveOverlays.remove(theName);
    }

    public List<Overlay> getActiveOverlays() {
        ArrayList<Overlay> anReturnList = new ArrayList<Overlay>();
        for (Overlay anOverlay : this.myActiveOverlays.values()) {
            anReturnList.add(anOverlay);
        }
        return anReturnList;
    }

    public Draggable getMyDraggable() {
        return this.myDraggable;
    }

    public void setMyDraggable(Draggable myDraggable) {
        this.myDraggable = myDraggable;
    }
}

