/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.gui;

import com.js.test.engine.gui.Component;
import com.js.test.engine.gui.GuiKeyEvent;
import com.js.test.engine.gui.GuiMouseEvent;
import com.js.test.engine.gui.GuiMouseListener;
import com.js.test.engine.material.TextureHandler;
import com.js.test.engine.text.TextEntry;
import com.js.test.engine.text.TextHandler;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class GuiBlockIcon
extends Component {
    private int myBlockId;
    private String myName;
    private int myMouseX;
    private int myMouseY;

    public GuiBlockIcon(int x, int y, int w, int h, int blockId, String name) {
        super(x, y, w, h);
        this.myBlockId = blockId;
        this.myName = name;
        this.myMouseX = -1;
        this.myMouseY = -1;
    }

    @Override
    public void render(GL2 theGl, GLU theGlu) {
        if (this.myBlockId > 0) {
            int startX = (int)this.myBox.x;
            int startY = (int)this.myBox.y;
            int w = (int)this.myBox.w;
            int h = (int)this.myBox.h;
            theGl.glEnable(3553);
            theGl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            TextureHandler.getInstance().bindBlockTexture(this.myBlockId, theGl, 0);
            theGl.glBegin(7);
            theGl.glTexCoord2f(0.0f, 1.0f);
            theGl.glVertex2f((float)startX, (float)startY);
            theGl.glTexCoord2f(0.0f, 0.0f);
            theGl.glVertex2f((float)startX, (float)(startY + h));
            theGl.glTexCoord2f(1.0f, 0.0f);
            theGl.glVertex2f((float)(startX + w), (float)(startY + h));
            theGl.glTexCoord2f(1.0f, 1.0f);
            theGl.glVertex2f((float)(startX + w), (float)startY);
            theGl.glEnd();
            theGl.glDisable(3553);
            if (this.myMouseX > -1 && this.myMouseY > -1) {
                TextHandler.getInstance().addEntry(new TextEntry(this.myName, this.myMouseX, this.myMouseY + 64));
            }
        }
    }

    @Override
    public void click(GuiMouseEvent e) {
        for (GuiMouseListener gml : this.myMouseListeners) {
            gml.click(e, this);
        }
    }

    @Override
    public void mouseOver(GuiMouseEvent e) {
        System.out.println("mover: " + this.myName);
    }

    @Override
    public void mouseLeave(GuiMouseEvent e) {
        System.out.println("mleave: " + this.myName);
        this.myMouseX = -1;
        this.myMouseY = -1;
    }

    @Override
    public void mouseMove(GuiMouseEvent e) {
        this.myMouseX = e.x;
        this.myMouseY = e.y;
    }

    @Override
    public void mousePressed(GuiMouseEvent e) {
    }

    @Override
    public void mouseReleased(GuiMouseEvent e) {
    }

    @Override
    public void draggedNotHandeled() {
    }

    @Override
    public void keyEvent(GuiKeyEvent e) {
    }

    public int getMyBlockId() {
        return this.myBlockId;
    }

    public void setMyBlockId(int myBlockId) {
        this.myBlockId = myBlockId;
    }

    public String getMyName() {
        return this.myName;
    }

    public void setMyName(String myName) {
        this.myName = myName;
    }
}

