/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.camera;

import com.js.test.engine.camera.Plane;
import com.js.test.terra.math.Vector3;

public class Frustrum {
    private Plane[] myPlanes;

    public void createFrustrum(float[] incomingMatrix) {
        this.myPlanes = new Plane[6];
        this.myPlanes[0] = new Plane();
        this.myPlanes[0].a = incomingMatrix[3] + incomingMatrix[2];
        this.myPlanes[0].b = incomingMatrix[7] + incomingMatrix[6];
        this.myPlanes[0].c = incomingMatrix[11] + incomingMatrix[10];
        this.myPlanes[0].d = incomingMatrix[15] + incomingMatrix[14];
        this.myPlanes[1] = new Plane();
        this.myPlanes[1].a = incomingMatrix[3] - incomingMatrix[2];
        this.myPlanes[1].b = incomingMatrix[7] - incomingMatrix[6];
        this.myPlanes[1].c = incomingMatrix[11] - incomingMatrix[10];
        this.myPlanes[1].d = incomingMatrix[15] - incomingMatrix[14];
        this.myPlanes[2] = new Plane();
        this.myPlanes[2].a = incomingMatrix[3] + incomingMatrix[0];
        this.myPlanes[2].b = incomingMatrix[7] + incomingMatrix[4];
        this.myPlanes[2].c = incomingMatrix[11] + incomingMatrix[8];
        this.myPlanes[2].d = incomingMatrix[15] + incomingMatrix[12];
        this.myPlanes[3] = new Plane();
        this.myPlanes[3].a = incomingMatrix[3] - incomingMatrix[0];
        this.myPlanes[3].b = incomingMatrix[7] - incomingMatrix[4];
        this.myPlanes[3].c = incomingMatrix[11] - incomingMatrix[8];
        this.myPlanes[3].d = incomingMatrix[15] - incomingMatrix[12];
        this.myPlanes[4] = new Plane();
        this.myPlanes[4].a = incomingMatrix[3] - incomingMatrix[1];
        this.myPlanes[4].b = incomingMatrix[7] - incomingMatrix[5];
        this.myPlanes[4].c = incomingMatrix[11] - incomingMatrix[9];
        this.myPlanes[4].d = incomingMatrix[15] - incomingMatrix[13];
        this.myPlanes[5] = new Plane();
        this.myPlanes[5].a = incomingMatrix[3] + incomingMatrix[1];
        this.myPlanes[5].b = incomingMatrix[7] + incomingMatrix[5];
        this.myPlanes[5].c = incomingMatrix[11] + incomingMatrix[9];
        this.myPlanes[5].d = incomingMatrix[15] + incomingMatrix[13];
        Plane[] planeArray = this.myPlanes;
        int n = this.myPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            Plane aPlane = planeArray[n2];
            aPlane.normalizePlane();
            ++n2;
        }
    }

    public int containsSphere(Vector3 center, float radius, boolean isLeaf) {
        Plane[] planeArray = this.myPlanes;
        int n = this.myPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            Plane aPlane = planeArray[n2];
            float fDistance = aPlane.distanceToPlane(center);
            if (fDistance < 0.0f) {
                if (fDistance > -radius) {
                    return 1;
                }
                return 0;
            }
            if (fDistance < radius) {
                return 1;
            }
            ++n2;
        }
        return 2;
    }

    public int containsBox(Vector3[] box) {
        int totalAllInside = 0;
        Plane[] planeArray = this.myPlanes;
        int n = this.myPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            Plane aPlane = planeArray[n2];
            int vecTest = 0;
            Vector3[] vector3Array = box;
            int n3 = box.length;
            int n4 = 0;
            while (n4 < n3) {
                Vector3 aVector = vector3Array[n4];
                vecTest += aPlane.sideOfPlane(aVector);
                ++n4;
            }
            if (vecTest == -8) {
                return 0;
            }
            if (vecTest == 8) {
                ++totalAllInside;
            }
            ++n2;
        }
        if (totalAllInside == 6) {
            return 2;
        }
        return 1;
    }

    public Plane[] getPlanes() {
        return this.myPlanes;
    }

    public String toString() {
        String printMe = "";
        Plane[] planeArray = this.myPlanes;
        int n = this.myPlanes.length;
        int n2 = 0;
        while (n2 < n) {
            Plane aPlane = planeArray[n2];
            printMe = String.valueOf(printMe) + aPlane.toString();
            ++n2;
        }
        return "{" + printMe + "}";
    }
}

