/*
 * Decompiled with CFR 0.152.
 */
package com.js.test.engine.camera;

import com.js.test.engine.camera.Frustrum;

public class Camera {
    private double x;
    private double y;
    private double z;
    private double vx;
    private double vy;
    private double vz;
    private double rotX;
    private double rotY;
    private Frustrum myFrustrum;

    public Camera(double x, double y, double z, double vx, double vy, double vz, double rotX, double rotY) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.rotX = rotX;
        this.rotY = rotY;
        this.myFrustrum = new Frustrum();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getVx() {
        return this.vx;
    }

    public void setVx(double vx) {
        this.vx = vx;
    }

    public double getVy() {
        return this.vy;
    }

    public void setVy(double vy) {
        this.vy = vy;
    }

    public double getVz() {
        return this.vz;
    }

    public void setVz(double vz) {
        this.vz = vz;
    }

    public double getLookX() {
        return this.x + this.vx;
    }

    public double getLookY() {
        return this.y + this.vy;
    }

    public double getLookZ() {
        return this.z + this.vz;
    }

    public void flyForward(double amount) {
        this.x += this.vx * amount;
        this.y += this.vy * amount;
        this.z += this.vz * amount;
    }

    public void flyBackwards(double amount) {
        this.x -= this.vx * amount;
        this.y -= this.vy * amount;
        this.z -= this.vz * amount;
    }

    public Frustrum getFrustrum() {
        return this.myFrustrum;
    }

    public double getRotX() {
        return this.rotX;
    }

    public void setRotX(double rotX) {
        this.rotX = rotX;
    }

    public double getRotY() {
        return this.rotY;
    }

    public void setRotY(double rotY) {
        this.rotY = rotY;
    }
}

