

uniform sampler2D bt;
uniform sampler2D track;
uniform sampler2D pos;
uniform sampler2D wform;
uniform mat4 camera;
uniform float time;
uniform mat3 rot;
uniform vec3 trans;
in vec2 uv;
out vec4 texOut;

float sdCylinder( vec4 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

float sdBox( vec4 p, vec3 b )
{
  vec3  di = abs(p.xyz) - b;
  float mc = max(di.x, max(di.y,di.z));
  return min(mc,length(max(di,0.0)));
}

float sdSphere( vec4 p, float s )
{
  return length(p.xyz)-s;
}

float sdPlane( vec4 p, vec4 n )
{
	return dot(p.xyz,n.xyz) + n.w;
}

float dista(vec4 r, float fa, float fk, float ld){
	float d = 100000000.0;
//	d = distance(vec3(0.0,0.0,0.0),r.xyz)-20.0;
	
	float f = snoise(vec3(r.xz*0.0005,fa*0.05));
	float g = snoise(r.xz*0.000125);
	float c = texture2D(wform, vec2(f*0.05+0.05,0.5)).r*12000.0;
	r.y -= c;
	r.y+=g*1000.0+f*300.0;
	vec4 i = r;
	r.xz = mod(r.xz,500)-250;
	d = min(d, sdBox(r, vec3(1.0,1.0,1.0)*200.0));
	r.xz = mod(i.xz,200)-100;
	r.y-=900;
	d = min(d, sdSphere(r, -1)); 
	r.y-=300;
	d = min(d, sdSphere(r, -1)); 
	
	r.z=i.z;
	float u=time;

	r.z = mod(r.z,14000)-7000;
	r.z+=r.x;
	r.yx = r.xy;

	r.x-=r.y*10.0/(1.0+ld*0.1);
	

	d = min(d, sdCylinder(r, vec3(1.0,1525.0,2000.0+c)));

	return d;
}

float distb(vec4 r, float fa, float fk){
	float d = 100000000.0;
//	d = distance(vec3(0.0,0.0,0.0),r.xyz)-20.0;
	
	float f = snoise(vec3(r.xz*0.00005,fk*0.075));
	float g = snoise(vec3(r.xz*0.0000125,time*0.05));
	
	r.y+=g*7000.0+f*3000.0;
	r.xz = mod(r.xz,500)-250;
	d = min(d, sdSphere(r, -100.0));
	return d;
}

float distc(vec4 r, float fa, float fk){
	vec4 i =r;
	float d = 100000000.0;
//	d = distance(vec3(0.0,0.0,0.0),r.xyz)-20.0;
	
	float f = snoise(r.xzy*0.0005);
	
	float u = f*0.004+time*0.01;
	float v = f*0.002+sin(r.x*0.000005);
	r.y=r.y*cos(u)-r.z*sin(u);
	r.z=r.y*sin(u)+r.z*cos(u);
	r.x=r.x*cos(v)-r.z*sin(v);
	r.z=r.x*sin(v)+r.z*cos(v);

	r.xzy = mod(r.xzy,5000)-2500;
	d = min(d, sdBox(r, vec3(500.0,2400.0,500.0)));
	d = min(d, sdBox(r, vec3(2400.0,500.0,500.0)));
	d = min(d, sdBox(r, vec3(500.0,500.0,2400.0)));
	d = max(d, sdBox(i+vec4(i.z,f*1000.0,0.0,0.0), vec3(10000.0,2000.0,1000000.0)));
	return d;
}

float distd(vec4 r, float fa, float fk){
	float d = 100000000.0;
	
	float f = snoise(vec3(r.xz*0.0005,fa*0.05));
	float g = snoise(r.xz*0.000125);
	r.y -= texture2D(wform, vec2(f*0.05+0.05,0.5)).r*40000.0*max(0.0,time*0.1-length(r.xz)/(time*1000.0+1.0));
	r.xz = mod(r.xz,500)-250;
	d = min(d, sdBox(r, vec3(1.0,1.0,1.0)*200.0));
	return d;
}


float diste(vec4 r, float fa, float fk){
	vec4 i =r;
	float d = 100000000.0;
	vec4 a=i;
	float f = snoise(vec2(vec2(r.y,dot(r.zx,vec2(0.01)))*0.0003+fk*0.1+fa*0.1+time))-0.5;

	r.xz = mod(i.xz,28000)-14000;
	d = min(d, sdBox(r, vec3(7000.0,20000.0,7000.0)));

	i.z+=1000;
	r.xzy = mod(i.xzy,2000)-1000;
	d = max(d,-sdBox(r, vec3(400.0,950.0,800.0)));
	i.z-=1000;
	i.x+=1000;
	r.xzy = mod(i.xzy,2000)-1000;
	d = max(d,-sdBox(r, vec3(800.0,950.0,400.0)));
	i.x-=1000;
	r.xz = mod(i.xz,28000)-14000;
	r.y=i.y;
	d = max(d,-sdBox(r, vec3(6900.0,20000.0,6900.0)));
	r.y*=0.3;
	d = min(d, sdSphere(r, 4000+f*3000));
	d = min(d, sdPlane(i, vec4(0.0,1.0,0.0,20000.0)));
	//d = min(d, sdPlane(i, vec4(0.0,-1.0,0.0,20000.0)));
	r.y+=5000+sin(i.z*0.00003+i.x*0.00001)*1500-1500;
	i.z+=14000;
	r.xz = mod(i.xz,28000)-14000;

	d = min(d, sdBox(r, vec3(14000, 100, 5000)));

	i.z-=14000;
	i.x-=14000;
	r.xz = mod(i.xz,28000)-14000;
	d = min(d, sdBox(r, vec3(5000, 100, 14000)));
	i.z+=time*10000.0;
	i.x-=1800;
	r.xz = mod(i.xz,vec2(28000,2000))-vec2(14000,1000);
	d = min(d, sdBox(r, vec3(500)));
	i.z-=time*20000.0+fa;
	i.x+=3600;
	r.xz = mod(i.xz,vec2(28000,2000))-vec2(14000,1000);
	d = min(d, sdBox(r, vec3(500)));

	return d;
}

float dist(vec4 r, float fa, float fk, float ld){
	if(fa<68)
		return distd(r, fa, fk);
	if(fa<318)
		return distc(r, fa, fk);
	if(fa<754)
		return distb(r, fa, fk);
	if(fa<1188)
		return diste(r, fa, fk);
	return dista(r, fa, fk, ld);
}

vec4 cmoda(vec4 r, float fa, vec4 tm, float fk){
	return pow(pow(tm,vec4(2.0,2.5,1.2,1.0))*vec4(1.0,3.5,2.4,1.0), vec4(0.8));
}

vec4 cmodb(vec4 r, float fa, vec4 tm, float fk){
	return tm*vec4(1.1,1.4,2.5+sin(fk),1.0)*1.0;
}

vec4 cmodc(vec4 r, float fa, vec4 tm, float fk){
	return 1.0-tm*vec4(6.1,3.4,0.9,1.0);
}
vec4 cmodd(vec4 r, float fa, vec4 tm, float fk){
	return (1.0-pow(tm,vec4(vec3(0.8),1.0))*vec4(1.0,1.0,1.0,1.0));
}
vec4 cmode(vec4 r, float fa, vec4 tm, float fk){
	return pow(tm,vec4(1.2))*vec4(1.00,1.05,1.07,1.0);
}
vec4 cmod(vec4 r, float fa, vec4 tm, float fk){

	tm *= clamp(153.5-time,0.0,1.0);

	if(fa<68)
		return cmodd(r, fa, tm,fk);
	if(fa<318)
		return cmodc(r, fa, tm,fk);
	if(fa<754)
		return cmodb(r, fa, tm,fk);
	if(fa<1188)
		return cmode(r, fa, tm,fk);
	return cmoda(r, fa, tm,fk);
}

void main(void)
{
	float fa = texture2D(pos,vec2(0.2,0.5)).r;
	float fk = texture2D(pos,vec2(0.1,0.5)).r;
	float d = -1.0;
	vec3 dir = vec3(normalize(vec3(uv.xy*2.0-1.0,1.0)*vec3(16.0/9.0,1.0,1.0)));
	dir = rot*dir;
	vec4 ray = vec4(0.0,0.0,0.0,1.0);
	ray += vec4(trans,0.0);
	float step = 0.0;
	float mstep = 150.0;
	float dm = 1.0;
	float lim = 1.0;
	while(step < mstep){
		d = dist(ray,fa,fk, d);
		if(d < lim || d > 20000.0 ) {
			break;
		}
		ray.xyz += dir * d * dm;
		step += 1.0;
	}
//	texOut = vec4(ray.xyz,cos(uv.x*100.0+d*10000.0+step*110.73+uv.y*100.0)*0.1);
	texOut = vec4(step/mstep);

	texOut = cmod(ray, fa, texOut, fk);
}

