#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include "kdm.h"

static char soundcardtype;
extern volatile long recsnddone;
extern long sbver;

volatile long count;
static void (__interrupt __far *oldtimerhandler)();
static void __interrupt __far timerhandler(void);

volatile unsigned char readch, oldreadch, extended, keystatus[256];
void (__interrupt __far *oldkeyhandler)();
void __interrupt __far keyhandler(void);

#pragma aux interruptend =\
	"mov al, 20h",\
	"out 20h, al",\
	modify [eax]\

#pragma aux readkey =\
	"in al, 0x60",\
	"mov readch, al",\
	"in al, 0x61",\
	"or al, 0x80",\
	"out 0x61, al",\
	"and al, 0x7f",\
	"out 0x61, al",\
	modify [eax]\

void __interrupt __far keyhandler()
{
	oldreadch = readch;
	readkey();
	if ((readch|1) == 0xe1)
		extended = 128;
	else
	{
		if (oldreadch != readch)
		{
			if ((readch&128) == 0)
			{
				if (keystatus[(readch&127)+extended] == 0)
					keystatus[(readch&127)+extended] = 1;
			}
			else
				keystatus[(readch&127)+extended] = 0;
		}
		extended = 0;
	}
	interruptend();
}

void __interrupt __far timerhandler()
{
	count++;
	//_chain_intr(oldtimerhandler);
	outp(0x20,0x20);
}

main(int argc, char **argv)
{
	long i, j, k, leng, fil, loopnum, onownote, nnownote;
	char ch, *ptr, somethingrecorded = 0;
	char buffer[80], kdmfil[80], dumpfil[80];

	if (argc < 2)
	{
		printf("PlayKDM [KDM file][options]                               by Kenneth Silverman\n");
		printf("KDM stands for Ken's Digital Music!\n");
		printf("Options summary: (Defaults listed on left)\n");
		printf("   ?.WAV     - Dump digital music into a wave file\n");
		printf("   r#####    - Sample rate (r6000 - r44100)\n");
		printf("   s/m       - Stereo / Mono\n");
		printf("   16/8      - Bits per Sample\n");
		printf("   sb/pas/pc - Type of sound card\n");
		printf("   hi/lo     - Quality (lo quality is about twice as fast as hi quality)\n");
		printf("   l###      - Loop # times before quitting\n");
		printf("   t###      - Tempo (default: 120)\n");
		exit(0);
	}

	initgroupfile("stuff.dat");

	samplerate = 44100;
	numspeakers = 2;
	bytespersample = 2;
	intspersec = 15;
	soundcardtype = 1;
	kdmqual = 1;
	loopnum = 0;
	globtempo = 120;

	strcpy(kdmfil,argv[1]);
	dumpfil[0] = 0;

	i = 2;
	while (i < argc)
	{
		strcpy(buffer,argv[i]);

		if (strchr(buffer,'.') != 0)
			strcpy(dumpfil,buffer);
		else
		{
			j = 0;
			while (buffer[j] == 32) j++;

			if ((buffer[j] == 'r') || (buffer[j] == 'R'))
			{
				j++;
				samplerate = 0;
				while ((buffer[j] >= 48) && (buffer[j] <= 57))
				{
					samplerate *= 10;
					samplerate += buffer[j]-48;
					j++;
				}
			}
			else if (((buffer[j] == 's') || (buffer[j] == 'S')) && ((buffer[j+1] == 'b') || (buffer[j+1] == 'B')))
				soundcardtype = 1;
			else if (((buffer[j] == 'p') || (buffer[j] == 'P')) && ((buffer[j+1] == 'a') || (buffer[j+1] == 'A')) && ((buffer[j+2] == 's') || (buffer[j+2] == 'S')))
				soundcardtype = 2;
			else if (((buffer[j] == 'p') || (buffer[j] == 'P')) && ((buffer[j+1] == 'c') || (buffer[j+1] == 'C')))
				soundcardtype = 13;
			else if ((buffer[j] == 'm') || (buffer[j] == 'M')) numspeakers = 1;
			else if ((buffer[j] == 's') || (buffer[j] == 'S')) numspeakers = 2;
			else if (buffer[j] == '8') bytespersample = 1;
			else if ((buffer[j] == '1') && (buffer[j+1] == '6')) bytespersample = 2;
			else if ((buffer[j] == 'l') || (buffer[j] == 'L'))
			{
				if ((buffer[j+1] == 'o') || (buffer[j+1] == 'O'))
					kdmqual = 0;
				else
				{
					j++;
					loopnum = 0;
					while ((buffer[j] >= 48) && (buffer[j] <= 57))
					{
						loopnum *= 10;
						loopnum += buffer[j]-48;
						j++;
					}
				}
			}
			else if ((buffer[j] == 't') || (buffer[j] == 'T'))
			{
				j++;
				globtempo = 0;
				while ((buffer[j] >= 48) && (buffer[j] <= 57))
				{
					globtempo *= 10;
					globtempo += buffer[j]-48;
					j++;
				}
			}
			else if (((buffer[j] == 'h') || (buffer[j] == 'H')) && ((buffer[j+1] == 'i') || (buffer[j+1] == 'I'))) kdmqual = 1;
		}
		i++;
	}

	if (dumpfil[0] != 0)
	{
		if (loopnum <= 0) loopnum = 1;

		if ((fil = open(dumpfil,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY,S_IWRITE)) >= 0)
		{
			write(fil,&buffer[0],44);

			initsb(255,1,samplerate,numspeakers,bytespersample,intspersec,kdmqual);
			if (loadsong(kdmfil) < 0)
			{
				uninitsb();
				uninitgroupfile();
				exit(0);
			}

			oldtimerhandler = _dos_getvect(0x8);
			_disable(); _dos_setvect(0x8, timerhandler); _enable();
			outp(0x43,0x34); outp(0x40,1243&255); outp(0x40,1243>>8);

			musicon();
			if (loopnum <= 1) musicrepeat = 0; else musicrepeat = 1;

			count = 0L;
			leng = 0L;

			i = 0;
			do
			{
				k = notecnt;
				preparesndbuf();
				if (notecnt < k)
					{ loopnum--; if (loopnum <= 1) musicrepeat = 0; }

				getsndbufinfo(&j,&k);
				ptr = (char *)j;
				if ((leng += write(fil,ptr,k)) < k)
				{
					printf("\nWhoops!  Ran out of disk space.\n");
					break;
				}
				printf("%ld ",i++);
			} while (notecnt < numnotes);

			i = count;
			printf("\nCount = %ld (960 tics/second)\n",i);

			musicoff();

			_disable(); _dos_setvect(0x8, oldtimerhandler); _enable();
			outp(0x43,0x34); outp(0x40,0); outp(0x40,0);

			uninitsb();

			buffer[0] = 'R'; buffer[1] = 'I'; buffer[2] = 'F'; buffer[3] = 'F';
			i = leng+36;
			buffer[4] = (i&255); buffer[5] = ((i>>8)&255); buffer[6] = ((i>>16)&255); buffer[7] = ((i>>24)&255);
			buffer[8] = 'W'; buffer[9] = 'A'; buffer[10] = 'V'; buffer[11] = 'E';
			buffer[12] = 'f'; buffer[13] = 'm'; buffer[14] = 't'; buffer[15] = ' ';
			buffer[16] = 16; buffer[17] = 0; buffer[18] = 0; buffer[19] = 0;
			buffer[20] = 1; buffer[21] = 0;
			buffer[22] = numspeakers; buffer[23] = 0;
			i = samplerate;
			buffer[24] = (i&255); buffer[25] = ((i>>8)&255); buffer[26] = ((i>>16)&255); buffer[27] = ((i>>24)&255);
			i = (samplerate<<(numspeakers+bytespersample-2));
			buffer[28] = (i&255); buffer[29] = ((i>>8)&255); buffer[30] = ((i>>16)&255); buffer[31] = ((i>>24)&255);
			buffer[32] = numspeakers*bytespersample; buffer[33] = 0;
			buffer[34] = (bytespersample<<3); buffer[35] = 0;
			buffer[36] = 'd'; buffer[37] = 'a'; buffer[38] = 't'; buffer[39] = 'a';
			i = leng;
			buffer[40] = (i&255); buffer[41] = ((i>>8)&255); buffer[42] = ((i>>16)&255); buffer[43] = ((i>>24)&255);
			lseek(fil,0L,SEEK_SET);
			write(fil,&buffer[0],44);

			close(fil);

			uninitgroupfile();
			exit(0);
		}
	}

	oldkeyhandler = _dos_getvect(0x9);
	_disable(); _dos_setvect(0x9, keyhandler); _enable();

	//oldtimerhandler = _dos_getvect(0x8);
	//_disable(); _dos_setvect(0x8, timerhandler); _enable();
	//outp(0x43,0x34); outp(0x40,4000&255); outp(0x40,4000>>8);

	if (loopnum <= 0) loopnum = 0x7fffffff;
	
	initsb(soundcardtype,1,samplerate,numspeakers,bytespersample,intspersec,kdmqual);
	count = 0;

	printf("%ldhz ",samplerate);
	if (numspeakers == 2) printf("Stereo "); else printf("Mono ");
	printf("%ldbit ",bytespersample<<3);
	if (kdmqual == 0) printf("Lo quality\n"); else printf("Hi quality\n");
	if (soundcardtype == 1) printf("DSP version %d.%d\n",sbver>>8,sbver&255);

	if (loadsong(kdmfil) < 0)
	{
		uninitsb();
		uninitgroupfile();
		exit(0);
	}
	musicon();
	if (loopnum <= 1) musicrepeat = 0; else musicrepeat = 1;
	nnownote = -1;

	printf("Press ESC to quit\n");
	while (keystatus[1] == 0)
	{
		onownote = nnownote; nnownote = notecnt;
		if (notecnt >= numnotes) break;
		if (nnownote < onownote) { loopnum--; if (loopnum <= 1) musicrepeat = 0; }

		if (keystatus[0x39] > 0)
		{
			keystatus[0x39] = 0;
			if (somethingrecorded == 0)
				wsay("watchit.wav",4096L,255,255);
			else
			{
				//if (bytespersample == 2) i = samplerate; else
				i = 8000L;
				wsay("recordedvoice",(i<<12)/11025,255,255);
			}

		}
		if (keystatus[0x1c])
		{
			if (soundcardtype == 1)
			{
				wrec(65536L);
				while ((recsnddone == 0) && (keystatus[0x1c]));
				continueplay();
				printf("continue playing...\n");
				somethingrecorded = 1;
			}
			else
				printf("Record only supported in Sound Blaster mode\n");
			keystatus[0x1c] = 0;
		}
		if (keystatus[0x2b] > 0)  // backslash
		{
			keystatus[0x2b] = 0;
			preparesndbuf();
		}
	}

	musicoff();
	uninitsb();
	uninitgroupfile();

	//_disable(); _dos_setvect(0x8, oldtimerhandler); _enable();
	//outp(0x43,0x34); outp(0x40,0); outp(0x40,0);

	_disable(); _dos_setvect(0x9, oldkeyhandler); _enable();
}
