<?php
//TITLE=Adlib-S3M player for QuickBasic, with effects support

$title = 'Adlib-S3M player for QuickBasic, with effects support';
$progname = 'fmengineqb';

exec('egrep "^SUB|^FUNCTION" /home/bisqwit/src/fmengineqb/fmengine.bas|sort',$output);
$funs = array();
foreach($output as $fun)
  $funs[] = '<code>'.htmlspecialchars(ereg_replace('.* ','',ereg_replace(' \(.*', '', $fun))).'()</code>';
$funlist = '';
for($c=0; $c<count($funs); $c++)
{
  if($c==count($funs)-1)$funlist .= ' and ';
  elseif($c > 0)$funlist .= ', ';
  $funlist .= $funs[$c];
}

$text = array(
   '1. Purpose' => "

Some entirely in QuickBasic written subroutines for playing Adlib-S3M
or MidiS3M files in a QuickBasic program.

", '1. Short example' => "

<code>
'\$INCLUDE: 'fmengine.bi'<br>
pleiplei: IF FMtimer% THEN RETURN<br>
IF FMinit &lt; 0 THEN PRINT \"FM sound not available.\": END<br>
FMload \"mysidia.s3m\"<br>
' The main loop<br>
WHILE INKEY$ = \"\": WEND<br>
FMend<br>
END</code><br>
Could it any way be simpler than this?<br>
&nbsp;<br><small>
(Note you must copy $funlist to the program, but these do not bother your editing, do they? :)
)</small>

<p>

As an alternative, there is a shorter file \"fm.inc\" which can be simply concatenated
to your program. it works even in QBasic (the stripped version of QuickBasic, distributed
with MS-DOS 4 and 5).<br />
An example of its use can be seen at
<a href=\"http://www.youtube.com/watch?v=TUa5HJUebEA\">Youtube, here</a>.

", '1. Neat features' => "

<ul>
 <li>+Does not require any difficult timing loops or calling a subroutine
      regularly. It works \"behind the scenes\".</li>
 <li>+Supports changing the song any time you want.</li>
 <li>+Uses really little memory.</li>
 <li>-It accesses your hard disk / floppy often: it loads and keeps only
      one pattern at time from the file to memory. You shouldn't notice
      this though if you're using a disk cache program like smartdrv).</li>
 <li>+Allows playing adlib sound effects on the top of music.
      The sound effects are actually music tracks.</li>
 <li>+Entirely written in QuickBasic.
      This does not require any assembler-written modules.</li>
 <li>+The following S3M effects and control codes are supported:<br>
      Axx, Txx, Dxx, Kxx, Exx, Fxx, Hxx, Cxx, Bxx, SBx, SCx, SDx, SEx</li>
 <li>+It supports MPU-401 (midi) playing also.</li>
 <li>+The subroutines are fairly easy to copy to your own program
      to add nice music.</li>
</ul>

", '1. Notes' => "

", '1.1. Example songs' => "

The archive contains some example songs and one example effect file.<br>
Two of the example songs are made by Future Crew, four by me, and two by Warp.

", '1.1. Hazards' => "

The current version just assumes you have MPU-401 too. If you don't have,
just edit the <code>MPUwrite</code> subroutine and add a <code>EXIT&nbsp;SUB</code>
clause there to be the first command.

", '1.1. How does its timer handler work?' => "

It uses <code>ON&nbsp;PLAY</code> event mechanism for the timing,
and plays short silent pause commands. Therefore you can not make
speaker beeps while the player is playing. This does not affect
the performance of the main program.<br>
This causes some problems with dosemu though.

", '1.1. If it does not play anything' => "

In the example program, you must press a key
(try a,b,c,d,e,f,i,j,g,h,v,0,1 keys).<br>
Note that your sound card must really be Adlib compatible.
Creative Sound Blaster AudioPCI&nbsp;128, for example, is not.

", '1.1. Memory usage' => "

The player uses following global static tables, and nothing else:<br>
<table border=1><tr><th>Var</th><th>Size in bytes</th><th>Type</th></tr>
<tr><td>fmperiod</td><td>24</td><td>int[0..11]</td></tr>
<tr><td>order</td><td>512</td><td>int[0..255]</td></tr>
<tr><td>adldata</td><td>2400</td><td>int[1..100,0..11]</td></tr>
<tr><td>insdata</td><td>1200</td><td>{6 ints}[1..100]</td></tr>
<tr><td>adlchan</td><td>896</td><td>{14 ints}[0..31]</td></tr>
<tr><td>MIDInote</td><td>64</td><td>int[0..31]</td></tr>
<tr><td>MIDIchan</td><td>64</td><td>int[0..31]</td></tr>
<tr><td>fmfilename</td><td>4+n</td><td>string</td></tr>
<tr><td>fmpattern</td><td>4+n</td><td>string</td></tr>
<tr><td>fmeffect</td><td>4+n</td><td>string</td></tr>
<tr><td>fmdata</td><td>46</td><td>{17 ints,double,long}</td></tr>
<tr><td>fmeff</td><td>24</td><td>{3 ints}[0..3]</td></tr>
<tr><td align=right>Total:</td><td>5242+n</td><td></td></tr>
</table>
(I am sorry for the big amount of names used, but QuickBasic does not allow putting arrays or dynamic strings inside typedefs.)
<p>
The engine loads and keeps only one pattern at time
from the file to memory. This means that the engine
accesses the media every time the pattern changes.
Patterns usually are about 1kB long per average.

", '1. Discussion' => "

Okay, who uses QuickBASIC today? If you find this program useful,
you are strongly encouraged to <a href=\"#contact\">tell me</a>.<br>
However I'm planning to make a QuickBASIC compiler for *nix systems like Linux.
See the <a href=\"http://iki.fi/bisqwit/source/qbc.html\">project page</a> for details.
You are encouraged to join as a developer if possible :)

", 'contact:1.1. Feedback' => "

If you have problems using this program or ideas how to
develop it, email me your questions or ideas.<br>
Please do not omit the details.<br>
My email address (sigh) is: <em>bisqwit a<b style=\"font-weight:lighter\">t i</b>ki <small>dot</small> fi</em>

", '1. Copying' => "

fmengineqb has been written by Joel Yliluoma, a.k.a.
<a href=\"http://iki.fi/bisqwit/\">Bisqwit</a>,<br>
and is distributed under the following terms:
<blockquote><code>".
str_replace("\n",'<br>',htmlspecialchars(fread(fopen('/WWW/TINYFREELICENSE','r'),filesize('/WWW/TINYFREELICENSE')))).
"</code></blockquote>

", '1. See also' => "

<ul>
 <li><a href=\"/source/sndtool2.html\">sndtool2</a>, which handles
      NES music, is somewhat related to OPL, although NES
      doesn't use FM synthesis (except on one extension chip).</li>
 <li><a href=\"/source/opl3emu.html\">opl3emu</a> emulates the
      OPL3 chip (which is known also as the FM synthesis chip
      or AdLib). Embed it with this player and you don't need
      OPL3 anymore :)</li>
 <li><a href=\"/source/qbc.html\">qbc</a> - I am developing
      a portable QuickBASIC clone. It isn't of any use yet, but
      perhaps it would be if you joined to the development.</li>
</ul>

");
include '/WWW/progdesc.php';
