
#version 120

varying vec2 texcoord;

uniform sampler2D tex;
uniform vec2 resolution;

uniform vec2 halfpixel1;
uniform vec2 halfpixel2;
uniform vec2 halfpixel3;

//const vec3 xmask1 = vec3(-0.00, -0.30, -0.60);
//const vec3 xmask2 = vec3( 0.28,  0.58,  0.88);

const vec3 xmask1 = vec3(-0.00, -0.25, -0.50);
const vec3 xmask2 = vec3( 0.30,  0.55,  0.85);

const vec2 halfxy = vec2( 0.5, 0.5 );

vec3 lookup(vec2 xy)
{
  vec2 ixy = floor(xy); // *resolution); // we premultiply
  vec2 fxy = xy-ixy;
  vec3 mask = step(fxy.y , 0.7) * ( step(fxy.x, xmask2) * step(-fxy.x , xmask1) );
  vec3 rgb = texture2D(tex,(ixy+halfxy)/resolution).rgb;
  return (rgb * mask);  
}

void main()
{  
  //gl_FragColor = texture2D(tex,texcoord);
  
  vec2 t = resolution * ( texcoord  + 0.1 * ( cos(1-cos(3-texcoord*3)) - sin(2+cos(texcoord*2)) ) ) ;
  gl_FragColor.rgb 
    =       ( lookup(t) 
            + lookup(t+halfpixel1) 
            + lookup(t+halfpixel2) 
            + lookup(t+halfpixel3)             
            );
}


