var digi =
{
	trunc: function (a)
	{
		return a < 0.0 ? Math.ceil(a) : Math.floor(a);	
	},
	
	// matrix multiply fr = fa * fb (column-major Float32Array[16])
	matrix4x4Mul: function (fa, fb, fr)
	{
		var a = fa[0];
		var b = fa[1];
		var c = fa[2];
		var d = fa[3];
		var e = fb[0];
		var f = fb[1];
		var g = fb[2];
		var h = fb[3];
		var i = fa[4];
		var j = fa[5];
		var k = fa[6];
		var l = fa[7];
		var m = fa[8];
		var n = fa[9];
		var o = fa[10];
		var p = fa[11];
		var q = fa[12];
		var r = fa[13];
		var s = fa[14];
		var t = fa[15];
		var u = fb[4];
		var v = fb[5];
		var w = fb[6];
		var x = fb[7];
		var y = fb[8];
		var z = fb[9];
		var A = fb[10];
		var B = fb[11];
		var C = fb[12];
		var D = fb[13];
		var E = fb[14];
		var F = fb[15];
		fr[0] = a * e + i * f + m * g + q * h;
		fr[1] = b * e + j * f + n * g + r * h;
		fr[2] = c * e + k * f + o * g + s * h;
		fr[3] = d * e + l * f + p * g + t * h;
		fr[4] = a * u + i * v + m * w + q * x;
		fr[5] = b * u + j * v + n * w + r * x;
		fr[6] = c * u + k * v + o * w + s * x;
		fr[7] = d * u + l * v + p * w + t * x;
		fr[8] = a * y + i * z + m * A + q * B;
		fr[9] = b * y + j * z + n * A + r * B;
		fr[10] = c * y + k * z + o * A + s * B;
		fr[11] = d * y + l * z + p * A + t * B;
		fr[12] = a * C + i * D + m * E + q * F;
		fr[13] = b * C + j * D + n * E + r * F;
		fr[14] = c * C + k * D + o * E + s * F;
		fr[15] = d * C + l * D + p * E + t * F;
	},
	
	// matrix invert fr = inv(fa) (column-major Float32Array[16])
	matrix4x4Inv: function (fa, fr)
	{
		var a = fa[4];
		var b = fa[5];
		var c = fa[6];
		var d = fa[7];
		var e = fa[8];
		var f = fa[9];
		var g = fa[10];
		var h = fa[11];
		var i = fa[12];
		var j = fa[13];
		var k = fa[14];
		var l = fa[15];
		var m = e * l - h * i;
		var n = f * l - h * j;
		var o = g * l - h * k;
		var p = e * k - g * i;
		var q = f * i - e * j;
		var r = g * j - f * k;
		var s = b * o - c * n - d * r;
		var t = c * m - d * p - a * o;
		var u = q * -d + a * n - b * m;
		var v = a * r + b * p + c * q;
		var w = fa[0];
		var x = fa[1];
		var y = fa[2];
		var z = fa[3];
		var A = i * z - l * w;
		var B = j * z - l * x;
		var C = k * z - l * y;
		var D = i * y - k * w;
		var E = j * w - i * x;
		var F = k * x - j * y;
		var G = w * d - z * a;
		var H = x * d - z * b;
		var I = y * d - z * c;
		var J = w * c - y * a;
		var K = x * a - w * b;
		var L = y * b - x * c;
		var M = a * h - d * e;
		var N = b * h - d * f;
		var O = c * h - d * g;
		var P = a * g - c * e;
		var Q = b * e - a * f;
		var R = c * f - b * g;
		var S = 1.0 / (w * s + x * t + y * u + z * v);
		fr[0] = S * s;
		fr[1] = S * -(f * C - g * B - h * F);
		fr[2] = S * (j * I - k * H - l * L);
		fr[3] = S * -(x * O - y * N - z * R);
		fr[4] = S * t;
		fr[5] = S * -(g * A - h * D - e * C);
		fr[6] = S * (k * G - l * J - i * I);
		fr[7] = S * -(y * M - z * P - w * O);
		fr[8] = S * u;
		fr[9] = S * -(E * -h + e * B - f * A);
		fr[10] = S * (K * -l + i * H - j * G);
		fr[11] = S * -(Q * -z + w * N - x * M);
		fr[12] = S * v;
		fr[13] = S * -(e * F + f * D + g * E);
		fr[14] = S * (i * L + j * J + k * K);
		fr[15] = S * -(w * R + x * P + y * Q);
	},

	// calculate projection matrix fr (Float32Array[16]) from camera parameters fp
	matrix4x4Projection: function (fp, viewAspect, fr)
	{
		var a = fp[2];
		var b = fp[3];
		var c = fp[0];
		var d = c * c;
		var e;
		if (d < 2.0)
		{
			e = viewAspect * b > a;
		}
		else
		{
			var f;
			if (d < 5.0)
			{
				f = -1;
			}
			else
			{
				var g;
				if (d < 10.0)
				{
					g = 0;
				}
				else
				{
					g = viewAspect * b < a;
				}
				f = g;
			}
			e = f;
		}
		var h;
		var i;
		if (e != 0)
		{
			h = a;
			i = a / viewAspect;
		}
		else
		{
			h = b * viewAspect;
			i = b;
		}
		var j = fp[1] * 2.0;
		var k = fp[4] * 2.0 / h;
		var l = fp[5] * 2.0 / i;
		var m;
		var n;
		var o;
		var p;
		var q;
		var r;
		var s;
		var t;
		if (c < 0.0)
		{
			var u = fp[6];
			var v = fp[7];
			var w = 1.0 / (u - v);
			m = 0.0;
			n = 0.0;
			o = w * 2.0;
			p = 0.0;
			q = k;
			r = l;
			s = (v + u) * w;
			t = 1.0;
		}
		else
		{
			var x = fp[6];
			var y = fp[7];
			var z = 1.0 / (x - y);
			m = k;
			n = l;
			o = (y + x) * z;
			p = -1.0;
			q = 0.0;
			r = 0.0;
			s = y * 2.0 * x * z;
			t = 0.0;
		}
		fr[0] = j / h;
		fr[1] = 0.0;
		fr[2] = 0.0;
		fr[3] = 0.0;
		fr[4] = 0.0;
		fr[5] = j / i;
		fr[6] = 0.0;
		fr[7] = 0.0;
		fr[8] = m;
		fr[9] = n;
		fr[10] = o;
		fr[11] = p;
		fr[12] = q;
		fr[13] = r;
		fr[14] = s;
		fr[15] = t; 
	},
	
	// create a renderer with given number of pre-allocated render jobs (100 for small scenes, 10000 for large scenes)
	createRenderer: function(numRenderJobs)
	{
		var renderer = digi.createRenderQueues(numRenderJobs);
				
		// create an empty group of scenes. pass it to createScene to create an instance of a scene in the group
		renderer.createGroup = function ()
		{
			var group = {scenes: []};
			
			// update a group of scenes using given time and timeStep (both float)
			group.update = function (time, timeStep)
			{
				var scenes = group.scenes;
				var i;
				for (i = 0; i < scenes.length; ++i)
				{
					scenes[i].update(time, timeStep);
				}
			}
			
			// render a group of scenes using given viewMatrix and projectionMatrix (both Float32Array[16])
			// default render state is assumed and left behind
			group.render = function (viewMatrix, projectionMatrix)
			{
				gl.activeTexture(gl.TEXTURE0);

				var rq = renderer;
				digi.resetRenderQueues(rq);
				
				var scenes = group.scenes;
				var i;
				for (i = 0; i < scenes.length; ++i)
				{
					scenes[i].render(viewMatrix, projectionMatrix, rq);
				}

				if (rq.alphaSort != null)
				{
					gl.enable(gl.BLEND);
					gl.blendFunc(gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
					digi.renderSorted(rq.alphaSort, rq.resetShader)();
					gl.blendFunc(gl.ONE, gl.ZERO);
					gl.disable(gl.BLEND);
				}
				
				gl.useProgram(null);
				gl.bindBuffer(gl.ARRAY_BUFFER, null);
				gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, null);
				gl.disable(gl.CULL_FACE);
				gl.cullFace(gl.BACK);
			}
			
			return group
		}
		
		return renderer;
	},

	
	// internal helper functions
	
	createRenderQueues: function (n)
	{
		var begin = {p: null, n: null, next: null, render: null, instance: null, frenderJob: new Float32Array(17)};
		var end = begin;
		while (n > 1)
		{
			var rj = {p: end, n: null, next: null, render: null, instance: null, frenderJob: new Float32Array(17)};
			end.n = rj;
			end = rj;
			--n;
		}		
		return {
			iBegin: begin, iEnd: end, iResetShader: function () {},
			begin: null, end: null, resetShader: null, alphaSort: null
		};
	},
		
	resetRenderQueues: function(renderQueues)
	{
		renderQueues.begin = renderQueues.iBegin;
		renderQueues.end = renderQueues.iEnd;
		renderQueues.resetShader = renderQueues.iResetShader;
		renderQueues.alphaSort = null;
	},
	
	renderSorted: function(list, resetShader)
	{
		// list merge sort by Simon Tatham
		var insize = 1;
		while (true)
		{
			var p = list;
			list = null;
			var tail = null;
			var nmerges = 0;
			while (p != null)
			{
				nmerges++;
				var q = p;
				var psize = 0;
				var i;
				for (i = 0; i < insize; i++)
				{
					psize++;
					q = q.next;
					if (q == null)
						break;
				}
				var qsize = insize;
				var e;
				while (psize > 0 || (qsize > 0 && q != null))
				{
					if (psize == 0)
					{
						e = q; q = q.next; qsize--;
					}
					else if (qsize == 0 || q == null)
					{
						e = p; p = p.next; psize--;
					}
					else if (p.frenderJob[16] > q.frenderJob[16])
					{
						e = p; p = p.next; psize--;
					}
					else
					{
						e = q; q = q.next; qsize--;
					}
					if (tail != null)
						tail.next = e;
					else
						list = e;
					tail = e;
				}
				p = q;
			}
			tail.next = null;
			if (nmerges <= 1)
				break;
			insize *= 2;
		}
		while (list != null)
		{
			resetShader = list.render(list, resetShader);
			list = list.next;
		}
		return resetShader;
	},
	
	createVertexShader: function (code, name)
	{
		var shader = gl.createShader(gl.VERTEX_SHADER);	
		gl.shaderSource(shader, code);
		gl.compileShader(shader);
		return shader;		
	},
	
	createPixelShader: function (code, name)
	{
		var shader = gl.createShader(gl.FRAGMENT_SHADER);	
		gl.shaderSource(shader, code);
		gl.compileShader(shader);
		return shader;		
	},
	
	eStT: function (xValues, keys, numKeys, x)
	{
		var low = 0;
		var high = numKeys; 		
		var a = (low + high) >> 1;
		while (low < high - 1)
		{
			if (xValues[a] > x)
				high = a;
			else
				low = a;			
			a = (low + high) >> 1;
		}

		return keys[a];
	},
	
	eSpT: function (xValues, keys, numKeys, x)
	{
		var low = 0;
		var high = numKeys; 		
		var a = (low + high) >> 1;
		while (low < high - 1)
		{
			if (xValues[a] > x)
				high = a;
			else
				low = a;			
			a = (low + high) >> 1;
		}		

		var b = a * 3;
		var c = xValues[a];
		var d = (x - c) / (xValues[a + 1] - c);
		var e = d * d;
		var f = e * d;
		return (f * 2.0 + e * -3.0 + 1.0) * keys[b + 1] + (f + e * -2.0 + d) * keys[b + 2] + (f + e * -1.0) * keys[b + 3] + (f * -2.0 + e * 3.0) * keys[b + 4]; 	
	},
	
	eWSpT: function (xValues, keys, numKeys, x)
	{
		var low = 0;
		var high = numKeys; 		
		var a = (low + high) >> 1;
		while (low < high - 1)
		{
			if (xValues[a] > x)
				high = a;
			else
				low = a;			
			a = (low + high) >> 1;
		}

		var b = a * 5;
		var c = xValues[a];
		var d = keys[b + 4];
		var e = keys[b + 5];
		var f = xValues[a + 1];
		var g = x;
		var h = (g - c) / (f - c);
		var i = h * h;
		var j = c * 2.0 + d + e + f * -2.0;
		var k = c * -3.0 + d * -2.0 + e * -1.0 + f * 3.0;
		var l = h - (i * h * j + i * k + h * d + c - g) / (i * 3.0 * j + h * 2.0 * k + d);
		var m = l * l;
		var n = l - (m * l * j + m * k + l * d + c - g) / (m * 3.0 * j + l * 2.0 * k + d);
		var o = n * n;
		var p = n - (o * n * j + o * k + n * d + c - g) / (o * 3.0 * j + n * 2.0 * k + d);
		var q = p * p;
		var r = q * p;
		return (r * 2.0 + q * -3.0 + 1.0) * keys[b + 2] + (r + q * -2.0 + p) * keys[b + 3] + (r + q * -1.0) * keys[b + 6] + (r * -2.0 + q * 3.0) * keys[b + 7]; 		
	},

	getIntVector: function (name, length, infos, istate)
	{
		var info = infos[name];
		if (!info)
			return null;
		if (info.t != 0)
			return null;
		if (info.e - info.b != length)
			return null;
		return istate.subarray(info.b, info.e);
	},
	getIntArray: function (name, infos, istate)
	{
		var info = infos[name];
		if (!info)
			return null;
		if (info.t != 0)
			return null;
		return istate.subarray(info.b, info.e);
	},
	getFloatVector: function (name, length, infos, fstate)
	{
		var info = infos[name];
		if (!info)
			return null;
		if (info.t != 1)
			return null;
		if (info.e - info.b != length)
			return null;
		return fstate.subarray(info.b, info.e);
	},
	getFloatArray: function (name, infos, fstate)
	{
		var info = infos[name];
		if (!info)
			return null;
		if (info.t != 1)
			return null;
		return fstate.subarray(info.b, info.e);
	},
	getTexture: function (name, index, infos, ostate)
	{
		var info = infos[name];
		if (!info)
			return null;
		if (info.t != 2)
			return null;
		var i = index || 0;
		if (i < 0 || i >= info.l)
			return null;
		return ostate[info.b + i];
	},
	setTexture: function (name, texture, index, infos, ostate)
	{
		var info = infos[name];
		if (!info)
			return;
		if (info.t != 2)
			return;
		var i = index || 0;
		if (i < 0 || i >= info.l)
			return;
		ostate[info.b + i] = texture;
	}
};
