//------------------------------------------------------------------------
float3 Ungamma(float3 color)
{
	return pow(color.xyz, 2.2f);
}

float3 Gamma(float3 color)
{
	return pow(color.xyz, 1.f/2.2f);
}

float3 ExpandTextureNormal(float3 v)
{
	return (v - 0.5) * 2;
}

float3 TransformToWorldNormal(float3 tangentNormal, float3 tangentsX, float3 tangentsY, float3 tangentsZ)
{
	float3 worldNormal = 
		tangentNormal.x * tangentsX +
		tangentNormal.y * tangentsY +
		tangentNormal.z * tangentsZ;
		
	return normalize(worldNormal);
}

//------------------------------------------------------------------------
float torch_anim(float time)
{
	return 0.5f*sin(6.f*time) + 0.5f*cos(3.13f*time);
}

float3 torch_light(float time)
{
	float3 l;
	l.r = 1.f + 0.2f*torch_anim(time);
	l.g = l.r;
	l.b = 0.5f*l.r;
	return l;
}

float3 torch_dir(float3 toEye, float time)
{
	return toEye + float3(0.5f*torch_anim(time), 0, -0.5f*torch_anim(0.57f*time)); // slight movement to "torch" position
}

float torch_atten(float3 toEye)
{
	const float falloff = 0.6f;
	const float falloffEnd = 6.f;
	float dist = length( toEye );
	float atten;
	atten = (dist < falloff) ? 1.f : lerp(1.f, 0.f, saturate((dist-falloff)/(falloffEnd-falloff)) );
	atten *= atten;
	return atten;
}
